/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.HashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.graphdb.event.TransactionData;
import org.neo4j.graphdb.event.TransactionEventHandler;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.transaction.FakeXAResource;
import org.neo4j.kernel.impl.transaction.JOTMTransactionManager;
import org.neo4j.test.ImpermanentGraphDatabase;
import org.objectweb.jotm.Jotm;

public class UseJOTMAsTxManagerIT {
    private final TransactionEventHandler<Object> failsBeforeCommitTransactionHandler = new TransactionEventHandler<Object>(){

        public Object beforeCommit(TransactionData data) throws Exception {
            throw new RuntimeException("LURING!");
        }

        public void afterCommit(TransactionData data, Object state) {
        }

        public void afterRollback(TransactionData data, Object state) {
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldStartWithJOTM() {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.tx_manager_impl.name(), "JOTM");
        ImpermanentGraphDatabase db = null;
        try {
            db = new ImpermanentGraphDatabase(config);
            Assert.assertThat((Object)this.txManager((GraphDatabaseAPI)db), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(JOTMTransactionManager.class)));
            Transaction tx = db.beginTx();
            Node node = null;
            try {
                node = db.createNode();
                tx.success();
            }
            finally {
                tx.finish();
            }
            tx = db.beginTx();
            try {
                Assert.assertThat((Object)db.getNodeById(node.getId()), (Matcher)CoreMatchers.is((Object)node));
            }
            finally {
                tx.finish();
            }
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldHandleFailingCommitWithExternalDataSourceGracefully() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.tx_manager_impl.name(), "JOTM");
        ImpermanentGraphDatabase db = null;
        final AtomicBoolean externalResourceWasRolledBack = new AtomicBoolean(false);
        try {
            db = new ImpermanentGraphDatabase(config);
            db.registerTransactionEventHandler(this.failsBeforeCommitTransactionHandler);
            Transaction outerTx = db.beginTx();
            FakeXAResource externalResource = new FakeXAResource("BananaStorageFacility"){

                @Override
                public void rollback(Xid xid) {
                    super.rollback(xid);
                    externalResourceWasRolledBack.set(true);
                }
            };
            this.txManager((GraphDatabaseAPI)db).getTransaction().enlistResource((XAResource)externalResource);
            try {
                db.createNode();
                Transaction innerTx = db.beginTx();
                try {
                    db.createNode();
                    innerTx.success();
                }
                finally {
                    innerTx.finish();
                }
                outerTx.success();
            }
            finally {
                outerTx.finish();
            }
            Assert.fail((String)"Transaction should have failed.");
        }
        catch (TransactionFailureException e) {
        }
        finally {
            if (db != null) {
                db.shutdown();
            }
        }
        Assert.assertThat((Object)externalResourceWasRolledBack.get(), (Matcher)CoreMatchers.is((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldSupportRollbacks() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.tx_manager_impl.name(), "JOTM");
        ImpermanentGraphDatabase neo4j = null;
        try {
            neo4j = new ImpermanentGraphDatabase(config);
            this.txManager((GraphDatabaseAPI)neo4j).begin();
            neo4j.createNode();
            this.txManager((GraphDatabaseAPI)neo4j).rollback();
        }
        finally {
            if (neo4j != null) {
                neo4j.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Ignore(value="When going through Jotm object and UserTransaction we've got no control over begin() which creates the TransactionState object")
    @Test
    public void shouldSupportRollbacksFromUserTransaction() throws Exception {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(GraphDatabaseSettings.tx_manager_impl.name(), "JOTM");
        ImpermanentGraphDatabase neo4j = null;
        try {
            neo4j = new ImpermanentGraphDatabase(config);
            Jotm jotm = ((JOTMTransactionManager)this.txManager((GraphDatabaseAPI)neo4j)).getJotmTxManager();
            UserTransaction userTx = jotm.getUserTransaction();
            userTx.begin();
            neo4j.createNode();
            userTx.rollback();
        }
        finally {
            if (neo4j != null) {
                neo4j.shutdown();
            }
        }
    }

    private TransactionManager txManager(GraphDatabaseAPI db) {
        return (TransactionManager)db.getDependencyResolver().resolveDependency(TransactionManager.class);
    }
}

