/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.Arrays;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.kernel.impl.transaction.XidImpl;

public class XidImplTest {
    private final XidImpl.Seed fixedSeed = new XidImpl.Seed(){

        public long nextSequenceId() {
            return 1L;
        }

        public long nextRandomLong() {
            return 14L;
        }
    };

    @Test
    public void fixedSeedDifferentLocalIdShouldMakeUnequal() throws Exception {
        byte[] globalIdZero = XidImpl.getNewGlobalId((XidImpl.Seed)this.fixedSeed, (int)0);
        byte[] globalIdOne = XidImpl.getNewGlobalId((XidImpl.Seed)this.fixedSeed, (int)1);
        Assert.assertFalse((boolean)Arrays.equals(globalIdZero, globalIdOne));
    }

    @Test
    public void fixedSeedSameLocalIdShouldMakeEqual() throws Exception {
        byte[] globalIdZero = XidImpl.getNewGlobalId((XidImpl.Seed)this.fixedSeed, (int)0);
        byte[] otherGlobalIdZero = XidImpl.getNewGlobalId((XidImpl.Seed)this.fixedSeed, (int)0);
        Assert.assertTrue((boolean)Arrays.equals(globalIdZero, otherGlobalIdZero));
    }

    @Test
    public void defaultSeedDifferentLocalIdShouldMakeUnequal() throws Exception {
        byte[] globalIdZero = XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)0);
        byte[] globalIdOne = XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)1);
        Assert.assertFalse((boolean)Arrays.equals(globalIdZero, globalIdOne));
    }

    @Test
    public void defaultSeedSameLocalIdShouldMakeUnequal() throws Exception {
        byte[] globalIdZero = XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)0);
        byte[] otherGlobalIdZero = XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)0);
        Assert.assertFalse((boolean)Arrays.equals(globalIdZero, otherGlobalIdZero));
    }

    @Test
    public void shouldProduceShortXidToStringForOldGlobalIdFormat() throws Exception {
        XidImpl xid = new XidImpl(this.shorten(XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)10), 4), "test".getBytes());
        String toString = xid.toString();
        Assert.assertThat((Object)toString, (Matcher)CoreMatchers.containsString((String)"NEOKERNL"));
        Assert.assertEquals((long)2L, (long)this.occurencesOf('|', toString));
    }

    @Test
    public void shouldProduceLongerXidToStringForNewGlobalIdFormat() throws Exception {
        XidImpl xid = new XidImpl(XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)10), "test".getBytes());
        String toString = xid.toString();
        Assert.assertThat((Object)toString, (Matcher)CoreMatchers.containsString((String)"NEOKERNL"));
        Assert.assertEquals((long)3L, (long)this.occurencesOf('|', toString));
    }

    private byte[] shorten(byte[] newGlobalId, int byHowMuch) {
        return Arrays.copyOf(newGlobalId, newGlobalId.length - byHowMuch);
    }

    private int occurencesOf(char c, String inString) {
        int count = 0;
        for (int i = 0; i < inString.length(); ++i) {
            if (c != inString.charAt(i)) continue;
            ++count;
        }
        return count;
    }
}

