/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.transaction.KernelHealth;
import org.neo4j.kernel.impl.transaction.xaframework.LogBackedXaDataSource;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBufferFactory;
import org.neo4j.kernel.impl.transaction.xaframework.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.xaframework.XaConnection;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.util.TestLogging;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.TargetDirectory;

public class LogBackedXaDataSourceLogBufferFactoryTest {
    @Rule
    public TargetDirectory.TestDirectory testDir = TargetDirectory.testDirForTest(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldAllowWritingLogicalLog() throws Exception {
        ByteBuffer scratch = ByteBuffer.allocate(1024);
        LogBackedXaDataSource ds = new LogBackedXaDataSource("irrelephant".getBytes(), "irrelephant"){
            private XaLogicalLog logicalLog;
            {
                this.logicalLog = new XaLogicalLog(new File(LogBackedXaDataSourceLogBufferFactoryTest.this.testDir.directory(), "my.log"), null, null, (XaCommandWriterFactory)Mockito.mock(XaCommandWriterFactory.class), null, (FileSystemAbstraction)new DefaultFileSystemAbstraction(), new Monitors(), (Logging)new TestLogging(), null, null, (KernelHealth)Mockito.mock(KernelHealth.class), 100L, null, null, Functions.identity());
            }

            public XaConnection getXaConnection() {
                return null;
            }

            public LogBufferFactory createLogBufferFactory() {
                return this.logicalLog.createLogWriter((Function)new Function<Config, File>(){

                    public File apply(Config config) {
                        return new File(LogBackedXaDataSourceLogBufferFactoryTest.this.testDir.directory(), "my.log");
                    }
                });
            }
        };
        LogBufferFactory logBufferFactory = ds.createLogBufferFactory();
        LogBuffer logFile = null;
        try {
            logFile = logBufferFactory.createActiveLogFile(new Config(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.store_dir.name(), this.testDir.absolutePath()})), -1L);
            logFile.putLong(1337L);
            logFile.force();
            StoreChannel channel = logFile.getFileChannel();
            channel.position(0L);
            long[] headerLongs = VersionAwareLogEntryReader.readLogHeader((ByteBuffer)scratch, (ReadableByteChannel)channel, (boolean)true);
            Assert.assertThat((Object)headerLongs[0], (Matcher)CoreMatchers.equalTo((Object)0L));
            Assert.assertThat((Object)headerLongs[1], (Matcher)CoreMatchers.equalTo((Object)-1L));
            scratch.clear();
            channel.read(scratch);
            scratch.flip();
            Assert.assertThat((Object)scratch.getLong(), (Matcher)CoreMatchers.equalTo((Object)1337L));
        }
        finally {
            if (logFile != null) {
                logFile.getFileChannel().close();
            }
        }
    }
}

