/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import javax.transaction.xa.Xid;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Functions;
import org.neo4j.kernel.impl.nioneo.xa.command.LogHandler;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.TranslatingEntryConsumer;

public class LogEntryConsumerTest {
    @Test
    public void ensureCurrentVersionEntriesAreHandledImmediately() throws Exception {
        TranslatingEntryConsumer consumer = new TranslatingEntryConsumer((Function)Mockito.mock(Function.class));
        LogHandler handler = (LogHandler)Mockito.mock(LogHandler.class);
        consumer.bind(0, handler);
        LogEntry.Start start = new LogEntry.Start((Xid)Mockito.mock(Xid.class), 1, 2, 3, 4L, 5L, 6L);
        consumer.accept((LogEntry)start);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).startEntry(start);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
        LogEntry.Command command = new LogEntry.Command(1, null);
        consumer.accept((LogEntry)command);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).commandEntry(command);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
        LogEntry.OnePhaseCommit onePC = new LogEntry.OnePhaseCommit(1, 2L, 3L);
        consumer.accept((LogEntry)onePC);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).onePhaseCommitEntry(onePC);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
        LogEntry.TwoPhaseCommit twoPC = new LogEntry.TwoPhaseCommit(1, 2L, 3L);
        consumer.accept((LogEntry)twoPC);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).twoPhaseCommitEntry(twoPC);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
        LogEntry.Prepare prepare = new LogEntry.Prepare(1, 2L);
        consumer.accept((LogEntry)prepare);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).prepareEntry(prepare);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
        LogEntry.Done done = new LogEntry.Done(1);
        consumer.accept((LogEntry)done);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).doneEntry(done);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{handler});
    }

    @Test
    public void ensureOldVersionEntriesAreTranslated() throws Exception {
        Function translator = Functions.identity();
        TranslatingEntryConsumer consumer = new TranslatingEntryConsumer(translator);
        LogHandler handler = (LogHandler)Mockito.mock(LogHandler.class);
        consumer.bind(0, handler);
        LogEntry.Start start = new LogEntry.Start((Xid)Mockito.mock(Xid.class), 1, 5, 2, 3, 4L, 5L, 6L);
        consumer.accept((LogEntry)start);
        LogEntry.Command command = new LogEntry.Command(1, 5, null);
        consumer.accept((LogEntry)command);
        LogEntry.OnePhaseCommit onePC = new LogEntry.OnePhaseCommit(1, 5, 2L, 3L);
        consumer.accept((LogEntry)onePC);
        LogEntry.TwoPhaseCommit twoPC = new LogEntry.TwoPhaseCommit(1, 5, 2L, 3L);
        consumer.accept((LogEntry)twoPC);
        LogEntry.Prepare prepare = new LogEntry.Prepare(1, 5, 2L);
        consumer.accept((LogEntry)prepare);
        Mockito.verifyZeroInteractions((Object[])new Object[]{handler});
        LogEntry.Done done = new LogEntry.Done(1, 5);
        consumer.accept((LogEntry)done);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).startEntry(start);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).commandEntry(command);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).onePhaseCommitEntry(onePC);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).twoPhaseCommitEntry(twoPC);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).prepareEntry(prepare);
        ((LogHandler)Mockito.verify((Object)handler, (VerificationMode)Mockito.times((int)1))).doneEntry(done);
    }
}

