/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.xa.LogDeserializer;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.util.Consumer;
import org.neo4j.kernel.impl.util.Cursor;

public class LogMatchers {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<LogEntry> logEntries(FileSystemAbstraction fileSystem, String logPath) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(713);
        try (StoreChannel fileChannel = fileSystem.open(new File(logPath), "r");){
            VersionAwareLogEntryReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)fileChannel, (boolean)true);
            final ArrayList<LogEntry> entries = new ArrayList<LogEntry>();
            LogDeserializer deserializer = new LogDeserializer(buffer, XaCommandReaderFactory.DEFAULT);
            Consumer<LogEntry, IOException> consumer = new Consumer<LogEntry, IOException>(){

                public boolean accept(LogEntry entry) throws IOException {
                    entries.add(entry);
                    return true;
                }
            };
            try (Cursor cursor = deserializer.cursor((ReadableByteChannel)fileChannel);){
                while (cursor.next((Consumer)consumer)) {
                }
            }
            ArrayList<LogEntry> arrayList = entries;
            return arrayList;
        }
    }

    public static List<LogEntry> logEntries(FileSystemAbstraction fileSystem, File file) throws IOException {
        return LogMatchers.logEntries(fileSystem, file.getPath());
    }

    public static Matcher<Iterable<LogEntry>> containsExactly(final Matcher<? extends LogEntry> ... matchers) {
        return new TypeSafeMatcher<Iterable<LogEntry>>(){

            public boolean matchesSafely(Iterable<LogEntry> item) {
                Iterator<LogEntry> actualEntries = item.iterator();
                for (Matcher matcher : matchers) {
                    if (actualEntries.hasNext()) {
                        LogEntry next = actualEntries.next();
                        if (matcher.matches((Object)next)) continue;
                        return false;
                    }
                    return false;
                }
                return !actualEntries.hasNext();
            }

            public void describeTo(Description description) {
                for (Matcher matcher : matchers) {
                    description.appendDescriptionOf((SelfDescribing)matcher).appendText(",\n");
                }
            }
        };
    }

    public static Matcher<? extends LogEntry> startEntry(final Integer identifier, final int masterId, final int localId) {
        return new TypeSafeMatcher<LogEntry.Start>(){

            public boolean matchesSafely(LogEntry.Start entry) {
                return entry != null && entry.getIdentifier() == identifier.intValue() && entry.getMasterId() == masterId && entry.getLocalId() == localId;
            }

            public void describeTo(Description description) {
                description.appendText("Start[" + identifier + ",xid=<Any Xid>,master=" + masterId + ",me=" + localId + ",time=<Any Date>]");
            }
        };
    }

    public static Matcher<? extends LogEntry> onePhaseCommitEntry(final int identifier, final int txId) {
        return new TypeSafeMatcher<LogEntry.OnePhaseCommit>(){

            public boolean matchesSafely(LogEntry.OnePhaseCommit onePC) {
                return onePC != null && onePC.getIdentifier() == identifier && onePC.getTxId() == (long)txId;
            }

            public void describeTo(Description description) {
                description.appendText(String.format("1PC[%d, txId=%d, <Any Date>],", identifier, txId));
            }
        };
    }

    public static Matcher<? extends LogEntry> doneEntry(final int identifier) {
        return new TypeSafeMatcher<LogEntry.Done>(){

            public boolean matchesSafely(LogEntry.Done done) {
                return done != null && done.getIdentifier() == identifier;
            }

            public void describeTo(Description description) {
                description.appendText(String.format("Done[%d]", identifier));
            }
        };
    }

    public static Matcher<? extends LogEntry> commandEntry(final int identifier) {
        return new TypeSafeMatcher<LogEntry.Command>(){

            public boolean matchesSafely(LogEntry.Command cmd) {
                return cmd != null && cmd.getIdentifier() == identifier;
            }

            public void describeTo(Description description) {
                description.appendText(String.format("Command[%d]", identifier));
            }
        };
    }
}

