/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogMatchers;
import org.neo4j.kernel.impl.transaction.xaframework.XaDataSource;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.LogTestUtils;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class TestApplyTransactions {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void testCommittedTransactionReceivedAreForcedToLog() throws Exception {
        File baseStoreDir = new File("base");
        File originStoreDir = new File(baseStoreDir, "origin");
        File destStoreDir = new File(baseStoreDir, "destination");
        GraphDatabaseAPI origin = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase(originStoreDir.getPath());
        Transaction tx = origin.beginTx();
        origin.createNode();
        tx.success();
        tx.finish();
        XaDataSource originNeoDataSource = this.xaDs(origin);
        int latestTxId = (int)originNeoDataSource.getLastCommittedTxId();
        InMemoryLogBuffer theTx = new InMemoryLogBuffer();
        originNeoDataSource.getLogExtractor((long)latestTxId, (long)latestTxId).extractNext((LogBuffer)theTx);
        GraphDatabaseAPI dest = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase(destStoreDir.getPath());
        XaDataSource destNeoDataSource = this.xaDs(dest);
        destNeoDataSource.applyCommittedTransaction((long)latestTxId, (ReadableByteChannel)theTx);
        origin.shutdown();
        EphemeralFileSystemAbstraction snapshot = this.fs.snapshot(EphemeralFileSystemRule.shutdownDb((GraphDatabaseService)dest));
        GraphDatabaseAPI newDest = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(snapshot).newImpermanentDatabase(destStoreDir.getPath());
        destNeoDataSource = ((XaDataSourceManager)newDest.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getXaDataSource("nioneodb");
        latestTxId = (int)destNeoDataSource.getLastCommittedTxId();
        theTx = new InMemoryLogBuffer();
        long extractedTxId = destNeoDataSource.getLogExtractor((long)latestTxId, (long)latestTxId).extractNext((LogBuffer)theTx);
        Assert.assertEquals((long)latestTxId, (long)extractedTxId);
    }

    private XaDataSource xaDs(GraphDatabaseAPI origin) {
        return ((XaDataSourceManager)origin.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getXaDataSource("nioneodb");
    }

    @Test
    public void verifyThatRecoveredTransactionsHaveTheirDoneRecordsWrittenInOrder() throws IOException {
        File originStoreDir = new File(new File("base"), "origin");
        String logicalLogFilename = "logicallog";
        final GraphDatabaseAPI db1 = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabaseBuilder(originStoreDir.getPath()).setConfig(InternalAbstractGraphDatabase.Configuration.logical_log, logicalLogFilename).newGraphDatabase();
        for (int i = 0; i < 100; ++i) {
            Transaction tx = db1.beginTx();
            db1.createNode();
            tx.success();
            tx.finish();
        }
        XaDataSource ds = this.xaDs(db1);
        File archivedLogFilename = ds.getFileName(ds.getCurrentLogVersion());
        this.fs.snapshot(new Runnable(){

            @Override
            public void run() {
                db1.shutdown();
            }
        });
        this.removeDoneEntriesFromLog(new File(archivedLogFilename.getParent(), logicalLogFilename + ".1"));
        GraphDatabaseAPI db2 = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabaseBuilder(originStoreDir.getPath()).setConfig(InternalAbstractGraphDatabase.Configuration.logical_log, logicalLogFilename).newGraphDatabase();
        ds = this.xaDs(db2);
        archivedLogFilename = ds.getFileName(ds.getCurrentLogVersion());
        db2.shutdown();
        List<LogEntry> logEntries = this.filterDoneEntries(LogMatchers.logEntries((FileSystemAbstraction)this.fs.get(), archivedLogFilename));
        String errorMessage = "DONE entries should be in order: " + logEntries;
        int prev = 0;
        for (LogEntry entry : logEntries) {
            int current = entry.getIdentifier();
            Assert.assertThat((String)errorMessage, (Object)current, (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(prev)));
            prev = current;
        }
    }

    private void removeDoneEntriesFromLog(File archivedLogFilename) throws IOException {
        LogTestUtils.LogHookAdapter<LogEntry> doneEntryFilter = new LogTestUtils.LogHookAdapter<LogEntry>(){

            public boolean accept(LogEntry item) {
                return !(item instanceof LogEntry.Done);
            }
        };
        EphemeralFileSystemAbstraction fsa = this.fs.get();
        File tempFile = LogTestUtils.filterNeostoreLogicalLog((FileSystemAbstraction)fsa, archivedLogFilename, (LogTestUtils.LogHook<LogEntry>)doneEntryFilter);
        fsa.deleteFile(archivedLogFilename);
        fsa.renameFile(tempFile, archivedLogFilename);
    }

    private List<LogEntry> filterDoneEntries(List<LogEntry> logEntries) {
        Predicate<LogEntry> doneEntryPredicate = new Predicate<LogEntry>(){

            public boolean accept(LogEntry item) {
                return item instanceof LogEntry.Done;
            }
        };
        return Iterables.toList((Iterable)Iterables.filter((Predicate)doneEntryPredicate, logEntries));
    }
}

