/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.neo4j.graphdb.mockfs.BreakableFileSystemAbstraction;
import org.neo4j.graphdb.mockfs.FileSystemGuard;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;
import org.neo4j.kernel.impl.transaction.xaframework.DirectMappedLogBuffer;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class TestDirectMappedLogBuffer {
    @Test
    public void shouldHandleDiskThatWritesOnlyTwoBytesAtATime() throws Exception {
        FileChannelWithChoppyDisk mockChannel = new FileChannelWithChoppyDisk(2);
        DirectMappedLogBuffer writeBuffer = new DirectMappedLogBuffer((StoreChannel)mockChannel, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
        writeBuffer.put(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16});
        writeBuffer.writeOut();
        Assert.assertThat((Object)mockChannel.buff.position(), (Matcher)Is.is((Object)16));
    }

    @Test(expected=IOException.class)
    public void shouldFailIfUnableToWriteASingleByte() throws Exception {
        FileChannelWithChoppyDisk mockChannel = new FileChannelWithChoppyDisk(0);
        DirectMappedLogBuffer writeBuffer = new DirectMappedLogBuffer((StoreChannel)mockChannel, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
        writeBuffer.put(new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16});
        writeBuffer.writeOut();
    }

    @Test
    @Ignore(value="This test demonstrates a way in which DirectMappedLogBuffer can fail. In particular, using DMLB after anIOException can cause corruption in the underlying file channel. However, it is wrong to use DMLB aftersuch an error anyway, so this not something requiring fixing.")
    public void logBufferWritesContentsTwiceOnFailure() throws Exception {
        final AtomicBoolean broken = new AtomicBoolean(false);
        FileSystemGuard guard = new FileSystemGuard(){

            @Override
            public void checkOperation(FileSystemGuard.OperationType operationType, File onFile, int bytesWrittenTotal, int bytesWrittenThisCall, long channelPosition) throws IOException {
                if (!broken.get() && bytesWrittenTotal == 4) {
                    broken.set(true);
                    throw new IOException("IOException after which this buffer should not be used");
                }
                if (broken.get() && channelPosition == 0L) {
                    throw new IOException("This exception should never happen");
                }
            }
        };
        BreakableFileSystemAbstraction fs = new BreakableFileSystemAbstraction(new EphemeralFileSystemAbstraction(), guard);
        DirectMappedLogBuffer buffer = new DirectMappedLogBuffer(fs.create(new File("log")), (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
        buffer.putInt(1).putInt(2).putInt(3);
        try {
            buffer.writeOut();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        buffer.writeOut();
    }

    @Test
    public void testMonitoringBytesWritten() throws Exception {
        Monitors monitors = new Monitors();
        ByteCounterMonitor monitor = (ByteCounterMonitor)monitors.newMonitor(ByteCounterMonitor.class, new String[0]);
        DirectMappedLogBuffer buffer = new DirectMappedLogBuffer((StoreChannel)new FileChannelWithChoppyDisk(100), monitor);
        final AtomicLong bytesWritten = new AtomicLong();
        monitors.addMonitorListener((Object)new ByteCounterMonitor(){

            public void bytesWritten(long numberOfBytes) {
                bytesWritten.addAndGet(numberOfBytes);
            }

            public void bytesRead(long numberOfBytes) {
            }
        }, new String[0]);
        buffer.put((byte)1);
        Assert.assertEquals((long)0L, (long)bytesWritten.get());
        buffer.force();
        Assert.assertEquals((long)1L, (long)bytesWritten.get());
        buffer.putShort((short)1);
        Assert.assertEquals((long)1L, (long)bytesWritten.get());
        buffer.force();
        Assert.assertEquals((long)3L, (long)bytesWritten.get());
        buffer.putInt(1);
        Assert.assertEquals((long)3L, (long)bytesWritten.get());
        buffer.force();
        Assert.assertEquals((long)7L, (long)bytesWritten.get());
        buffer.putLong(1L);
        Assert.assertEquals((long)7L, (long)bytesWritten.get());
        buffer.force();
        Assert.assertEquals((long)15L, (long)bytesWritten.get());
        buffer.putFloat(1.0f);
        Assert.assertEquals((long)15L, (long)bytesWritten.get());
        buffer.force();
        Assert.assertEquals((long)19L, (long)bytesWritten.get());
        buffer.putDouble(1.0);
        Assert.assertEquals((long)19L, (long)bytesWritten.get());
        buffer.force();
        Assert.assertEquals((long)27L, (long)bytesWritten.get());
        buffer.put(new byte[]{1, 2, 3});
        Assert.assertEquals((long)27L, (long)bytesWritten.get());
        buffer.force();
        Assert.assertEquals((long)30L, (long)bytesWritten.get());
        buffer.put(new char[]{'1', '2', '3'});
        Assert.assertEquals((long)30L, (long)bytesWritten.get());
        buffer.force();
        Assert.assertEquals((long)36L, (long)bytesWritten.get());
        buffer.force();
        Assert.assertEquals((long)36L, (long)bytesWritten.get());
    }

    class FileChannelWithChoppyDisk
    extends StoreFileChannel {
        ByteBuffer buff;
        private int chunkSize;

        public FileChannelWithChoppyDisk(int writeThisMuchAtATime) {
            super((FileChannel)null);
            this.buff = ByteBuffer.allocate(1024);
            this.chunkSize = writeThisMuchAtATime;
        }

        public int write(ByteBuffer byteBuffer, long l) throws IOException {
            int bytesToWrite = this.chunkSize > byteBuffer.limit() - byteBuffer.position() ? byteBuffer.limit() - byteBuffer.position() : this.chunkSize;
            this.buff.position((int)l);
            int originalLimit = byteBuffer.limit();
            byteBuffer.limit(byteBuffer.position() + bytesToWrite);
            this.buff.put(byteBuffer);
            byteBuffer.limit(originalLimit);
            return bytesToWrite;
        }

        public long position() throws IOException {
            return this.buff.position();
        }

        public StoreFileChannel position(long l) throws IOException {
            this.buff.position((int)l);
            return this;
        }

        public long size() throws IOException {
            return this.buff.capacity();
        }

        public StoreFileChannel truncate(long l) throws IOException {
            throw new UnsupportedOperationException();
        }

        public void force(boolean b) throws IOException {
        }
    }
}

