/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.transaction.xa.Xid;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriterv1;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategy;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class TestLogPruneStrategy {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private EphemeralFileSystemAbstraction FS;
    private File directory;
    private static final int MAX_LOG_SIZE = 1000;
    private static final byte[] RESOURCE_XID = new byte[]{5, 6, 7, 8, 9};

    @Before
    public void before() {
        this.FS = this.fs.get();
        this.directory = TargetDirectory.forTest(this.FS, this.getClass()).cleanDirectory("prune");
    }

    @Test
    public void noPruning() throws Exception {
        MockedLogLoader log = new MockedLogLoader(LogPruneStrategies.NO_PRUNING);
        for (int i = 0; i < 100; ++i) {
            log.addTransactionsUntilRotationHappens();
            this.assertLogsRangeExists(log, 0L, log.getHighestLogVersion() - 1L);
        }
        Assert.assertEquals((long)100L, (long)log.getHighestLogVersion());
    }

    @Test
    public void pruneByFileCountWhereAllContainsFilesTransactions() throws Exception {
        int fileCount = 5;
        MockedLogLoader log = new MockedLogLoader(LogPruneStrategies.nonEmptyFileCount((FileSystemAbstraction)this.FS, (int)fileCount));
        for (int i = 0; i < 100; ++i) {
            log.addTransactionsUntilRotationHappens();
            long from = Math.max(0L, log.getHighestLogVersion() - (long)fileCount);
            this.assertLogsRangeExists(log, from, log.getHighestLogVersion() - 1L);
        }
    }

    @Test
    public void pruneByFileCountWhereSomeAreEmpty() throws Exception {
        MockedLogLoader log = new MockedLogLoader(LogPruneStrategies.nonEmptyFileCount((FileSystemAbstraction)this.FS, (int)3));
        log.addTransactionsUntilRotationHappens();
        this.assertLogsRangeExists(log, 0L, 0L);
        log.rotate();
        this.assertLogsRangeExists(log, 0L, 1L, this.empty(1L));
        log.rotate();
        this.assertLogsRangeExists(log, 0L, 2L, this.empty(1L, 2L));
        log.addTransactionsUntilRotationHappens();
        this.assertLogsRangeExists(log, 0L, 3L, this.empty(1L, 2L));
        log.addTransactionsUntilRotationHappens();
        this.assertLogsRangeExists(log, 0L, 4L, this.empty(1L, 2L));
        log.rotate();
        this.assertLogsRangeExists(log, 0L, 5L, this.empty(1L, 2L, 5L));
        log.addTransactionsUntilRotationHappens();
        this.assertLogsRangeExists(log, 3L, 6L, this.empty(5L));
    }

    @Test
    public void pruneByFileSize() throws Exception {
        int maxSize = 5000;
        MockedLogLoader log = new MockedLogLoader(LogPruneStrategies.totalFileSize((FileSystemAbstraction)this.FS, (int)maxSize));
        for (int i = 0; i < 100; ++i) {
            log.addTransactionsUntilRotationHappens();
            Assert.assertTrue((log.getTotalSizeOfAllExistingLogFiles() < maxSize + 1000 ? 1 : 0) != 0);
        }
    }

    @Test
    public void pruneByTransactionCount() throws Exception {
        MockedLogLoader log = new MockedLogLoader(10000, LogPruneStrategies.transactionCount((FileSystemAbstraction)this.FS, (int)1000));
        for (int i = 1; i < 100; ++i) {
            log.addTransactionsUntilRotationHappens();
            int avg = (int)(log.getLastCommittedTxId() / (long)i);
            Assert.assertTrue((log.getTotalTransactionCountOfAllExistingLogFiles() < avg * (i + 1) ? 1 : 0) != 0);
        }
    }

    @Test
    public void pruneByTransactionTimeSpan() throws Exception {
        int seconds = 1;
        int millisToKeep = (int)(TimeUnit.SECONDS.toMillis(seconds) / 10L);
        MockedLogLoader log = new MockedLogLoader(LogPruneStrategies.transactionTimeSpan((FileSystemAbstraction)this.FS, (int)millisToKeep, (TimeUnit)TimeUnit.MILLISECONDS));
        long end = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(seconds);
        long lastTimestamp = System.currentTimeMillis();
        while (true) {
            if (!log.addTransaction(15, lastTimestamp = System.currentTimeMillis())) {
                continue;
            }
            this.assertLogRangeByTimestampExists(log, millisToKeep, lastTimestamp);
            if (System.currentTimeMillis() > end) break;
        }
    }

    @Test
    public void makeSureOneLogStaysEvenWhenZeroFilesIsConfigured() throws Exception {
        this.makeSureOneLogStaysEvenWhenZeroConfigured(new MockedLogLoader(LogPruneStrategies.nonEmptyFileCount((FileSystemAbstraction)this.FS, (int)0)));
    }

    @Test
    public void makeSureOneLogStaysEvenWhenZeroSpaceIsConfigured() throws Exception {
        this.makeSureOneLogStaysEvenWhenZeroConfigured(new MockedLogLoader(LogPruneStrategies.totalFileSize((FileSystemAbstraction)this.FS, (int)0)));
    }

    @Test
    public void makeSureOneLogStaysEvenWhenZeroTransactionsIsConfigured() throws Exception {
        this.makeSureOneLogStaysEvenWhenZeroConfigured(new MockedLogLoader(LogPruneStrategies.transactionCount((FileSystemAbstraction)this.FS, (int)0)));
    }

    @Test
    public void makeSureOneLogStaysEvenWhenZeroTimeIsConfigured() throws Exception {
        this.makeSureOneLogStaysEvenWhenZeroConfigured(new MockedLogLoader(LogPruneStrategies.transactionTimeSpan((FileSystemAbstraction)this.FS, (int)0, (TimeUnit)TimeUnit.SECONDS)));
    }

    private void makeSureOneLogStaysEvenWhenZeroConfigured(MockedLogLoader mockedLogLoader) throws Exception {
        MockedLogLoader log = new MockedLogLoader(LogPruneStrategies.nonEmptyFileCount((FileSystemAbstraction)this.FS, (int)0));
        log.rotate();
        this.assertLogsRangeExists(log, 0L, 0L, this.empty(0L));
        log.rotate();
        this.assertLogsRangeExists(log, 0L, 1L, this.empty(0L, 1L));
        log.addTransactionsUntilRotationHappens();
        this.assertLogsRangeExists(log, 2L, 2L, this.empty(new long[0]));
        log.addTransactionsUntilRotationHappens();
        this.assertLogsRangeExists(log, 3L, 3L, this.empty(new long[0]));
    }

    private void assertLogRangeByTimestampExists(MockedLogLoader log, int millisToKeep, long lastTimestamp) {
        Long firstTimestamp;
        long lowerLimit = lastTimestamp - (long)millisToKeep;
        for (long version = log.getHighestLogVersion() - 1L; version >= 0L && (firstTimestamp = log.getFirstStartRecordTimestamp(version + 1L)) != null; --version) {
            Assert.assertTrue((String)("Log " + version + " should've been deleted by now. first of " + (version + 1L) + ":" + firstTimestamp + ", highestVersion:" + log.getHighestLogVersion() + ", lowerLimit:" + lowerLimit + ", timestamp:" + lastTimestamp), (firstTimestamp >= lowerLimit ? 1 : 0) != 0);
        }
    }

    private void assertLogsRangeExists(MockedLogLoader log, long from, long to) {
        this.assertLogsRangeExists(log, from, to, this.empty(new long[0]));
    }

    private void assertLogsRangeExists(MockedLogLoader log, long from, long to, Set<Long> empty) {
        long i;
        Assert.assertTrue((log.getHighestLogVersion() >= to ? 1 : 0) != 0);
        for (i = 0L; i < from; ++i) {
            Assert.assertFalse((String)("Log v" + i + " shouldn't exist when highest version is " + log.getHighestLogVersion() + " and prune strategy " + log.pruning), (boolean)this.FS.fileExists(log.getFileName(i)));
        }
        for (i = from; i <= to; ++i) {
            File file = log.getFileName(i);
            Assert.assertTrue((String)("Log v" + i + " should exist when highest version is " + log.getHighestLogVersion() + " and prune strategy " + log.pruning), (boolean)this.FS.fileExists(file));
            if (empty.contains(i)) {
                Assert.assertEquals((String)("Log v" + i + " should be empty"), (long)16L, (long)this.FS.getFileSize(file));
                empty.remove(i);
                continue;
            }
            Assert.assertTrue((String)("Log v" + i + " should be at least size " + log.getLogSize()), (this.FS.getFileSize(file) >= (long)log.getLogSize() ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)("Expected to find empty logs: " + empty), (boolean)empty.isEmpty());
    }

    private Set<Long> empty(long ... items) {
        HashSet<Long> result = new HashSet<Long>();
        for (long item : items) {
            result.add(item);
        }
        return result;
    }

    private static class TestXaCommand
    extends XaCommand {
        private final int totalSize;

        public TestXaCommand(int totalSize) {
            this.totalSize = totalSize;
        }

        public int getTotalSize() {
            return this.totalSize;
        }
    }

    private class MockedLogLoader
    implements LogExtractor.LogLoader {
        private long version;
        private long tx;
        private final File baseFile;
        private final ByteBuffer activeBuffer;
        private final int identifier = 1;
        private final LogPruneStrategy pruning;
        private final Map<Long, Long> lastCommittedTxs = new HashMap<Long, Long>();
        private final Map<Long, Long> timestamps = new HashMap<Long, Long>();
        private final int logSize;

        MockedLogLoader(LogPruneStrategy pruning) {
            this(1000, pruning);
        }

        MockedLogLoader(int logSize, LogPruneStrategy pruning) {
            this.logSize = logSize;
            this.pruning = pruning;
            this.activeBuffer = ByteBuffer.allocate(logSize * 10);
            this.baseFile = new File(TestLogPruneStrategy.this.directory, "log");
            this.clearAndWriteHeader();
        }

        public int getLogSize() {
            return this.logSize;
        }

        private void clearAndWriteHeader() {
            this.activeBuffer.clear();
            LogEntryWriterv1.writeLogHeader((ByteBuffer)this.activeBuffer, (long)this.version, (long)this.tx);
            this.activeBuffer.limit(this.activeBuffer.capacity());
            this.activeBuffer.position(16);
        }

        public ReadableByteChannel getLogicalLogOrMyselfCommitted(long version, long position) throws IOException {
            throw new UnsupportedOperationException();
        }

        public long getHighestLogVersion() {
            return this.version;
        }

        public File getFileName(long version) {
            File file = new File(this.baseFile + ".v" + version);
            return file;
        }

        public boolean addTransaction(int commandSize, long date) throws IOException {
            boolean rotate;
            LogEntryWriterv1 writer = new LogEntryWriterv1();
            writer.setCommandWriter(new XaCommandWriter(){

                public void write(XaCommand command, LogBuffer buffer) throws IOException {
                    TestXaCommand test = (TestXaCommand)command;
                    buffer.putInt(test.getTotalSize());
                    buffer.put(new byte[test.getTotalSize() - 4]);
                }
            });
            InMemoryLogBuffer tempLogBuffer = new InMemoryLogBuffer();
            XidImpl xid = new XidImpl(XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)0), RESOURCE_XID);
            writer.writeLogEntry((LogEntry)new LogEntry.Start((Xid)xid, 1, -1, -1, date, -1L, Long.MAX_VALUE), (LogBuffer)tempLogBuffer);
            writer.writeLogEntry((LogEntry)new LogEntry.Command(1, (XaCommand)new TestXaCommand(commandSize)), (LogBuffer)tempLogBuffer);
            writer.writeLogEntry((LogEntry)new LogEntry.OnePhaseCommit(1, ++this.tx, date), (LogBuffer)tempLogBuffer);
            writer.writeLogEntry((LogEntry)new LogEntry.Done(1), (LogBuffer)tempLogBuffer);
            tempLogBuffer.read(this.activeBuffer);
            if (!this.timestamps.containsKey(this.version)) {
                this.timestamps.put(this.version, date);
            }
            boolean bl = rotate = this.activeBuffer.capacity() - this.activeBuffer.remaining() >= this.logSize;
            if (rotate) {
                this.rotate();
            }
            return rotate;
        }

        public void addTransactionsUntilRotationHappens() throws IOException {
            int size = 10;
            while (!this.addTransaction(size, System.currentTimeMillis())) {
                size = Math.max(10, (size + 7) % 100);
            }
            return;
        }

        public void rotate() throws IOException {
            this.lastCommittedTxs.put(this.version, this.tx);
            this.writeBufferToFile(this.activeBuffer, this.getFileName(this.version++));
            this.pruning.prune((LogExtractor.LogLoader)this);
            this.clearAndWriteHeader();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeBufferToFile(ByteBuffer buffer, File fileName) throws IOException {
            try (StoreChannel channel = null;){
                buffer.flip();
                channel = TestLogPruneStrategy.this.FS.open(fileName, "rw");
                channel.write(buffer);
            }
        }

        public int getTotalSizeOfAllExistingLogFiles() {
            int size = 0;
            for (long version = this.getHighestLogVersion() - 1L; version >= 0L; --version) {
                File file = this.getFileName(version);
                if (!TestLogPruneStrategy.this.FS.fileExists(file)) break;
                size = (int)((long)size + TestLogPruneStrategy.this.FS.getFileSize(file));
            }
            return size;
        }

        public int getTotalTransactionCountOfAllExistingLogFiles() {
            long upper;
            long lower;
            if (this.getHighestLogVersion() == 0L) {
                return 0;
            }
            for (lower = upper = this.getHighestLogVersion() - 1L; lower >= 0L; --lower) {
                File file = this.getFileName(lower - 1L);
                if (!TestLogPruneStrategy.this.FS.fileExists(file)) break;
            }
            return (int)(this.getLastCommittedTxId() - this.getFirstCommittedTxId(lower));
        }

        public Long getFirstCommittedTxId(long version) {
            return this.lastCommittedTxs.get(version);
        }

        public Long getFirstStartRecordTimestamp(long version) {
            return this.timestamps.get(version);
        }

        public long getLastCommittedTxId() {
            return this.tx;
        }
    }
}

