/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.test.ImpermanentGraphDatabase;

public class TestLogPruning {
    private GraphDatabaseAPI db;
    private FileSystemAbstraction fs;

    @After
    public void after() throws Exception {
        if (this.db != null) {
            this.db.shutdown();
        }
    }

    @Test
    public void noPruning() throws Exception {
        this.newDb("true");
        for (int i = 0; i < 100; ++i) {
            this.doTransaction();
            this.rotate();
            Assert.assertEquals((long)(i + 1), (long)this.logCount());
        }
    }

    @Test
    public void pruneByFileSize() throws Exception {
        int size = 1050;
        this.newDb(size + " size");
        this.doTransaction();
        this.rotate();
        long sizeOfOneLog = this.fs.getFileSize(this.neoDataSource().getXaContainer().getLogicalLog().getFileName(0L));
        int filesNeededToExceedPruneLimit = (int)Math.ceil((double)size / (double)sizeOfOneLog);
        for (int i = 1; i < filesNeededToExceedPruneLimit * 2; ++i) {
            this.doTransaction();
            this.rotate();
            Assert.assertEquals((long)Math.min(i + 1, filesNeededToExceedPruneLimit), (long)this.logCount());
        }
    }

    private NeoStoreXaDataSource neoDataSource() {
        return ((XaDataSourceManager)this.db.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getNeoStoreDataSource();
    }

    @Test
    public void pruneByFileCount() throws Exception {
        int logsToKeep = 5;
        this.newDb(logsToKeep + " files");
        for (int i = 0; i < logsToKeep * 2; ++i) {
            this.doTransaction();
            this.rotate();
            Assert.assertEquals((long)Math.min(i + 1, logsToKeep), (long)this.logCount());
        }
    }

    @Test
    public void pruneByTransactionCount() throws Exception {
        int transactionsToKeep = 100;
        int txsPerLog = transactionsToKeep / 10;
        this.newDb(transactionsToKeep + " txs");
        for (int i = 0; i < transactionsToKeep / txsPerLog * 3; ++i) {
            for (int j = 0; j < txsPerLog; ++j) {
                this.doTransaction();
            }
            this.rotate();
            Assert.assertEquals((long)Math.min(i + 1, transactionsToKeep / txsPerLog), (long)this.logCount());
        }
    }

    private GraphDatabaseAPI newDb(String logPruning) {
        ImpermanentGraphDatabase db = new ImpermanentGraphDatabase(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.keep_logical_logs.name(), logPruning})){

            @Override
            protected FileSystemAbstraction createFileSystemAbstraction() {
                return TestLogPruning.this.fs = super.createFileSystemAbstraction();
            }
        };
        this.db = db;
        return db;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTransaction() {
        Transaction tx = this.db.beginTx();
        try {
            this.db.createNode();
            tx.success();
        }
        finally {
            tx.finish();
        }
    }

    private void rotate() throws Exception {
        this.neoDataSource().rotateLogicalLog();
    }

    private int logCount() {
        XaLogicalLog log = this.neoDataSource().getXaContainer().getLogicalLog();
        int count = 0;
        for (long i = log.getHighestLogVersion() - 1L; i >= 0L && this.fs.fileExists(log.getFileName(i)); --i) {
            ++count;
        }
        return count;
    }
}

