/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.xa.CommandMatchers;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandWriter;
import org.neo4j.kernel.impl.transaction.xaframework.DirectLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriterv1;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.LogMatchers;
import org.neo4j.kernel.impl.transaction.xaframework.PartialTransactionCopier;
import org.neo4j.kernel.impl.transaction.xaframework.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.util.ArrayMap;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.LogTestUtils;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TestPartialTransactionCopier {
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void shouldCopyRunningTransactionsToNewLog() throws Exception {
        int masterId = -1;
        int meId = -1;
        String storeDir = "dir";
        Pair<File, Integer> broken = this.createBrokenLogFile(storeDir);
        File brokenLogFile = (File)broken.first();
        Integer brokenTxIdentifier = (Integer)broken.other();
        StoreChannel brokenLog = this.fs.get().open(brokenLogFile, "rw");
        ByteBuffer buffer = ByteBuffer.allocate(713);
        VersionAwareLogEntryReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)brokenLog, (boolean)true);
        LogEntryWriterv1 logEntryWriter = new LogEntryWriterv1();
        logEntryWriter.setCommandWriter((XaCommandWriter)new PhysicalLogNeoXaCommandWriter());
        PartialTransactionCopier copier = new PartialTransactionCopier(buffer, XaCommandReaderFactory.DEFAULT, new XaCommandWriterFactory(){

            public XaCommandWriter newInstance() {
                return new PhysicalLogNeoXaCommandWriter();
            }
        }, StringLogger.DEV_NULL, new LogExtractor.LogPositionCache(), null, logEntryWriter, this.createXidMapWithOneStartEntry(masterId, brokenTxIdentifier));
        File newLogFile = new File("new.log");
        copier.copy(brokenLog, this.createNewLogWithHeader(newLogFile), 1L);
        Assert.assertThat(LogMatchers.logEntries((FileSystemAbstraction)this.fs.get(), newLogFile), LogMatchers.containsExactly(LogMatchers.startEntry(brokenTxIdentifier, masterId, meId), CommandMatchers.nodeCommandEntry(brokenTxIdentifier, 1), LogMatchers.onePhaseCommitEntry(brokenTxIdentifier, 3), LogMatchers.startEntry(5, masterId, meId), CommandMatchers.nodeCommandEntry(5, 2), LogMatchers.onePhaseCommitEntry(5, 4), LogMatchers.doneEntry(5), LogMatchers.startEntry(6, masterId, meId), CommandMatchers.nodeCommandEntry(6, 3), LogMatchers.onePhaseCommitEntry(6, 5), LogMatchers.doneEntry(6)));
    }

    private ArrayMap<Integer, LogEntry.Start> createXidMapWithOneStartEntry(int masterId, Integer brokenTxId) {
        ArrayMap xidentMap = new ArrayMap();
        xidentMap.put((Object)brokenTxId, (Object)new LogEntry.Start(null, brokenTxId.intValue(), -1, masterId, 3, 4L, 5L, 6L));
        return xidentMap;
    }

    private LogBuffer createNewLogWithHeader(File newLogFile) throws IOException {
        StoreChannel newLog = this.fs.get().open(newLogFile, "rw");
        DirectLogBuffer newLogBuffer = new DirectLogBuffer(newLog, ByteBuffer.allocate(10000));
        ByteBuffer buf = ByteBuffer.allocate(100);
        LogEntryWriterv1.writeLogHeader((ByteBuffer)buf, (long)1L, (long)4L);
        newLogBuffer.getFileChannel().write(buf);
        return newLogBuffer;
    }

    private Pair<File, Integer> createBrokenLogFile(String storeDir) throws Exception {
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase(storeDir);
        for (int i = 0; i < 4; ++i) {
            Transaction tx = db.beginTx();
            db.createNode();
            tx.success();
            tx.finish();
        }
        db.shutdown();
        final AtomicInteger brokenTxIdentifier = new AtomicInteger();
        LogTestUtils.LogHookAdapter<LogEntry> filter = new LogTestUtils.LogHookAdapter<LogEntry>(){
            int doneRecordCount = 0;

            public boolean accept(LogEntry item) {
                if (item instanceof LogEntry.Done) {
                    ++this.doneRecordCount;
                    if (this.doneRecordCount == 2) {
                        brokenTxIdentifier.set(item.getIdentifier());
                        return false;
                    }
                }
                return true;
            }
        };
        File brokenLogFile = LogTestUtils.filterNeostoreLogicalLog((FileSystemAbstraction)this.fs.get(), new File(storeDir, "nioneo_logical.log.v0"), (LogTestUtils.LogHook<LogEntry>)filter);
        return Pair.of((Object)brokenLogFile, (Object)brokenTxIdentifier.get());
    }
}

