/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.MyRelTypes;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandWriter;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.InMemoryLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriter;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriterv1;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.BatchTransaction;
import org.neo4j.test.DbRepresentation;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class TestStandaloneLogExtractor {
    @Test
    public void testRecreateCleanDbFromStandaloneExtractor() throws Exception {
        this.run(true, 1);
    }

    @Test
    public void testRecreateUncleanDbFromStandaloneExtractor() throws Exception {
        this.run(false, 2);
    }

    private void run(boolean cleanShutdown, int nr) throws Exception {
        EphemeralFileSystemAbstraction snapshot;
        EphemeralFileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
        String storeDir = "source" + nr;
        GraphDatabaseAPI db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(fileSystem).newImpermanentDatabase(storeDir);
        this.createSomeTransactions(db);
        DbRepresentation rep = DbRepresentation.of((GraphDatabaseService)db);
        if (cleanShutdown) {
            db.shutdown();
            snapshot = fileSystem.snapshot();
        } else {
            snapshot = fileSystem.snapshot();
            db.shutdown();
        }
        GraphDatabaseAPI newDb = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(snapshot).newImpermanentDatabase(storeDir);
        NeoStoreXaDataSource ds = ((XaDataSourceManager)newDb.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getNeoStoreDataSource();
        LogEntryWriterv1 logEntryWriter = new LogEntryWriterv1();
        logEntryWriter.setCommandWriter((XaCommandWriter)new PhysicalLogNeoXaCommandWriter());
        LogExtractor extractor = LogExtractor.from((FileSystemAbstraction)snapshot, (XaCommandReaderFactory)XaCommandReaderFactory.DEFAULT, (XaCommandWriterFactory)new XaCommandWriterFactory(){

            public XaCommandWriter newInstance() {
                return new PhysicalLogNeoXaCommandWriter();
            }
        }, (ByteCounterMonitor)((ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0])), (LogEntryWriter)logEntryWriter, (File)new File(storeDir));
        long expectedTxId = 2L;
        while (true) {
            InMemoryLogBuffer buffer = new InMemoryLogBuffer();
            long txId = extractor.extractNext((LogBuffer)buffer);
            Assert.assertEquals((long)expectedTxId++, (long)txId);
            if (expectedTxId == 11L) {
                expectedTxId = -1L;
            }
            if (txId == -1L) break;
            ds.applyCommittedTransaction(txId, (ReadableByteChannel)buffer);
        }
        DbRepresentation newRep = DbRepresentation.of((GraphDatabaseService)newDb);
        newDb.shutdown();
        Assert.assertEquals((Object)rep, (Object)newRep);
        fileSystem.shutdown();
    }

    private void createSomeTransactions(GraphDatabaseAPI db) throws IOException {
        try (BatchTransaction tx = BatchTransaction.beginBatchTx((GraphDatabaseService)db);){
            Node node = db.createNode();
            node.setProperty("name", (Object)"First");
            Node otherNode = db.createNode();
            node.createRelationshipTo(otherNode, (RelationshipType)MyRelTypes.TEST);
            tx.intermediaryCommit();
            ((XaDataSourceManager)db.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getNeoStoreDataSource().rotateLogicalLog();
            for (int i = 0; i < 5; ++i) {
                db.createNode().setProperty("type", (Object)i);
                tx.intermediaryCommit();
            }
        }
    }
}

