/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.util.Random;
import javax.transaction.xa.Xid;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class TestTxEntries {
    private final Random random = new Random();
    private final long refTime = System.currentTimeMillis();
    private final int refId = 1;
    private final int refMaster = 1;
    private final int refMe = 1;
    private final long startPosition = 1000L;
    private final String storeDir = "dir";
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();

    @Test
    public void testStartEntryWrittenOnceOnRollback() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase("dir");
        this.createSomeTransactions(db);
        EphemeralFileSystemAbstraction snapshot = this.fs.snapshot(EphemeralFileSystemRule.shutdownDb(db));
        new TestGraphDatabaseFactory().setFileSystem(snapshot).newImpermanentDatabase("dir").shutdown();
    }

    @Test
    public void startEntryShouldBeUniqueIfEitherValueChanges() throws Exception {
        this.assertCorrectChecksumEquality(this.randomXid(Boolean.TRUE));
        this.assertCorrectChecksumEquality(this.randomXid(Boolean.FALSE));
    }

    private void assertCorrectChecksumEquality(Xid refXid) {
        LogEntry.Start ref = new LogEntry.Start(refXid, 1, 1, 1, 1000L, this.refTime, 0L);
        this.assertChecksumsEquals(ref, new LogEntry.Start(refXid, 1, 1, 1, 1000L, this.refTime, 0L));
        this.assertChecksumsNotEqual(ref, new LogEntry.Start(this.randomXid(null), 1, 1, 1, 1000L, this.refTime, 0L));
        this.assertChecksumsNotEqual(ref, new LogEntry.Start(refXid, 1, 2, 1, 1000L, this.refTime, 0L));
        this.assertChecksumsNotEqual(ref, new LogEntry.Start(refXid, 1, 1, 2, 1000L, this.refTime, 0L));
    }

    private void assertChecksumsNotEqual(LogEntry.Start ref, LogEntry.Start other) {
        Assert.assertFalse((ref.getChecksum() == other.getChecksum() ? 1 : 0) != 0);
    }

    private void assertChecksumsEquals(LogEntry.Start ref, LogEntry.Start other) {
        Assert.assertEquals((long)ref.getChecksum(), (long)other.getChecksum());
    }

    private Xid randomXid(Boolean trueForPositive) {
        XidImpl xid;
        do {
            xid = new XidImpl(this.randomBytes(), this.randomBytes());
        } while (trueForPositive != null && xid.hashCode() > 0 != trueForPositive);
        return xid;
    }

    private byte[] randomBytes() {
        byte[] bytes = new byte[this.random.nextInt(10) + 5];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)this.random.nextInt(255);
        }
        return bytes;
    }

    private void createSomeTransactions(GraphDatabaseService db) {
        Transaction tx = db.beginTx();
        Node node1 = db.createNode();
        Node node2 = db.createNode();
        node1.createRelationshipTo(node2, (RelationshipType)DynamicRelationshipType.withName((String)"relType1"));
        tx.success();
        tx.finish();
        tx = db.beginTx();
        node1.delete();
        tx.success();
        try {
            tx.finish();
        }
        catch (Exception nothingToSeeHereMoveAlong) {
            // empty catch block
        }
        tx = db.beginTx();
        node1.setProperty("foo", (Object)"bar");
        tx.success();
        tx.finish();
    }
}

