/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.xa.LogDeserializer;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.transaction.XaDataSourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.util.Consumer;
import org.neo4j.kernel.impl.util.Cursor;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class TestTxTimestamps {
    private final EphemeralFileSystemAbstraction fileSystem = new EphemeralFileSystemAbstraction();
    private GraphDatabaseAPI db;

    @Before
    public void doBefore() throws Exception {
        this.db = (GraphDatabaseAPI)new TestGraphDatabaseFactory().setFileSystem(this.fileSystem).newImpermanentDatabaseBuilder().setConfig(GraphDatabaseSettings.keep_logical_logs, "true").newGraphDatabase();
    }

    @After
    public void doAfter() throws Exception {
        this.db.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void doIt() throws Exception {
        long[] expectedStartTimestamps = new long[10];
        long[] expectedCommitTimestamps = new long[expectedStartTimestamps.length];
        for (int i = 0; i < expectedStartTimestamps.length; ++i) {
            Transaction tx = this.db.beginTx();
            expectedStartTimestamps[i] = System.currentTimeMillis();
            Node node = this.db.createNode();
            node.setProperty("name", (Object)("Mattias " + i));
            tx.success();
            tx.finish();
            expectedCommitTimestamps[i] = System.currentTimeMillis();
        }
        ((XaDataSourceManager)this.db.getDependencyResolver().resolveDependency(XaDataSourceManager.class)).getNeoStoreDataSource().rotateLogicalLog();
        ByteBuffer buffer = ByteBuffer.allocate(512000);
        try (StoreChannel channel = this.fileSystem.open(new File(this.db.getStoreDir(), "nioneo_logical.log.v0"), "r");){
            VersionAwareLogEntryReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)channel, (boolean)true);
            AConsumer consumer = new AConsumer(expectedCommitTimestamps, expectedStartTimestamps);
            LogDeserializer deserializer = new LogDeserializer(buffer, XaCommandReaderFactory.DEFAULT);
            try (Cursor cursor = deserializer.cursor((ReadableByteChannel)channel);){
                while (cursor.next((Consumer)consumer)) {
                }
            }
            Assert.assertEquals((long)expectedCommitTimestamps.length, (long)consumer.getFoundTxCount());
        }
    }

    private class AConsumer
    implements Consumer<LogEntry, IOException> {
        private int foundTxCount;
        private boolean skippedFirstTx = false;
        private final long[] expectedCommitTimestamps;
        private final long[] expectedStartTimestamps;

        private AConsumer(long[] expectedCommitTimestamps, long[] expectedStartTimestamps) {
            this.expectedCommitTimestamps = expectedCommitTimestamps;
            this.expectedStartTimestamps = expectedStartTimestamps;
        }

        public int getFoundTxCount() {
            return this.foundTxCount;
        }

        public boolean accept(LogEntry entry) throws IOException {
            if (!this.skippedFirstTx) {
                if (entry instanceof LogEntry.Commit) {
                    this.skippedFirstTx = true;
                }
                return true;
            }
            if (entry instanceof LogEntry.Start) {
                long diff = ((LogEntry.Start)entry).getTimeWritten() - this.expectedStartTimestamps[this.foundTxCount];
                long exp = this.expectedCommitTimestamps[this.foundTxCount] - this.expectedStartTimestamps[this.foundTxCount];
                Assert.assertTrue((String)(diff + " <= " + exp), (diff <= exp ? 1 : 0) != 0);
            } else if (entry instanceof LogEntry.Commit) {
                long diff = ((LogEntry.Commit)entry).getTimeWritten() - this.expectedCommitTimestamps[this.foundTxCount];
                long exp = this.expectedCommitTimestamps[this.foundTxCount] - this.expectedStartTimestamps[this.foundTxCount];
                Assert.assertTrue((String)(diff + " <= " + exp), (diff <= exp ? 1 : 0) != 0);
                ++this.foundTxCount;
            }
            return true;
        }
    }
}

