/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLogFiles;

public class TestXaLogicalLogFiles {
    @Test
    public void shouldDetectLegacyLogs() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists(new File("logical_log.active"))).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists(new File("logical_log"))).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists(new File("logical_log.1"))).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists(new File("logical_log.2"))).thenReturn((Object)false);
        XaLogicalLogFiles files = new XaLogicalLogFiles(new File("logical_log"), fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.LEGACY_WITHOUT_LOG_ROTATION));
    }

    @Test
    public void shouldDetectNoActiveFile() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists(new File("logical_log.active"))).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists(new File("logical_log"))).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists(new File("logical_log.1"))).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists(new File("logical_log.2"))).thenReturn((Object)false);
        XaLogicalLogFiles files = new XaLogicalLogFiles(new File("logical_log"), fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.NO_ACTIVE_FILE));
    }

    @Test
    public void shouldDetectLog1Active() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists(new File("logical_log.active"))).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists(new File("logical_log"))).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists(new File("logical_log.1"))).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists(new File("logical_log.2"))).thenReturn((Object)false);
        StoreChannel fc = this.mockedStoreChannel('1');
        Mockito.when((Object)fs.open((File)Matchers.eq((Object)new File("logical_log.active")), Matchers.anyString())).thenReturn((Object)fc);
        XaLogicalLogFiles files = new XaLogicalLogFiles(new File("logical_log"), fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.LOG_1_ACTIVE));
    }

    @Test
    public void shouldDetectLog2Active() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists(new File("logical_log.active"))).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists(new File("logical_log"))).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists(new File("logical_log.1"))).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists(new File("logical_log.2"))).thenReturn((Object)true);
        StoreChannel fc = this.mockedStoreChannel('2');
        Mockito.when((Object)fs.open((File)Matchers.eq((Object)new File("logical_log.active")), Matchers.anyString())).thenReturn((Object)fc);
        XaLogicalLogFiles files = new XaLogicalLogFiles(new File("logical_log"), fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.LOG_2_ACTIVE));
    }

    @Test
    public void shouldDetectCleanShutdown() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists(new File("logical_log.active"))).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists(new File("logical_log"))).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists(new File("logical_log.1"))).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists(new File("logical_log.2"))).thenReturn((Object)false);
        StoreChannel fc = this.mockedStoreChannel('C');
        Mockito.when((Object)fs.open((File)Matchers.eq((Object)new File("logical_log.active")), Matchers.anyString())).thenReturn((Object)fc);
        XaLogicalLogFiles files = new XaLogicalLogFiles(new File("logical_log"), fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.CLEAN));
    }

    @Test
    public void shouldDetectDualLog1() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists(new File("logical_log.active"))).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists(new File("logical_log"))).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists(new File("logical_log.1"))).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists(new File("logical_log.2"))).thenReturn((Object)true);
        StoreChannel fc = this.mockedStoreChannel('1');
        Mockito.when((Object)fs.open((File)Matchers.eq((Object)new File("logical_log.active")), Matchers.anyString())).thenReturn((Object)fc);
        XaLogicalLogFiles files = new XaLogicalLogFiles(new File("logical_log"), fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.DUAL_LOGS_LOG_1_ACTIVE));
    }

    @Test
    public void shouldDetectDualLog2() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists(new File("logical_log.active"))).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists(new File("logical_log"))).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists(new File("logical_log.1"))).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists(new File("logical_log.2"))).thenReturn((Object)true);
        StoreChannel fc = this.mockedStoreChannel('2');
        Mockito.when((Object)fs.open((File)Matchers.eq((Object)new File("logical_log.active")), Matchers.anyString())).thenReturn((Object)fc);
        XaLogicalLogFiles files = new XaLogicalLogFiles(new File("logical_log"), fs);
        Assert.assertThat((Object)files.determineState(), (Matcher)CoreMatchers.is((Object)XaLogicalLogFiles.State.DUAL_LOGS_LOG_2_ACTIVE));
    }

    @Test(expected=IllegalStateException.class)
    public void shouldThrowIllegalStateExceptionOnUnrecognizedActiveContent() throws Exception {
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.mock(FileSystemAbstraction.class);
        Mockito.when((Object)fs.fileExists(new File("logical_log.active"))).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists(new File("logical_log"))).thenReturn((Object)false);
        Mockito.when((Object)fs.fileExists(new File("logical_log.1"))).thenReturn((Object)true);
        Mockito.when((Object)fs.fileExists(new File("logical_log.2"))).thenReturn((Object)true);
        StoreChannel fc = this.mockedStoreChannel(';');
        Mockito.when((Object)fs.open((File)Matchers.eq((Object)new File("logical_log.active")), Matchers.anyString())).thenReturn((Object)fc);
        XaLogicalLogFiles files = new XaLogicalLogFiles(new File("logical_log"), fs);
        files.determineState();
    }

    private StoreChannel mockedStoreChannel(char c) throws IOException {
        return new MockedFileChannel(ByteBuffer.allocate(4).putChar(c).array());
    }

    private static class MockedFileChannel
    extends StoreFileChannel {
        private ByteBuffer bs;

        public MockedFileChannel(byte[] bs) {
            super((FileChannel)null);
            this.bs = ByteBuffer.wrap(bs);
        }

        public long position() throws IOException {
            return this.bs.position();
        }

        public int read(ByteBuffer buffer) throws IOException {
            int start = this.bs.position();
            buffer.put(this.bs);
            return this.bs.position() - start;
        }

        public void close() throws IOException {
        }
    }
}

