/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.transaction.xaframework.IllegalLogFormatException;
import org.neo4j.kernel.impl.transaction.xaframework.LogExtractor;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;

public class TransactionCountPruneStrategyTest {
    @Test
    public void shouldConsiderOldVersionLogsOutOfDateForTx() throws Exception {
        LogPruneStrategies.TransactionCountPruneStrategy pruner = new LogPruneStrategies.TransactionCountPruneStrategy(null, 100);
        LogPruneStrategies.Threshold threshold = pruner.newThreshold();
        LogExtractor.LogLoader logLoader = (LogExtractor.LogLoader)Mockito.mock(LogExtractor.LogLoader.class);
        Mockito.when((Object)logLoader.getFirstCommittedTxId(Mockito.anyLong())).thenThrow(new Throwable[]{new RuntimeException((Throwable)new IllegalLogFormatException(3L, 2L))});
        boolean reached = threshold.reached(null, 1L, logLoader);
        Assert.assertTrue((boolean)reached);
    }

    @Test
    public void shouldPanicIfHitNewerVersionLog() throws Exception {
        LogPruneStrategies.TransactionCountPruneStrategy pruner = new LogPruneStrategies.TransactionCountPruneStrategy(null, 100);
        LogPruneStrategies.Threshold threshold = pruner.newThreshold();
        LogExtractor.LogLoader logLoader = (LogExtractor.LogLoader)Mockito.mock(LogExtractor.LogLoader.class);
        Mockito.when((Object)logLoader.getFirstCommittedTxId(Mockito.anyLong())).thenThrow(new Throwable[]{new RuntimeException((Throwable)new IllegalLogFormatException(3L, 5L))});
        try {
            threshold.reached(null, 1L, logLoader);
            Assert.fail((String)"Should've thrown exception");
        }
        catch (RuntimeException e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.equalTo((Object)"Unable to read database logs, because it contains logs from a newer version of Neo4j."));
        }
    }
}

