/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.transaction.xaframework.EideticTransactionMonitor;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.TestGraphDatabaseFactory;

public class TransactionMonitorTest {
    @Test
    public void shouldCountCommittedTransactions() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        Monitors monitors = (Monitors)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(Monitors.class);
        EideticTransactionMonitor monitor = new EideticTransactionMonitor();
        monitors.addMonitorListener((Object)monitor, new String[]{XaResourceManager.class.getName(), "nioneodb"});
        Transaction tx = db.beginTx();
        db.createNode();
        tx.success();
        tx.finish();
        Assert.assertEquals((long)1L, (long)monitor.getCommitCount());
        Assert.assertEquals((long)0L, (long)monitor.getInjectOnePhaseCommitCount());
        Assert.assertEquals((long)0L, (long)monitor.getInjectTwoPhaseCommitCount());
    }

    @Test
    public void shouldNotCountRolledBackTransactions() throws Exception {
        GraphDatabaseService db = new TestGraphDatabaseFactory().newImpermanentDatabase();
        Monitors monitors = (Monitors)((GraphDatabaseAPI)db).getDependencyResolver().resolveDependency(Monitors.class);
        EideticTransactionMonitor monitor = new EideticTransactionMonitor();
        monitors.addMonitorListener((Object)monitor, new String[]{XaResourceManager.class.getName(), "nioneodb"});
        Transaction tx = db.beginTx();
        db.createNode();
        tx.failure();
        tx.finish();
        Assert.assertEquals((long)0L, (long)monitor.getCommitCount());
        Assert.assertEquals((long)0L, (long)monitor.getInjectOnePhaseCommitCount());
        Assert.assertEquals((long)0L, (long)monitor.getInjectTwoPhaseCommitCount());
    }
}

