/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.xaframework;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.List;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.number.OrderingComparison;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.listeners.InvocationListener;
import org.mockito.listeners.MethodInvocationReport;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.neo4j.helpers.Functions;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.core.KernelPanicEventGenerator;
import org.neo4j.kernel.impl.core.TransactionState;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;
import org.neo4j.kernel.impl.nioneo.xa.LogDeserializer;
import org.neo4j.kernel.impl.nioneo.xa.NeoStoreXaDataSource;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReader;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriterFactory;
import org.neo4j.kernel.impl.transaction.KernelHealth;
import org.neo4j.kernel.impl.transaction.TransactionStateFactory;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.ForceMode;
import org.neo4j.kernel.impl.transaction.xaframework.InjectedTransactionValidator;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriterv1;
import org.neo4j.kernel.impl.transaction.xaframework.LogPruneStrategies;
import org.neo4j.kernel.impl.transaction.xaframework.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.xaframework.XaCommand;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.transaction.xaframework.XaResourceManager;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransaction;
import org.neo4j.kernel.impl.transaction.xaframework.XaTransactionFactory;
import org.neo4j.kernel.impl.util.Consumer;
import org.neo4j.kernel.impl.util.Cursor;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.DevNullLoggingService;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SingleLoggingService;
import org.neo4j.kernel.monitoring.Monitors;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.FailureOutput;
import org.neo4j.test.TargetDirectory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class XaLogicalLogTest {
    @Rule
    public final FailureOutput output = new FailureOutput();
    private static final byte[] RESOURCE_ID = new byte[]{0, -103, -52};
    private long version;
    private int reads;
    @Rule
    public final EphemeralFileSystemRule ephemeralFs = new EphemeralFileSystemRule();
    public final Xid xid = new XidImpl("global".getBytes(), "resource".getBytes());

    @Test
    public void shouldRotateLogWithDoneRecordsOrEarlierTransactionsInTheRegionToCopy() throws Exception {
        EphemeralFileSystemAbstraction fs = this.ephemeralFs.get();
        XaTransactionFactory xaTf = (XaTransactionFactory)Mockito.mock(XaTransactionFactory.class);
        Mockito.when((Object)xaTf.getAndSetNewVersion()).thenAnswer((Answer)new TxVersion(true));
        Mockito.when((Object)xaTf.getCurrentVersion()).thenAnswer((Answer)new TxVersion(false));
        File dir = TargetDirectory.forTest(fs, XaLogicalLogTest.class).cleanDirectory("log");
        XaLogicalLog xaLogicalLog = new XaLogicalLog(new File(dir, "logical.log"), (XaResourceManager)Mockito.mock(XaResourceManager.class), (XaCommandReaderFactory)Mockito.mock(XaCommandReaderFactory.class), (XaCommandWriterFactory)Mockito.mock(XaCommandWriterFactory.class), xaTf, (FileSystemAbstraction)fs, new Monitors(), (Logging)new SingleLoggingService(StringLogger.wrap((Writer)this.output.writer())), LogPruneStrategies.NO_PRUNING, (TransactionStateFactory)Mockito.mock(TransactionStateFactory.class), (KernelHealth)Mockito.mock(KernelHealth.class), 0x1900000L, InjectedTransactionValidator.ALLOW_ALL, Functions.identity(), Functions.identity());
        xaLogicalLog.open();
        int tx0 = xaLogicalLog.start((Xid)new XidImpl(XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)0), RESOURCE_ID), -1, 0, 0L);
        xaLogicalLog.writeStartEntry(tx0);
        xaLogicalLog.commitOnePhase(tx0, 1L, ForceMode.forced);
        xaLogicalLog.done(tx0);
        int tx1 = xaLogicalLog.start((Xid)new XidImpl(XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)0), RESOURCE_ID), -1, 0, 0L);
        int tx2 = xaLogicalLog.start((Xid)new XidImpl(XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)0), RESOURCE_ID), -1, 0, 0L);
        int tx3 = xaLogicalLog.start((Xid)new XidImpl(XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)0), RESOURCE_ID), -1, 0, 0L);
        xaLogicalLog.writeStartEntry(tx1);
        xaLogicalLog.prepare(tx1);
        xaLogicalLog.writeStartEntry(tx2);
        xaLogicalLog.prepare(tx2);
        xaLogicalLog.commitTwoPhase(tx1, 2L, ForceMode.forced);
        xaLogicalLog.done(tx1);
        xaLogicalLog.writeStartEntry(tx3);
        xaLogicalLog.rotate();
        xaLogicalLog.close();
        StoreChannel log = fs.open(new File(dir, "logical.log.2"), "r");
        ByteBuffer buffer = ByteBuffer.allocateDirect(713);
        VersionAwareLogEntryReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)log, (boolean)false);
        LogDeserializer deserializer = new LogDeserializer(buffer, null);
        Cursor cursor = deserializer.cursor((ReadableByteChannel)log);
        Consumer consumer = (Consumer)Mockito.mock(Consumer.class);
        Mockito.when((Object)consumer.accept(Mockito.any(LogEntry.class))).thenReturn((Object)true);
        while (cursor.next(consumer)) {
        }
        ArgumentCaptor entryCaptor = ArgumentCaptor.forClass(LogEntry.class);
        ((Consumer)Mockito.verify((Object)consumer, (VerificationMode)Mockito.times((int)7))).accept(entryCaptor.capture());
        List entries = entryCaptor.getAllValues();
        Assert.assertThat(entries.get(0), this.isEntry(LogEntry.Start.class, tx2));
        Assert.assertThat(entries.get(1), this.isEntry(LogEntry.Prepare.class, tx2));
        Assert.assertThat(entries.get(2), this.isEntry(LogEntry.Start.class, tx1));
        Assert.assertThat(entries.get(3), this.isEntry(LogEntry.Prepare.class, tx1));
        Assert.assertThat(entries.get(4), this.isEntry(LogEntry.TwoPhaseCommit.class, tx1));
        Assert.assertThat(entries.get(5), this.isEntry(LogEntry.Done.class, tx1));
        Assert.assertThat(entries.get(6), this.isEntry(LogEntry.Start.class, tx3));
    }

    private Matcher<? super LogEntry> isEntry(final Class<? extends LogEntry> entryType, final int txId) {
        return new TypeSafeMatcher<LogEntry>(entryType){

            protected boolean matchesSafely(LogEntry item) {
                return item.getIdentifier() == txId;
            }

            public void describeTo(Description description) {
                description.appendText(entryType.getSimpleName()).appendText(" entry with id ").appendValue((Object)txId);
            }
        };
    }

    @Test
    public void shouldNotReadExcessivelyFromTheFileChannelWhenRotatingLogWithNoOpenTransactions() throws Exception {
        XaTransactionFactory xaTf = (XaTransactionFactory)Mockito.mock(XaTransactionFactory.class);
        Mockito.when((Object)xaTf.getAndSetNewVersion()).thenAnswer((Answer)new TxVersion(true));
        Mockito.when((Object)xaTf.getCurrentVersion()).thenAnswer((Answer)new TxVersion(false));
        FileSystemAbstraction fs = (FileSystemAbstraction)Mockito.spy((Object)((Object)this.ephemeralFs.get()));
        File dir = TargetDirectory.forTest(fs, XaLogicalLogTest.class).cleanDirectory("log");
        Mockito.when((Object)fs.open(new File(dir, "logical.log.1"), "rw")).thenAnswer((Answer)new Answer<StoreChannel>(){

            public StoreChannel answer(InvocationOnMock invocation) throws Throwable {
                StoreFileChannel channel = (StoreFileChannel)invocation.callRealMethod();
                return (StoreChannel)Mockito.mock(channel.getClass(), (MockSettings)Mockito.withSettings().spiedInstance((Object)channel).name("channel").defaultAnswer(Mockito.CALLS_REAL_METHODS).invocationListeners(new InvocationListener[]{new InvocationListener(){

                    public void reportInvocation(MethodInvocationReport methodInvocationReport) {
                        if (methodInvocationReport.getInvocation().toString().startsWith("channel.read(")) {
                            XaLogicalLogTest.this.reads++;
                        }
                    }
                }}));
            }
        });
        XaLogicalLog xaLogicalLog = new XaLogicalLog(new File(dir, "logical.log"), (XaResourceManager)Mockito.mock(XaResourceManager.class), (XaCommandReaderFactory)Mockito.mock(XaCommandReaderFactory.class), (XaCommandWriterFactory)Mockito.mock(XaCommandWriterFactory.class), xaTf, fs, new Monitors(), (Logging)new SingleLoggingService(StringLogger.wrap((Writer)this.output.writer())), LogPruneStrategies.NO_PRUNING, (TransactionStateFactory)Mockito.mock(TransactionStateFactory.class), (KernelHealth)Mockito.mock(KernelHealth.class), 0x1900000L, InjectedTransactionValidator.ALLOW_ALL, Functions.identity(), Functions.identity());
        xaLogicalLog.open();
        for (int txId = 1; txId <= 10; ++txId) {
            int identifier = xaLogicalLog.start((Xid)new XidImpl(XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)0), RESOURCE_ID), -1, 0, 1337L);
            xaLogicalLog.writeStartEntry(identifier);
            xaLogicalLog.commitOnePhase(identifier, (long)txId, ForceMode.forced);
            xaLogicalLog.done(identifier);
        }
        xaLogicalLog.rotate();
        Assert.assertThat((String)"should not read excessively from the logical log file channel", (Object)this.reads, (Matcher)OrderingComparison.lessThan((Comparable)Integer.valueOf(10)));
    }

    @Test
    public void shouldRespectCustomLogRotationThreshold() throws Exception {
        long maxSize = 1000L;
        this.ephemeralFs.get().mkdir(new File("asd"));
        XaLogicalLog log = new XaLogicalLog(new File("asd/log"), (XaResourceManager)Mockito.mock(XaResourceManager.class), XaCommandReaderFactory.DEFAULT, new XaCommandWriterFactory(){

            public XaCommandWriter newInstance() {
                return new FixedSizeXaCommandWriter();
            }
        }, (XaTransactionFactory)new VersionRespectingXaTransactionFactory(), (FileSystemAbstraction)this.ephemeralFs.get(), new Monitors(), (Logging)new DevNullLoggingService(), LogPruneStrategies.NO_PRUNING, (TransactionStateFactory)Mockito.mock(TransactionStateFactory.class), (KernelHealth)Mockito.mock(KernelHealth.class), maxSize, InjectedTransactionValidator.ALLOW_ALL, Functions.identity(), Functions.identity());
        log.open();
        long initialLogVersion = log.getHighestLogVersion();
        for (int i = 0; i < 10; ++i) {
            int identifier = log.start(this.xid, -1, -1, 1337L);
            log.writeStartEntry(identifier);
            log.writeCommand((XaCommand)new FixedSizeXaCommand(100), identifier);
            log.commitOnePhase(identifier, (long)(i + 1), ForceMode.forced);
            log.done(identifier);
        }
        Assert.assertEquals((long)(initialLogVersion + 1L), (long)log.getHighestLogVersion());
    }

    @Test
    public void shouldDetermineHighestArchivedLogVersionFromFileNamesIfTheyArePresent() throws Exception {
        int lowAndIncorrectLogVersion = 0;
        EphemeralFileSystemAbstraction fs = this.ephemeralFs.get();
        File dir = new File("db");
        fs.mkdir(dir);
        fs.create(new File(dir, "log.v100")).close();
        fs.create(new File(dir, "log.v101")).close();
        StoreChannel active = fs.create(new File(dir, "log.1"));
        ByteBuffer buff = ByteBuffer.allocate(128);
        LogEntryWriterv1.writeLogHeader((ByteBuffer)buff, (long)lowAndIncorrectLogVersion, (long)0L);
        active.write(buff);
        active.force(false);
        active.close();
        XaLogicalLog log = new XaLogicalLog(new File(dir, "log"), (XaResourceManager)Mockito.mock(XaResourceManager.class), XaCommandReaderFactory.DEFAULT, new XaCommandWriterFactory(){

            public XaCommandWriter newInstance() {
                return new FixedSizeXaCommandWriter();
            }
        }, (XaTransactionFactory)new VersionRespectingXaTransactionFactory(), (FileSystemAbstraction)this.ephemeralFs.get(), new Monitors(), (Logging)new DevNullLoggingService(), LogPruneStrategies.NO_PRUNING, (TransactionStateFactory)Mockito.mock(TransactionStateFactory.class), (KernelHealth)Mockito.mock(KernelHealth.class), 10L, InjectedTransactionValidator.ALLOW_ALL, Functions.identity(), Functions.identity());
        log.open();
        log.rotate();
        Assert.assertThat((Object)fs.fileExists(new File(dir, "log.v102")), (Matcher)org.hamcrest.Matchers.equalTo((Object)true));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotPrepareAfterKernelPanicHasHappened() throws Exception {
        File directory = TargetDirectory.forTest(this.getClass()).cleanDirectory("shouldNotPrepareAfterKernelPanicHasHappened");
        Logging mockLogging = (Logging)Mockito.mock(Logging.class);
        Mockito.when((Object)mockLogging.getMessagesLog((Class)Matchers.any())).thenReturn(Mockito.mock(StringLogger.class));
        KernelHealth health = new KernelHealth((KernelPanicEventGenerator)Mockito.mock(KernelPanicEventGenerator.class), mockLogging);
        long maxSize = 1000L;
        File logFile = new File(directory, "log");
        RandomAccessFile forCheckingSize = null;
        XaLogicalLog log = null;
        try {
            forCheckingSize = new RandomAccessFile(logFile, "rw");
            log = new XaLogicalLog(logFile, (XaResourceManager)Mockito.mock(XaResourceManager.class), XaCommandReaderFactory.DEFAULT, new XaCommandWriterFactory(){

                public XaCommandWriter newInstance() {
                    return new FixedSizeXaCommandWriter();
                }
            }, (XaTransactionFactory)new VersionRespectingXaTransactionFactory(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), new Monitors(), (Logging)new DevNullLoggingService(), LogPruneStrategies.NO_PRUNING, (TransactionStateFactory)Mockito.mock(TransactionStateFactory.class), health, maxSize, InjectedTransactionValidator.ALLOW_ALL, Functions.identity(), Functions.identity());
            log.open();
            int identifier = log.start((Xid)new XidImpl(XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)1), NeoStoreXaDataSource.BRANCH_ID), -1, -1, -1L);
            log.writeStartEntry(identifier);
            long sizeBeforePanic = forCheckingSize.getChannel().size();
            health.panic((Throwable)new MockException());
            try {
                log.prepare(identifier);
                Assert.fail();
            }
            catch (XAException e) {
                Assert.assertEquals(MockException.class, e.getCause().getClass());
            }
            Assert.assertEquals((long)sizeBeforePanic, (long)forCheckingSize.getChannel().size());
        }
        finally {
            if (log != null) {
                log.close();
            }
            if (forCheckingSize != null) {
                forCheckingSize.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotCommitOnePhaseAfterKernelPanicHasHappened() throws Exception {
        File directory = TargetDirectory.forTest(this.getClass()).cleanDirectory("shouldNotPrepareAfterKernelPanicHasHappened");
        Logging mockLogging = (Logging)Mockito.mock(Logging.class);
        Mockito.when((Object)mockLogging.getMessagesLog((Class)Matchers.any())).thenReturn(Mockito.mock(StringLogger.class));
        KernelHealth health = new KernelHealth((KernelPanicEventGenerator)Mockito.mock(KernelPanicEventGenerator.class), mockLogging);
        long maxSize = 1000L;
        File logFile = new File(directory, "log");
        RandomAccessFile forCheckingSize = null;
        XaLogicalLog log = null;
        try {
            forCheckingSize = new RandomAccessFile(logFile, "rw");
            log = new XaLogicalLog(logFile, (XaResourceManager)Mockito.mock(XaResourceManager.class), XaCommandReaderFactory.DEFAULT, new XaCommandWriterFactory(){

                public XaCommandWriter newInstance() {
                    return new FixedSizeXaCommandWriter();
                }
            }, (XaTransactionFactory)new VersionRespectingXaTransactionFactory(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), new Monitors(), (Logging)new DevNullLoggingService(), LogPruneStrategies.NO_PRUNING, (TransactionStateFactory)Mockito.mock(TransactionStateFactory.class), health, maxSize, InjectedTransactionValidator.ALLOW_ALL, Functions.identity(), Functions.identity());
            log.open();
            int identifier = log.start((Xid)new XidImpl(XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)1), NeoStoreXaDataSource.BRANCH_ID), -1, -1, -1L);
            log.writeStartEntry(identifier);
            long sizeBeforePanic = forCheckingSize.getChannel().size();
            health.panic((Throwable)new MockException());
            try {
                log.commitOnePhase(identifier, 2L, ForceMode.forced);
                Assert.fail();
            }
            catch (XAException e) {
                Assert.assertEquals(MockException.class, e.getCause().getClass());
            }
            Assert.assertEquals((long)sizeBeforePanic, (long)forCheckingSize.getChannel().size());
        }
        finally {
            if (log != null) {
                log.close();
            }
            if (forCheckingSize != null) {
                forCheckingSize.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldNotCommitTwoPhaseAfterKernelPanicHasHappened() throws Exception {
        File directory = TargetDirectory.forTest(this.getClass()).cleanDirectory("shouldNotPrepareAfterKernelPanicHasHappened");
        Logging mockLogging = (Logging)Mockito.mock(Logging.class);
        Mockito.when((Object)mockLogging.getMessagesLog((Class)Matchers.any())).thenReturn(Mockito.mock(StringLogger.class));
        KernelHealth health = new KernelHealth((KernelPanicEventGenerator)Mockito.mock(KernelPanicEventGenerator.class), mockLogging);
        long maxSize = 1000L;
        File logFile = new File(directory, "log");
        RandomAccessFile forCheckingSize = null;
        XaLogicalLog log = null;
        try {
            forCheckingSize = new RandomAccessFile(logFile, "rw");
            log = new XaLogicalLog(logFile, (XaResourceManager)Mockito.mock(XaResourceManager.class), XaCommandReaderFactory.DEFAULT, new XaCommandWriterFactory(){

                public XaCommandWriter newInstance() {
                    return new FixedSizeXaCommandWriter();
                }
            }, (XaTransactionFactory)new VersionRespectingXaTransactionFactory(), (FileSystemAbstraction)new DefaultFileSystemAbstraction(), new Monitors(), (Logging)new DevNullLoggingService(), LogPruneStrategies.NO_PRUNING, (TransactionStateFactory)Mockito.mock(TransactionStateFactory.class), health, maxSize, InjectedTransactionValidator.ALLOW_ALL, Functions.identity(), Functions.identity());
            log.open();
            int identifier = log.start((Xid)new XidImpl(XidImpl.getNewGlobalId((XidImpl.Seed)XidImpl.DEFAULT_SEED, (int)1), NeoStoreXaDataSource.BRANCH_ID), -1, -1, -1L);
            log.writeStartEntry(identifier);
            long sizeBeforePanic = forCheckingSize.getChannel().size();
            health.panic((Throwable)new MockException());
            try {
                log.commitTwoPhase(identifier, 2L, ForceMode.forced);
                Assert.fail();
            }
            catch (XAException e) {
                Assert.assertEquals(MockException.class, e.getCause().getClass());
            }
            Assert.assertEquals((long)sizeBeforePanic, (long)forCheckingSize.getChannel().size());
        }
        finally {
            if (log != null) {
                log.close();
            }
            if (forCheckingSize != null) {
                forCheckingSize.close();
            }
        }
    }

    private static class MockException
    extends RuntimeException {
        private MockException() {
        }
    }

    private static class VersionRespectingXaTransactionFactory
    extends XaTransactionFactory {
        private long currentVersion = 0L;

        private VersionRespectingXaTransactionFactory() {
        }

        public XaTransaction create(long lastCommittedTxWhenTransactionStarted, TransactionState state) {
            return (XaTransaction)Mockito.mock(XaTransaction.class);
        }

        public void flushAll() {
        }

        public long getCurrentVersion() {
            return this.currentVersion;
        }

        public long getAndSetNewVersion() {
            return ++this.currentVersion;
        }

        public void setVersion(long version) {
            this.currentVersion = version;
        }

        public long getLastCommittedTx() {
            return 0L;
        }
    }

    private class TxVersion
    implements Answer<Object> {
        private final boolean update;
        public static final boolean UPDATE_AND_GET = true;
        public static final boolean GET = false;

        TxVersion(boolean update) {
            this.update = update;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object answer(InvocationOnMock invocation) throws Throwable {
            XaLogicalLogTest xaLogicalLogTest = XaLogicalLogTest.this;
            synchronized (xaLogicalLogTest) {
                if (this.update) {
                    XaLogicalLogTest.this.version++;
                }
                return XaLogicalLogTest.this.version;
            }
        }
    }

    private static class FixedSizeXaCommandWriter
    implements XaCommandWriter {
        private FixedSizeXaCommandWriter() {
        }

        public void write(XaCommand command, LogBuffer buffer) throws IOException {
            FixedSizeXaCommand fixed = (FixedSizeXaCommand)command;
            buffer.putShort((short)(fixed.getData().length + 2));
            buffer.put(fixed.getData());
        }
    }

    private static class FixedSizeXaCommandReader
    implements XaCommandReader {
        private ByteBuffer buffer;

        private FixedSizeXaCommandReader(ByteBuffer buffer) {
            this.buffer = buffer;
        }

        public XaCommand read(ReadableByteChannel byteChannel) throws IOException {
            short dataSize = IoPrimitiveUtils.readShort((ReadableByteChannel)byteChannel, (ByteBuffer)this.buffer);
            IoPrimitiveUtils.readBytes((ReadableByteChannel)byteChannel, (byte[])new byte[dataSize]);
            return new FixedSizeXaCommand(dataSize);
        }
    }

    private static class FixedSizeXaCommand
    extends XaCommand {
        private final byte[] data;

        FixedSizeXaCommand(int payloadSize) {
            this.data = new byte[payloadSize - 2];
        }

        public byte[] getData() {
            return this.data;
        }
    }
}

