/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import java.util.Arrays;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class TestMultiPruneEvaluators
extends TraversalTestBase {
    @Before
    public void setupGraph() {
        this.createGraph("a to b", "a to c", "a to d", "a to e", "b to f", "b to g", "b to h", "c to i", "d to j", "d to k", "d to l", "e to m", "e to n", "k to o", "k to p", "k to q", "k to r");
    }

    @Test
    public void testMaxDepthAndCustomPruneEvaluatorCombined() {
        Evaluator lessThanThreeRels = new Evaluator(){

            public Evaluation evaluate(Path path) {
                return IteratorUtil.count(path.endNode().getRelationships(Direction.OUTGOING).iterator()) < 3 ? Evaluation.INCLUDE_AND_PRUNE : Evaluation.INCLUDE_AND_CONTINUE;
            }
        };
        TraversalDescription description = Traversal.traversal().evaluator(Evaluators.all()).evaluator(Evaluators.toDepth((int)1)).evaluator(lessThanThreeRels);
        HashSet<String> expectedNodes = new HashSet<String>(Arrays.asList("a", "b", "c", "d", "e"));
        Transaction tx = this.beginTx();
        for (Path position : description.traverse(this.node("a"))) {
            String name = (String)position.endNode().getProperty("name");
            Assert.assertTrue((String)(name + " shouldn't have been returned"), (boolean)expectedNodes.remove(name));
        }
        tx.success();
        tx.finish();
        Assert.assertTrue((boolean)expectedNodes.isEmpty());
    }
}

