/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpanders;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class TestMultiRelTypesAndDirections
extends TraversalTestBase {
    private static final RelationshipType ONE = DynamicRelationshipType.withName((String)"ONE");

    @Before
    public void setupGraph() {
        this.createGraph("A ONE B", "B ONE C", "A TWO C");
    }

    @Test
    public void testCIsReturnedOnDepthTwoDepthFirst() {
        this.testCIsReturnedOnDepthTwo(Traversal.traversal().depthFirst());
    }

    @Test
    public void testCIsReturnedOnDepthTwoBreadthFirst() {
        this.testCIsReturnedOnDepthTwo(Traversal.traversal().breadthFirst());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testCIsReturnedOnDepthTwo(TraversalDescription description) {
        Transaction transaction = this.beginTx();
        try {
            description = description.expand(PathExpanders.forTypeAndDirection((RelationshipType)ONE, (Direction)Direction.OUTGOING));
            int i = 0;
            for (Path position : description.traverse(this.node("A"))) {
                Assert.assertEquals((long)i++, (long)position.length());
            }
        }
        finally {
            transaction.finish();
        }
    }
}

