/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.BidirectionalTraversalDescription;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.kernel.impl.traversal.TraversalTestBase;

public class TestPath
extends TraversalTestBase {
    private static Node a;
    private static Node b;
    private static Node c;
    private static Node d;
    private static Node e;
    private Transaction tx;

    @Before
    public void setup() {
        this.createGraph("A TO B", "B TO C", "C TO D", "D TO E");
        this.tx = this.beginTx();
        a = this.getNodeWithName("A");
        b = this.getNodeWithName("B");
        c = this.getNodeWithName("C");
        d = this.getNodeWithName("D");
        e = this.getNodeWithName("E");
    }

    @After
    public void tearDown() {
        this.tx.finish();
    }

    @Test
    public void testPathIterator() {
        Path path = (Path)Traversal.traversal().evaluator(Evaluators.atDepth((int)4)).traverse(this.node("A")).iterator().next();
        this.assertPathIsCorrect(path);
    }

    @Test
    public void reverseNodes() throws Exception {
        Path path = (Path)IteratorUtil.first((Iterable)Traversal.traversal().evaluator(Evaluators.atDepth((int)0)).traverse(a));
        TestPath.assertContains(path.reverseNodes(), a);
        path = (Path)IteratorUtil.first((Iterable)Traversal.traversal().evaluator(Evaluators.atDepth((int)4)).traverse(a));
        TestPath.assertContainsInOrder(path.reverseNodes(), e, d, c, b, a);
    }

    @Test
    public void reverseRelationships() throws Exception {
        Path path = (Path)IteratorUtil.first((Iterable)Traversal.traversal().evaluator(Evaluators.atDepth((int)0)).traverse(a));
        Assert.assertFalse((boolean)path.reverseRelationships().iterator().hasNext());
        path = (Path)IteratorUtil.first((Iterable)Traversal.traversal().evaluator(Evaluators.atDepth((int)4)).traverse(a));
        Node[] expectedNodes = new Node[]{e, d, c, b, a};
        int index = 0;
        for (Relationship rel : path.reverseRelationships()) {
            Assert.assertEquals((String)("For index " + index), (Object)expectedNodes[index++], (Object)rel.getEndNode());
        }
        Assert.assertEquals((long)4L, (long)index);
    }

    @Test
    public void testBidirectionalPath() throws Exception {
        TraversalDescription side = Traversal.traversal().uniqueness((UniquenessFactory)Uniqueness.NODE_PATH);
        BidirectionalTraversalDescription bidirectional = Traversal.bidirectionalTraversal().mirroredSides(side);
        Path bidirectionalPath = (Path)IteratorUtil.first((Iterable)bidirectional.traverse(a, e));
        this.assertPathIsCorrect(bidirectionalPath);
        Assert.assertEquals((Object)a, (Object)((Path)IteratorUtil.first((Iterable)bidirectional.traverse(a, e))).startNode());
        bidirectionalPath = (Path)IteratorUtil.first((Iterable)bidirectional.traverse(a, e));
        bidirectionalPath.relationships();
        Assert.assertEquals((Object)a, (Object)bidirectionalPath.startNode());
        bidirectionalPath = (Path)IteratorUtil.first((Iterable)bidirectional.traverse(a, e));
        bidirectionalPath.nodes();
        Assert.assertEquals((Object)a, (Object)bidirectionalPath.startNode());
        bidirectionalPath = (Path)IteratorUtil.first((Iterable)bidirectional.traverse(a, e));
        bidirectionalPath.reverseRelationships();
        Assert.assertEquals((Object)a, (Object)bidirectionalPath.startNode());
        bidirectionalPath = (Path)IteratorUtil.first((Iterable)bidirectional.traverse(a, e));
        bidirectionalPath.reverseNodes();
        Assert.assertEquals((Object)a, (Object)bidirectionalPath.startNode());
        bidirectionalPath = (Path)IteratorUtil.first((Iterable)bidirectional.traverse(a, e));
        bidirectionalPath.iterator();
        Assert.assertEquals((Object)a, (Object)bidirectionalPath.startNode());
    }

    private void assertPathIsCorrect(Path path) {
        Node a = this.node("A");
        Relationship to1 = (Relationship)a.getRelationships(Direction.OUTGOING).iterator().next();
        Node b = to1.getEndNode();
        Relationship to2 = (Relationship)b.getRelationships(Direction.OUTGOING).iterator().next();
        Node c = to2.getEndNode();
        Relationship to3 = (Relationship)c.getRelationships(Direction.OUTGOING).iterator().next();
        Node d = to3.getEndNode();
        Relationship to4 = (Relationship)d.getRelationships(Direction.OUTGOING).iterator().next();
        Node e = to4.getEndNode();
        Assert.assertEquals((Object)4, (Object)path.length());
        Assert.assertEquals((Object)a, (Object)path.startNode());
        Assert.assertEquals((Object)e, (Object)path.endNode());
        Assert.assertEquals((Object)to4, (Object)path.lastRelationship());
        TestPath.assertContainsInOrder(path, new PropertyContainer[]{a, to1, b, to2, c, to3, d, to4, e});
        TestPath.assertContainsInOrder(path.nodes(), a, b, c, d, e);
        TestPath.assertContainsInOrder(path.relationships(), to1, to2, to3, to4);
        TestPath.assertContainsInOrder(path.reverseNodes(), e, d, c, b, a);
        TestPath.assertContainsInOrder(path.reverseRelationships(), to4, to3, to2, to1);
    }
}

