/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;
import org.neo4j.helpers.Clock;
import org.neo4j.helpers.FakeClock;
import org.neo4j.kernel.impl.util.FlyweightPool;

public class FlyweightPoolTest {
    @Test
    public void shouldTimeoutGracefully() throws InterruptedException {
        FakeClock clock = new FakeClock();
        FlyweightPool.CheckStrategy.TimeoutCheckStrategy timeStrategy = new FlyweightPool.CheckStrategy.TimeoutCheckStrategy(100L, (Clock)clock);
        while (clock.currentTimeMillis() <= 100L) {
            Assert.assertFalse((boolean)timeStrategy.shouldCheck());
            clock.forward(10L, TimeUnit.MILLISECONDS);
        }
        Assert.assertTrue((boolean)timeStrategy.shouldCheck());
        clock.forward(1L, TimeUnit.MILLISECONDS);
        Assert.assertFalse((boolean)timeStrategy.shouldCheck());
    }

    @Test
    public void shouldBuildUpGracefullyUntilReachedMinPoolSize() throws InterruptedException {
        StatefulMonitor stateMonitor = new StatefulMonitor();
        FakeClock clock = new FakeClock();
        FlyweightPool<Object> pool = this.getFlyweightPool(stateMonitor, clock, 5);
        this.acquireFromPool(pool, 5);
        Assert.assertEquals((long)-1L, (long)stateMonitor.currentPeakSize.get());
        Assert.assertEquals((long)-1L, (long)stateMonitor.targetSize.get());
        Assert.assertEquals((long)0L, (long)stateMonitor.disposed.get());
    }

    @Test
    public void shouldBuildUpGracefullyWhilePassingMinPoolSizeBeforeTimerRings() throws InterruptedException {
        StatefulMonitor stateMonitor = new StatefulMonitor();
        FakeClock clock = new FakeClock();
        FlyweightPool<Object> pool = this.getFlyweightPool(stateMonitor, clock, 5);
        this.acquireFromPool(pool, 15);
        Assert.assertEquals((long)-1L, (long)stateMonitor.currentPeakSize.get());
        Assert.assertEquals((long)15L, (long)stateMonitor.created.get());
        Assert.assertEquals((long)-1L, (long)stateMonitor.targetSize.get());
        Assert.assertEquals((long)0L, (long)stateMonitor.disposed.get());
    }

    @Test
    public void shouldUpdateTargetSizeWhenSpikesOccur() throws Exception {
        int MIN_SIZE = 5;
        int MAX_SIZE = 10;
        StatefulMonitor stateMonitor = new StatefulMonitor();
        FakeClock clock = new FakeClock();
        FlyweightPool<Object> pool = this.getFlyweightPool(stateMonitor, clock, 5);
        List<FlyweightHolder<Object>> holders = this.acquireFromPool(pool, 10);
        clock.forward(110L, TimeUnit.MILLISECONDS);
        holders.addAll(this.acquireFromPool(pool, 1));
        Assert.assertEquals((long)11L, (long)stateMonitor.currentPeakSize.get());
        Assert.assertEquals((long)11L, (long)stateMonitor.targetSize.get());
        for (FlyweightHolder<Object> holder : holders) {
            holder.end();
        }
    }

    @Test
    public void shouldKeepSmallPeakAndNeverDisposeIfAcquireAndReleaseContinuously() throws Exception {
        boolean MIN_SIZE = true;
        StatefulMonitor stateMonitor = new StatefulMonitor();
        FakeClock clock = new FakeClock();
        FlyweightPool<Object> pool = this.getFlyweightPool(stateMonitor, clock, 1);
        for (int i = 0; i < 200; ++i) {
            List<FlyweightHolder<Object>> newOnes = this.acquireFromPool(pool, 1);
            CountDownLatch release = new CountDownLatch(newOnes.size());
            for (FlyweightHolder<Object> newOne : newOnes) {
                newOne.release(release);
            }
            release.await();
        }
        Assert.assertEquals((long)-1L, (long)stateMonitor.currentPeakSize.get());
        Assert.assertEquals((long)1L, (long)stateMonitor.created.get());
        Assert.assertEquals((long)0L, (long)stateMonitor.disposed.get());
    }

    @Test
    public void shouldSlowlyReduceTheNumberOfFlyweightsInThePoolWhenFlyweightsAreReleased() throws Exception {
        int MIN_SIZE = 50;
        int MAX_SIZE = 200;
        StatefulMonitor stateMonitor = new StatefulMonitor();
        FakeClock clock = new FakeClock();
        FlyweightPool<Object> pool = this.getFlyweightPool(stateMonitor, clock, 50);
        LinkedList<FlyweightHolder<Object>> holders = new LinkedList<FlyweightHolder<Object>>();
        this.buildAPeakOfAcquiredFlyweightsAndTriggerAlarmWithSideEffects(200, clock, pool, holders);
        clock.forward(110L, TimeUnit.MILLISECONDS);
        for (int i = 0; i < 200; ++i) {
            this.acquireFromPool(pool, 1).get(0).release();
        }
        Assert.assertEquals((long)1L, (long)stateMonitor.currentPeakSize.get());
        Assert.assertEquals((long)50L, (long)stateMonitor.targetSize.get());
        Assert.assertEquals((long)151L, (long)stateMonitor.disposed.get());
    }

    @Test
    public void shouldMaintainPoolAtHighWatermarkWhenConcurrentUsagePassesMinSize() throws Exception {
        int MIN_SIZE = 50;
        int MAX_SIZE = 200;
        int MID_SIZE = 90;
        StatefulMonitor stateMonitor = new StatefulMonitor();
        FakeClock clock = new FakeClock();
        FlyweightPool<Object> pool = this.getFlyweightPool(stateMonitor, clock, 50);
        LinkedList<FlyweightHolder<Object>> holders = new LinkedList<FlyweightHolder<Object>>();
        this.buildAPeakOfAcquiredFlyweightsAndTriggerAlarmWithSideEffects(200, clock, pool, holders);
        clock.forward(110L, TimeUnit.MILLISECONDS);
        for (int i = 0; i < 10; ++i) {
            CountDownLatch release = new CountDownLatch(90);
            for (FlyweightHolder<Object> holder : this.acquireFromPool(pool, 90)) {
                holder.release(release);
            }
            release.await();
            clock.forward(110L, TimeUnit.MILLISECONDS);
        }
        Assert.assertEquals((long)90L, (long)stateMonitor.currentPeakSize.get());
        Assert.assertEquals((long)90L, (long)stateMonitor.targetSize.get());
        Assert.assertEquals((long)111L, (long)stateMonitor.disposed.get());
    }

    @Test
    public void shouldReclaimAndRecreateWhenLullBetweenSpikesOccurs() throws Exception {
        int MIN_SIZE = 50;
        int BELOW_MIN_SIZE = 10;
        int MAX_SIZE = 200;
        StatefulMonitor stateMonitor = new StatefulMonitor();
        FakeClock clock = new FakeClock();
        FlyweightPool<Object> pool = this.getFlyweightPool(stateMonitor, clock, 50);
        LinkedList<FlyweightHolder<Object>> holders = new LinkedList<FlyweightHolder<Object>>();
        this.buildAPeakOfAcquiredFlyweightsAndTriggerAlarmWithSideEffects(200, clock, pool, holders);
        clock.forward(110L, TimeUnit.MILLISECONDS);
        for (int i = 0; i < 30; ++i) {
            CountDownLatch release = new CountDownLatch(10);
            for (FlyweightHolder<Object> holder : this.acquireFromPool(pool, 10)) {
                holder.release(release);
            }
            release.await();
            clock.forward(110L, TimeUnit.MILLISECONDS);
        }
        Assert.assertEquals((long)10L, (long)stateMonitor.currentPeakSize.get());
        Assert.assertEquals((long)50L, (long)stateMonitor.targetSize.get());
        Assert.assertEquals((long)151L, (long)stateMonitor.disposed.get());
        stateMonitor.created.set(0);
        stateMonitor.disposed.set(0);
        this.buildAPeakOfAcquiredFlyweightsAndTriggerAlarmWithSideEffects(200, clock, pool, holders);
        Assert.assertEquals((long)151L, (long)stateMonitor.created.get());
        Assert.assertEquals((long)0L, (long)stateMonitor.disposed.get());
    }

    private void buildAPeakOfAcquiredFlyweightsAndTriggerAlarmWithSideEffects(int MAX_SIZE, FakeClock clock, FlyweightPool<Object> pool, List<FlyweightHolder<Object>> holders) throws InterruptedException {
        holders.addAll(this.acquireFromPool(pool, MAX_SIZE));
        clock.forward(110L, TimeUnit.MILLISECONDS);
        holders.addAll(this.acquireFromPool(pool, 1));
        for (FlyweightHolder<Object> holder : holders) {
            holder.release();
        }
    }

    private FlyweightPool<Object> getFlyweightPool(StatefulMonitor stateMonitor, FakeClock clock, int minSize) {
        return new FlyweightPool<Object>(minSize, (FlyweightPool.CheckStrategy)new FlyweightPool.CheckStrategy.TimeoutCheckStrategy(100L, (Clock)clock), (FlyweightPool.Monitor)stateMonitor){

            protected Object create() {
                return new Object();
            }
        };
    }

    private <R> List<FlyweightHolder<R>> acquireFromPool(FlyweightPool<R> pool, int times) throws InterruptedException {
        LinkedList<FlyweightHolder<R>> acquirers = new LinkedList<FlyweightHolder<R>>();
        CountDownLatch latch = new CountDownLatch(times);
        for (int i = 0; i < times; ++i) {
            FlyweightHolder holder = new FlyweightHolder(pool, latch);
            Thread t = new Thread(holder);
            acquirers.add(holder);
            t.start();
        }
        latch.await();
        return acquirers;
    }

    private class StatefulMonitor
    implements FlyweightPool.Monitor<Object> {
        public AtomicInteger currentPeakSize = new AtomicInteger(-1);
        public AtomicInteger targetSize = new AtomicInteger(-1);
        public AtomicInteger created = new AtomicInteger(0);
        public AtomicInteger acquired = new AtomicInteger(0);
        public AtomicInteger disposed = new AtomicInteger(0);

        private StatefulMonitor() {
        }

        public void updatedCurrentPeakSize(int currentPeakSize) {
            this.currentPeakSize.set(currentPeakSize);
        }

        public void updatedTargetSize(int targetSize) {
            this.targetSize.set(targetSize);
        }

        public void created(Object Object2) {
            this.created.incrementAndGet();
        }

        public void acquired(Object Object2) {
            this.acquired.incrementAndGet();
        }

        public void disposed(Object Object2) {
            this.disposed.incrementAndGet();
        }
    }

    private class FlyweightHolder<R>
    implements Runnable {
        private final Semaphore latch = new Semaphore(0);
        private final CountDownLatch released = new CountDownLatch(1);
        private final CountDownLatch onAcquire;
        private final FlyweightPool<R> pool;
        private final AtomicBoolean release = new AtomicBoolean();

        private FlyweightHolder(FlyweightPool<R> pool, CountDownLatch onAcquire) {
            this.pool = pool;
            this.onAcquire = onAcquire;
        }

        @Override
        public void run() {
            try {
                Object acquired = this.pool.acquire();
                this.onAcquire.countDown();
                try {
                    this.latch.acquire();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                if (this.release.get()) {
                    this.pool.release(acquired);
                    this.released.countDown();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }

        public void release() {
            this.release.set(true);
            this.latch.release();
            try {
                this.released.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void release(CountDownLatch releaseLatch) {
            this.release();
            releaseLatch.countDown();
        }

        public void end() {
            this.release.set(false);
            this.latch.release();
        }
    }
}

