/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Test;
import org.neo4j.helpers.Exceptions;
import org.neo4j.kernel.impl.util.JobScheduler;
import org.neo4j.kernel.impl.util.Neo4jJobScheduler;
import org.neo4j.kernel.impl.util.StringLogger;

public class Neo4jJobSchedulerTest {
    private Neo4jJobScheduler scheduler;
    private AtomicInteger invocations = new AtomicInteger(0);
    private Runnable countInvocationsJob = new Runnable(){

        @Override
        public void run() {
            try {
                Neo4jJobSchedulerTest.this.invocations.incrementAndGet();
            }
            catch (Throwable e) {
                e.printStackTrace();
                throw Exceptions.launderedException((Throwable)e);
            }
        }
    };

    @After
    public void stopScheduler() throws Throwable {
        this.scheduler.shutdown();
    }

    @Test
    public void shouldRunRecurringJob() throws Throwable {
        long period = 10L;
        this.scheduler = new Neo4jJobScheduler(StringLogger.DEV_NULL);
        this.scheduler.init();
        this.scheduler.scheduleRecurring(JobScheduler.Group.indexPopulation, this.countInvocationsJob, period, TimeUnit.MILLISECONDS);
        this.awaitFirstInvocation();
        Thread.sleep(period * 2L);
        this.scheduler.shutdown();
        int actualInvocations = this.invocations.get();
        MatcherAssert.assertThat((Object)actualInvocations, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Integer.valueOf(2)));
        MatcherAssert.assertThat((Object)actualInvocations, (Matcher)Matchers.lessThan((Comparable)Integer.valueOf(10)));
        Thread.sleep(period);
        MatcherAssert.assertThat((Object)this.invocations.get(), (Matcher)Matchers.equalTo((Object)actualInvocations));
    }

    @Test
    public void shouldCancelRecurringJob() throws Exception {
        long period = 2L;
        this.scheduler = new Neo4jJobScheduler(StringLogger.DEV_NULL);
        this.scheduler.init();
        this.scheduler.scheduleRecurring(JobScheduler.Group.indexPopulation, this.countInvocationsJob, period, TimeUnit.MILLISECONDS);
        this.awaitFirstInvocation();
        this.scheduler.cancelRecurring(JobScheduler.Group.indexPopulation, this.countInvocationsJob);
        int recorded = this.invocations.get();
        Thread.sleep(period * 100L);
        MatcherAssert.assertThat((Object)this.invocations.get(), (Matcher)Matchers.equalTo((Object)recorded));
    }

    private void awaitFirstInvocation() {
        while (this.invocations.get() == 0) {
            Thread.yield();
        }
    }
}

