/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import org.junit.rules.ExternalResource;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.helpers.Function;
import org.neo4j.kernel.GraphDatabaseAPI;
import org.neo4j.kernel.impl.core.NodeManager;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.test.AlgebraicFunction;

public abstract class DatabaseRule
extends ExternalResource {
    GraphDatabaseBuilder databaseBuilder;
    GraphDatabaseAPI database;
    private String storeDir;

    public <T> T when(Function<GraphDatabaseService, T> function) {
        return (T)function.apply((Object)this.getGraphDatabaseService());
    }

    public <T> T executeAndCommit(Function<? super GraphDatabaseService, T> function) {
        return this.transaction(function, true);
    }

    public <T> T executeAndRollback(Function<? super GraphDatabaseService, T> function) {
        return this.transaction(function, false);
    }

    public <FROM, TO> AlgebraicFunction<FROM, TO> tx(final Function<FROM, TO> function) {
        return new AlgebraicFunction<FROM, TO>(){

            public TO apply(final FROM from) {
                return DatabaseRule.this.executeAndCommit(new Function<GraphDatabaseService, TO>(){

                    public TO apply(GraphDatabaseService graphDb) {
                        return function.apply(from);
                    }
                });
            }
        };
    }

    private <T> T transaction(Function<? super GraphDatabaseService, T> function, boolean commit) {
        try (Transaction tx = this.database.beginTx();){
            Object result = function.apply((Object)this.database);
            if (commit) {
                tx.success();
            }
            Object object = result;
            return (T)object;
        }
    }

    protected void before() throws Throwable {
        this.create();
    }

    protected void after() {
        this.shutdown();
    }

    public void create() throws IOException {
        this.createResources();
        try {
            GraphDatabaseFactory factory = this.newFactory();
            this.configure(factory);
            this.databaseBuilder = this.newBuilder(factory);
            this.configure(this.databaseBuilder);
            this.database = (GraphDatabaseAPI)this.databaseBuilder.newGraphDatabase();
            this.storeDir = this.database.getStoreDir();
        }
        catch (RuntimeException e) {
            this.deleteResources();
            throw e;
        }
    }

    protected void deleteResources() {
    }

    protected void createResources() throws IOException {
    }

    protected abstract GraphDatabaseFactory newFactory();

    protected abstract GraphDatabaseBuilder newBuilder(GraphDatabaseFactory var1);

    protected void configure(GraphDatabaseFactory databaseFactory) {
    }

    protected void configure(GraphDatabaseBuilder builder) {
    }

    public GraphDatabaseService getGraphDatabaseService() {
        return this.database;
    }

    public GraphDatabaseAPI getGraphDatabaseAPI() {
        return this.database;
    }

    public void restartDatabase(RestartAction action) {
        FileSystemAbstraction fs = (FileSystemAbstraction)this.database.getDependencyResolver().resolveDependency(FileSystemAbstraction.class);
        this.database.shutdown();
        action.run(fs, new File(this.storeDir));
        this.database = (GraphDatabaseAPI)this.databaseBuilder.newGraphDatabase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            if (this.database != null) {
                this.database.shutdown();
            }
        }
        finally {
            this.deleteResources();
            this.database = null;
        }
    }

    public void clearCache() {
        ((NodeManager)this.getGraphDatabaseAPI().getDependencyResolver().resolveDependency(NodeManager.class)).clearCache();
    }

    public static interface RestartAction {
        public void run(FileSystemAbstraction var1, File var2);
    }
}

