/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.concurrent.CountDownLatch;

public class DoubleLatch {
    private final CountDownLatch startSignal;
    private final CountDownLatch finishSignal;
    private final int numberOfContestants;

    public DoubleLatch() {
        this(1);
    }

    public DoubleLatch(int numberOfContestants) {
        this.numberOfContestants = numberOfContestants;
        this.startSignal = new CountDownLatch(numberOfContestants);
        this.finishSignal = new CountDownLatch(numberOfContestants);
    }

    public int getNumberOfContestants() {
        return this.numberOfContestants;
    }

    public void startAndAwaitFinish() {
        this.start();
        DoubleLatch.awaitLatch(this.finishSignal);
    }

    public void awaitStart() {
        DoubleLatch.awaitLatch(this.startSignal);
    }

    public void start() {
        this.startSignal.countDown();
        DoubleLatch.awaitLatch(this.startSignal);
    }

    public void finish() {
        this.finishSignal.countDown();
    }

    public void awaitFinish() {
        DoubleLatch.awaitLatch(this.finishSignal);
    }

    public static void awaitLatch(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new RuntimeException(e);
        }
    }

    public String toString() {
        return super.toString() + "[Start[" + this.startSignal.getCount() + "], Finish[" + this.finishSignal.getCount() + "]]";
    }
}

