/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import org.junit.rules.TemporaryFolder;
import org.neo4j.graphdb.factory.GraphDatabaseBuilder;
import org.neo4j.graphdb.factory.GraphDatabaseFactory;
import org.neo4j.test.DatabaseRule;
import org.neo4j.test.TargetDirectory;

public class EmbeddedDatabaseRule
extends DatabaseRule {
    private final TempDirectory temp;

    public EmbeddedDatabaseRule() {
        this.temp = new TempDirectory(){
            private final TemporaryFolder folder = new TemporaryFolder();

            @Override
            public File root() {
                return this.folder.getRoot();
            }

            @Override
            public void delete() {
                this.folder.delete();
            }

            @Override
            public void create() throws IOException {
                this.folder.create();
            }
        };
    }

    public EmbeddedDatabaseRule(final Class<?> testClass) {
        this.temp = new TempDirectory(){
            private final TargetDirectory targetDirectory;
            private File dbDir;
            {
                this.targetDirectory = TargetDirectory.forTest(testClass);
            }

            @Override
            public File root() {
                return this.dbDir;
            }

            @Override
            public void delete() throws IOException {
                this.targetDirectory.cleanup();
            }

            @Override
            public void create() {
                this.dbDir = this.targetDirectory.makeGraphDbDir();
            }
        };
    }

    @Override
    protected GraphDatabaseFactory newFactory() {
        return new GraphDatabaseFactory();
    }

    @Override
    protected GraphDatabaseBuilder newBuilder(GraphDatabaseFactory factory) {
        return factory.newEmbeddedDatabaseBuilder(this.temp.root().getAbsolutePath());
    }

    @Override
    protected void createResources() throws IOException {
        this.temp.create();
    }

    @Override
    protected void deleteResources() {
        try {
            this.temp.delete();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static interface TempDirectory {
        public File root();

        public void create() throws IOException;

        public void delete() throws IOException;
    }
}

