/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.factory.GraphDatabaseFactoryState;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Service;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.EmbeddedGraphDatabase;
import org.neo4j.kernel.InternalAbstractGraphDatabase;
import org.neo4j.kernel.extension.KernelExtensionFactory;
import org.neo4j.kernel.impl.cache.CacheProvider;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.xaframework.TransactionInterceptorProvider;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.kernel.logging.Logging;
import org.neo4j.kernel.logging.SingleLoggingService;
import org.neo4j.test.GraphDatabaseServiceCleaner;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;

public class ImpermanentGraphDatabase
extends EmbeddedGraphDatabase {
    private static boolean TRACK_UNCLOSED_DATABASE_INSTANCES = false;
    private static final Map<File, Exception> startedButNotYetClosed = new ConcurrentHashMap<File, Exception>();
    protected static final String PATH = "target/test-data/impermanent-db";

    @Deprecated
    public ImpermanentGraphDatabase() {
        this(new HashMap<String, String>());
    }

    public ImpermanentGraphDatabase(String storeDir) {
        this(storeDir, ImpermanentGraphDatabase.withForcedInMemoryConfiguration(new HashMap<String, String>()));
    }

    @Deprecated
    public ImpermanentGraphDatabase(Map<String, String> params) {
        this(PATH, ImpermanentGraphDatabase.withForcedInMemoryConfiguration(params));
    }

    @Deprecated
    public ImpermanentGraphDatabase(String storeDir, Map<String, String> params) {
        this(storeDir, ImpermanentGraphDatabase.withForcedInMemoryConfiguration(params), Iterables.cast((Iterable)Service.load(KernelExtensionFactory.class)), Service.load(CacheProvider.class), Service.load(TransactionInterceptorProvider.class));
    }

    @Deprecated
    public ImpermanentGraphDatabase(Map<String, String> params, Iterable<KernelExtensionFactory<?>> kernelExtensions, Iterable<CacheProvider> cacheProviders, Iterable<TransactionInterceptorProvider> transactionInterceptorProviders) {
        this(PATH, params, kernelExtensions, cacheProviders, transactionInterceptorProviders);
    }

    @Deprecated
    public ImpermanentGraphDatabase(String storeDir, Map<String, String> params, Iterable<KernelExtensionFactory<?>> kernelExtensions, Iterable<CacheProvider> cacheProviders, Iterable<TransactionInterceptorProvider> transactionInterceptorProviders) {
        this(storeDir, ImpermanentGraphDatabase.withForcedInMemoryConfiguration(params), ImpermanentGraphDatabase.getDependencies(kernelExtensions, cacheProviders, transactionInterceptorProviders));
    }

    private static InternalAbstractGraphDatabase.Dependencies getDependencies(Iterable<KernelExtensionFactory<?>> kernelExtensions, Iterable<CacheProvider> cacheProviders, Iterable<TransactionInterceptorProvider> transactionInterceptorProviders) {
        GraphDatabaseFactoryState state = new GraphDatabaseFactoryState();
        state.setKernelExtensions(kernelExtensions);
        state.setCacheProviders(cacheProviders);
        state.setTransactionInterceptorProviders(transactionInterceptorProviders);
        return state.databaseDependencies();
    }

    public ImpermanentGraphDatabase(String storeDir, Map<String, String> params, InternalAbstractGraphDatabase.Dependencies dependencies) {
        super(storeDir, ImpermanentGraphDatabase.withForcedInMemoryConfiguration(params), dependencies);
        this.trackUnclosedUse(storeDir);
    }

    private void trackUnclosedUse(String path) {
        Exception testThatDidNotCloseDb;
        if (TRACK_UNCLOSED_DATABASE_INSTANCES && (testThatDidNotCloseDb = startedButNotYetClosed.put(new File(path), new Exception("Unclosed database instance"))) != null) {
            testThatDidNotCloseDb.printStackTrace();
        }
    }

    public void shutdown() {
        if (TRACK_UNCLOSED_DATABASE_INSTANCES) {
            startedButNotYetClosed.remove(new File(this.getStoreDir()));
        }
        super.shutdown();
    }

    protected FileSystemAbstraction createFileSystemAbstraction() {
        return (FileSystemAbstraction)this.life.add((Object)new EphemeralFileSystemAbstraction());
    }

    private static Map<String, String> withForcedInMemoryConfiguration(Map<String, String> params) {
        HashMap<String, String> result = new HashMap<String, String>(params);
        result.put(GraphDatabaseSettings.use_memory_mapped_buffers.name(), "false");
        result.put(InternalAbstractGraphDatabase.Configuration.ephemeral.name(), "true");
        return result;
    }

    protected Logging createLogging() {
        return (Logging)this.life.add((Object)new SingleLoggingService(StringLogger.loggerDirectory((FileSystemAbstraction)this.fileSystem, (File)this.storeDir)));
    }

    public void cleanContent() {
        GraphDatabaseServiceCleaner.cleanDatabaseContent((GraphDatabaseService)this);
    }
}

