/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.test.ArtificialClock;
import org.neo4j.test.InputStreamAwaiter;

public class InputStreamAwaiterTest {
    @Test
    public void shouldWaitForALineWithoutBlocking() throws Exception {
        ArtificialClock clock = new ArtificialClock();
        InputStream inputStream = (InputStream)Mockito.spy((Object)new MockInputStream(clock.progressor(5L, TimeUnit.MILLISECONDS), InputStreamAwaiterTest.lines("important message")));
        InputStreamAwaiter awaiter = new InputStreamAwaiter(clock, inputStream);
        awaiter.awaitLine("important message", 5L, TimeUnit.SECONDS);
    }

    @Test
    public void shouldTimeoutWhenDifferentContentProvided() throws Exception {
        ArtificialClock clock = new ArtificialClock();
        InputStream inputStream = (InputStream)Mockito.spy((Object)new MockInputStream(clock.progressor(1L, TimeUnit.SECONDS), InputStreamAwaiterTest.lines("different content"), InputStreamAwaiterTest.lines("different message")));
        InputStreamAwaiter awaiter = new InputStreamAwaiter(clock, inputStream);
        try {
            awaiter.awaitLine("important message", 5L, TimeUnit.SECONDS);
            Assert.fail((String)"should have thrown exception");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
    }

    @Test
    public void shouldTimeoutWhenNoContentProvided() throws Exception {
        ArtificialClock clock = new ArtificialClock();
        InputStream inputStream = (InputStream)Mockito.spy((Object)new MockInputStream(clock.progressor(1L, TimeUnit.SECONDS), new String[0]));
        InputStreamAwaiter awaiter = new InputStreamAwaiter(clock, inputStream);
        try {
            awaiter.awaitLine("important message", 5L, TimeUnit.SECONDS);
            Assert.fail((String)"should have thrown exception");
        }
        catch (TimeoutException e) {
            // empty catch block
        }
    }

    private static String lines(String ... lines) {
        StringBuilder result = new StringBuilder();
        for (String line : lines) {
            result.append(line).append(System.getProperty("line.separator"));
        }
        return result.toString();
    }

    private static class MockInputStream
    extends InputStream {
        private final byte[][] chunks;
        private final ArtificialClock.Progressor progressor;
        private int chunk = 0;

        MockInputStream(ArtificialClock.Progressor progressor, String ... chunks) {
            this.progressor = progressor;
            this.chunks = new byte[chunks.length][];
            for (int i = 0; i < chunks.length; ++i) {
                this.chunks[i] = chunks[i].getBytes();
            }
        }

        @Override
        public int available() throws IOException {
            this.progressor.tick();
            if (this.chunk >= this.chunks.length) {
                return 0;
            }
            return this.chunks[this.chunk].length;
        }

        @Override
        public int read(byte[] target) throws IOException {
            if (this.chunk >= this.chunks.length) {
                return 0;
            }
            byte[] source = this.chunks[this.chunk++];
            System.arraycopy(source, 0, target, 0, source.length);
            return source.length;
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

