/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.transaction.xa.Xid;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.neo4j.helpers.Pair;
import org.neo4j.helpers.Predicate;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.xa.LogDeserializer;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandReaderFactory;
import org.neo4j.kernel.impl.nioneo.xa.XaCommandWriter;
import org.neo4j.kernel.impl.nioneo.xa.command.PhysicalLogNeoXaCommandWriter;
import org.neo4j.kernel.impl.transaction.XidImpl;
import org.neo4j.kernel.impl.transaction.xaframework.DirectMappedLogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogBuffer;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntry;
import org.neo4j.kernel.impl.transaction.xaframework.LogEntryWriterv1;
import org.neo4j.kernel.impl.transaction.xaframework.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.xaframework.XaLogicalLog;
import org.neo4j.kernel.impl.util.Consumer;
import org.neo4j.kernel.impl.util.Cursor;
import org.neo4j.kernel.monitoring.ByteCounterMonitor;
import org.neo4j.kernel.monitoring.Monitors;

public class LogTestUtils {
    public static final LogHook<Pair<Byte, List<byte[]>>> EVERYTHING_BUT_DONE_RECORDS = new LogHookAdapter<Pair<Byte, List<byte[]>>>(){

        public boolean accept(Pair<Byte, List<byte[]>> item) {
            return (Byte)item.first() != 4;
        }
    };
    public static final LogHook<Pair<Byte, List<byte[]>>> NO_FILTER = new LogHookAdapter<Pair<Byte, List<byte[]>>>(){

        public boolean accept(Pair<Byte, List<byte[]>> item) {
            return true;
        }
    };
    public static final LogHook<Pair<Byte, List<byte[]>>> PRINT_DANGLING = new LogHook<Pair<Byte, List<byte[]>>>(){
        private final Map<ByteArray, List<Xid>> xids = new HashMap<ByteArray, List<Xid>>();

        public boolean accept(Pair<Byte, List<byte[]>> item) {
            List<Xid> removed;
            if ((Byte)item.first() == 2) {
                ByteArray key = new ByteArray((byte[])((List)item.other()).get(0));
                List<Xid> list = this.xids.get(key);
                if (list == null) {
                    list = new ArrayList<Xid>();
                    this.xids.put(key, list);
                }
                XidImpl xid = new XidImpl((byte[])((List)item.other()).get(0), (byte[])((List)item.other()).get(1));
                list.add((Xid)xid);
            } else if ((Byte)item.first() == 4 && (removed = this.xids.remove(new ByteArray((byte[])((List)item.other()).get(0)))) == null) {
                throw new IllegalArgumentException("Not found");
            }
            return true;
        }

        @Override
        public void file(File file) {
            this.xids.clear();
            System.out.println("=== " + file + " ===");
        }

        @Override
        public void done(File file) {
            for (List<Xid> xid : this.xids.values()) {
                System.out.println("dangling " + xid);
            }
        }
    };
    public static final LogHook<Pair<Byte, List<byte[]>>> DUMP = new LogHook<Pair<Byte, List<byte[]>>>(){
        private int recordCount = 0;

        public boolean accept(Pair<Byte, List<byte[]>> item) {
            System.out.println(LogTestUtils.stringifyTxLogType((Byte)item.first()) + ": " + LogTestUtils.stringifyTxLogBody((List)item.other()));
            ++this.recordCount;
            return true;
        }

        @Override
        public void file(File file) {
            System.out.println("=== File:" + file + " ===");
            this.recordCount = 0;
        }

        @Override
        public void done(File file) {
            System.out.println("===> Read " + this.recordCount + " records from " + file);
        }
    };

    public static LogHook<LogEntry> findLastTransactionIdentifier(final AtomicInteger target) {
        return new LogHookAdapter<LogEntry>(){

            public boolean accept(LogEntry item) {
                target.set(Math.max(target.get(), item.getIdentifier()));
                return true;
            }
        };
    }

    private static String stringifyTxLogType(byte recordType) {
        switch (recordType) {
            case 1: {
                return "TX_START";
            }
            case 2: {
                return "BRANCH_ADD";
            }
            case 3: {
                return "MARK_COMMIT";
            }
            case 4: {
                return "TX_DONE";
            }
        }
        return "Unknown " + recordType;
    }

    private static String stringifyTxLogBody(List<byte[]> list) {
        if (list.size() == 2) {
            return new XidImpl(list.get(0), list.get(1)).toString();
        }
        if (list.size() == 1) {
            return LogTestUtils.stripFromBranch(new XidImpl(list.get(0), new byte[0]).toString());
        }
        throw new RuntimeException(list.toString());
    }

    private static String stripFromBranch(String xidToString) {
        int index = xidToString.lastIndexOf(", BranchId");
        return xidToString.substring(0, index);
    }

    public static void filterTxLog(FileSystemAbstraction fileSystem, String storeDir, LogHook<Pair<Byte, List<byte[]>>> filter) throws IOException {
        LogTestUtils.filterTxLog(fileSystem, storeDir, filter, 0L);
    }

    public static void filterTxLog(FileSystemAbstraction fileSystem, String storeDir, LogHook<Pair<Byte, List<byte[]>>> filter, long startPosition) throws IOException {
        for (File file : LogTestUtils.oneOrTwo(fileSystem, new File(storeDir, "tm_tx_log"))) {
            LogTestUtils.filterTxLog(fileSystem, file, filter, startPosition);
        }
    }

    public static void filterTxLog(FileSystemAbstraction fileSystem, File file, LogHook<Pair<Byte, List<byte[]>>> filter) throws IOException {
        LogTestUtils.filterTxLog(fileSystem, file, filter, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void filterTxLog(FileSystemAbstraction fileSystem, File file, LogHook<Pair<Byte, List<byte[]>>> filter, long startPosition) throws IOException {
        File tempFile = new File(file.getPath() + ".tmp");
        fileSystem.deleteFile(tempFile);
        StoreChannel in = fileSystem.open(file, "r");
        in.position(startPosition);
        StoreChannel out = fileSystem.open(tempFile, "rw");
        DirectMappedLogBuffer outBuffer = new DirectMappedLogBuffer(out, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        boolean changed = false;
        try {
            filter.file(file);
            in.read(buffer);
            buffer.flip();
            while (buffer.hasRemaining()) {
                byte type = buffer.get();
                List<byte[]> xids = null;
                if (type == 1) {
                    xids = LogTestUtils.readXids(buffer, 1);
                } else if (type == 2) {
                    xids = LogTestUtils.readXids(buffer, 2);
                } else if (type == 3) {
                    xids = LogTestUtils.readXids(buffer, 1);
                } else if (type == 4) {
                    xids = LogTestUtils.readXids(buffer, 1);
                } else {
                    throw new IllegalArgumentException("Unknown type:" + type + ", position:" + (in.position() - (long)buffer.remaining()));
                }
                if (filter.accept(Pair.of((Object)type, xids))) {
                    outBuffer.put(type);
                    LogTestUtils.writeXids(xids, (LogBuffer)outBuffer);
                    continue;
                }
                changed = true;
            }
        }
        finally {
            LogTestUtils.safeClose(in);
            outBuffer.force();
            LogTestUtils.safeClose(out);
            filter.done(file);
        }
        if (changed) {
            LogTestUtils.replace(tempFile, file);
        } else {
            tempFile.delete();
        }
    }

    public static void assertLogContains(FileSystemAbstraction fileSystem, String logPath, LogEntry ... expectedEntries) throws IOException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(713);
        try (StoreChannel fileChannel = fileSystem.open(new File(logPath), "r");){
            VersionAwareLogEntryReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)fileChannel, (boolean)true);
            final ArrayList entries = new ArrayList();
            LogDeserializer deserializer = new LogDeserializer(buffer, XaCommandReaderFactory.DEFAULT);
            Consumer<LogEntry, IOException> consumer = new Consumer<LogEntry, IOException>(){

                public boolean accept(LogEntry entry) throws IOException {
                    entries.add(entry);
                    return true;
                }
            };
            try (Cursor cursor = deserializer.cursor((ReadableByteChannel)fileChannel);){
                cursor.next((Consumer)consumer);
            }
            for (int entryNo = 0; entryNo < expectedEntries.length; ++entryNo) {
                LogEntry expectedEntry = expectedEntries[entryNo];
                if (entries.size() <= entryNo) {
                    Assert.fail((String)("Log ended prematurely. Expected to find '" + expectedEntry.toString() + "' as log entry number " + entryNo + ", instead there were no more log entries."));
                }
                LogEntry actualEntry = (LogEntry)entries.get(entryNo);
                Assert.assertThat((String)("Unexpected entry at entry number " + entryNo), (Object)actualEntry, (Matcher)Is.is((Object)expectedEntry));
            }
            Assert.assertThat((String)"The log contained more entries than we expected!", (Object)entries.size(), (Matcher)Is.is((Object)expectedEntries.length));
        }
    }

    private static void replace(File tempFile, File file) {
        file.renameTo(new File(file.getAbsolutePath() + "." + System.currentTimeMillis()));
        tempFile.renameTo(file);
    }

    public static File[] filterNeostoreLogicalLog(FileSystemAbstraction fileSystem, String storeDir, LogHook<LogEntry> filter) throws IOException {
        ArrayList<File> files = new ArrayList<File>(Arrays.asList(LogTestUtils.oneOrTwo(fileSystem, new File(storeDir, "nioneo_logical.log"))));
        LogTestUtils.gatherHistoricalLogicalLogFiles(fileSystem, storeDir, files);
        for (File file : files) {
            File filteredLog = LogTestUtils.filterNeostoreLogicalLog(fileSystem, file, filter);
            LogTestUtils.replace(filteredLog, file);
        }
        return files.toArray(new File[files.size()]);
    }

    private static void gatherHistoricalLogicalLogFiles(FileSystemAbstraction fileSystem, String storeDir, List<File> files) {
        long highestVersion = XaLogicalLog.getHighestHistoryLogVersion((FileSystemAbstraction)fileSystem, (File)new File(storeDir), (String)"nioneo_logical.log");
        for (long version = 0L; version <= highestVersion; ++version) {
            File versionFile = XaLogicalLog.getHistoryFileName((File)new File(storeDir, "nioneo_logical.log"), (long)version);
            if (!fileSystem.fileExists(versionFile)) continue;
            files.add(versionFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File filterNeostoreLogicalLog(FileSystemAbstraction fileSystem, File file, final LogHook<LogEntry> filter) throws IOException {
        filter.file(file);
        File tempFile = new File(file.getAbsolutePath() + ".tmp");
        fileSystem.deleteFile(tempFile);
        StoreChannel in = fileSystem.open(file, "r");
        StoreChannel out = fileSystem.open(tempFile, "rw");
        DirectMappedLogBuffer outBuffer = new DirectMappedLogBuffer(out, (ByteCounterMonitor)new Monitors().newMonitor(ByteCounterMonitor.class, new String[0]));
        ByteBuffer buffer = ByteBuffer.allocate(0x100000);
        LogTestUtils.transferLogicalLogHeader(in, (LogBuffer)outBuffer, buffer);
        final LogEntryWriterv1 writer = new LogEntryWriterv1();
        writer.setCommandWriter((XaCommandWriter)new PhysicalLogNeoXaCommandWriter());
        LogDeserializer deserializer = new LogDeserializer(buffer, XaCommandReaderFactory.DEFAULT);
        Consumer<LogEntry, IOException> consumer = new Consumer<LogEntry, IOException>((LogBuffer)outBuffer){
            final /* synthetic */ LogBuffer val$outBuffer;
            {
                this.val$outBuffer = logBuffer;
            }

            public boolean accept(LogEntry entry) throws IOException {
                boolean accepted = filter.accept(entry);
                if (accepted) {
                    writer.writeLogEntry(entry, this.val$outBuffer);
                }
                return true;
            }
        };
        try (Cursor cursor = deserializer.cursor((ReadableByteChannel)in);){
            while (cursor.next((Consumer)consumer)) {
            }
        }
        finally {
            LogTestUtils.safeClose(in);
            outBuffer.force();
            LogTestUtils.safeClose(out);
            filter.done(file);
        }
        return tempFile;
    }

    private static void transferLogicalLogHeader(StoreChannel in, LogBuffer outBuffer, ByteBuffer buffer) throws IOException {
        long[] header = VersionAwareLogEntryReader.readLogHeader((ByteBuffer)buffer, (ReadableByteChannel)in, (boolean)true);
        LogEntryWriterv1.writeLogHeader((ByteBuffer)buffer, (long)header[0], (long)header[1]);
        byte[] headerBytes = new byte[buffer.limit()];
        buffer.get(headerBytes);
        outBuffer.put(headerBytes);
    }

    private static void safeClose(StoreChannel channel) {
        try {
            if (channel != null) {
                channel.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void writeXids(List<byte[]> xids, LogBuffer outBuffer) throws IOException {
        for (byte[] xid : xids) {
            outBuffer.put((byte)xid.length);
        }
        for (byte[] xid : xids) {
            outBuffer.put(xid);
        }
    }

    private static List<byte[]> readXids(ByteBuffer buffer, int count) {
        byte[] counts = new byte[count];
        for (int i = 0; i < count; ++i) {
            counts[i] = buffer.get();
        }
        ArrayList<byte[]> xids = new ArrayList<byte[]>();
        for (int i = 0; i < count; ++i) {
            xids.add(LogTestUtils.readXid(buffer, counts[i]));
        }
        return xids;
    }

    private static byte[] readXid(ByteBuffer buffer, byte length) {
        byte[] bytes = new byte[length];
        buffer.get(bytes);
        return bytes;
    }

    public static File[] oneOrTwo(FileSystemAbstraction fileSystem, File file) {
        File two;
        ArrayList<File> files = new ArrayList<File>();
        File one = new File(file.getPath() + ".1");
        if (fileSystem.fileExists(one)) {
            files.add(one);
        }
        if (fileSystem.fileExists(two = new File(file.getPath() + ".2"))) {
            files.add(two);
        }
        return files.toArray(new File[files.size()]);
    }

    public static NonCleanLogCopy copyLogicalLog(FileSystemAbstraction fileSystem, File logBaseFileName) throws IOException {
        Throwable throwable;
        File activeLogBackup;
        char active = '1';
        File activeLog = new File(logBaseFileName.getPath() + ".active");
        ByteBuffer buffer = ByteBuffer.allocate(1024);
        try (StoreChannel af = fileSystem.open(activeLog, "r");){
            af.read(buffer);
            buffer.flip();
            activeLogBackup = new File(logBaseFileName.getPath() + ".bak.active");
            throwable = null;
            try (StoreChannel activeCopy = fileSystem.open(activeLogBackup, "rw");){
                activeCopy.write(buffer);
            }
            catch (Throwable x2) {
                throwable = x2;
                throw x2;
            }
        }
        buffer.flip();
        active = buffer.asCharBuffer().get();
        buffer.clear();
        File currentLog = new File(logBaseFileName.getPath() + "." + active);
        File currentLogBackup = new File(logBaseFileName.getPath() + ".bak." + active);
        throwable = null;
        try (StoreChannel source = fileSystem.open(currentLog, "r");
             StoreChannel dest = fileSystem.open(currentLogBackup, "rw");){
            int read = -1;
            do {
                read = source.read(buffer);
                buffer.flip();
                dest.write(buffer);
                buffer.clear();
            } while (read == 1024);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        return new NonCleanLogCopy(new FileBackup(activeLog, activeLogBackup, fileSystem), new FileBackup(currentLog, currentLogBackup, fileSystem));
    }

    public static class NonCleanLogCopy {
        private final FileBackup[] backups;

        NonCleanLogCopy(FileBackup ... backups) {
            this.backups = backups;
        }

        public void reinstate() throws IOException {
            for (FileBackup backup : this.backups) {
                backup.restore();
            }
        }
    }

    private static class FileBackup {
        private final File file;
        private final File backup;
        private final FileSystemAbstraction fileSystem;

        FileBackup(File file, File backup, FileSystemAbstraction fileSystem) {
            this.file = file;
            this.backup = backup;
            this.fileSystem = fileSystem;
        }

        public void restore() throws IOException {
            this.fileSystem.deleteFile(this.file);
            this.fileSystem.renameFile(this.backup, this.file);
        }
    }

    public static class CountingLogHook<RECORD>
    extends LogHookAdapter<RECORD> {
        private int count;

        public boolean accept(RECORD item) {
            ++this.count;
            return true;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class ByteArray {
        private final byte[] bytes;

        public ByteArray(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object obj) {
            return Arrays.equals(this.bytes, ((ByteArray)obj).bytes);
        }

        public int hashCode() {
            return Arrays.hashCode(this.bytes);
        }
    }

    public static abstract class LogHookAdapter<RECORD>
    implements LogHook<RECORD> {
        @Override
        public void file(File file) {
        }

        @Override
        public void done(File file) {
        }
    }

    public static interface LogHook<RECORD>
    extends Predicate<RECORD> {
        public void file(File var1);

        public void done(File var1);
    }
}

