/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public final class Mute
implements TestRule {
    public static final Mutable java_util_logging = Mute.java_util_logging(null, null);
    private final Mutable[] mutables;

    public static Mute mute(Mutable ... mutables) {
        return new Mute(mutables);
    }

    public static Mute muteAll() {
        return Mute.mute(System.out, System.err, java_util_logging);
    }

    public static Mutable java_util_logging(OutputStream redirectTo, Level level) {
        StreamHandler replacement;
        StreamHandler streamHandler = replacement = redirectTo == null ? null : new StreamHandler(redirectTo, new SimpleFormatter());
        if (replacement != null && level != null) {
            replacement.setLevel(level);
        }
        return new Mutable(){

            @Override
            public Voice mute() {
                Handler[] handlers;
                final Logger logger = LogManager.getLogManager().getLogger("");
                final Level level = logger.getLevel();
                for (Handler handler : handlers = logger.getHandlers()) {
                    logger.removeHandler(handler);
                }
                if (replacement != null) {
                    logger.addHandler(replacement);
                    logger.setLevel(Level.ALL);
                }
                return new Voice(){

                    @Override
                    void restore(boolean failure) throws IOException {
                        for (Handler handler : handlers) {
                            logger.addHandler(handler);
                        }
                        logger.setLevel(level);
                        if (replacement != null) {
                            logger.removeHandler(replacement);
                        }
                    }
                };
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T call(Callable<T> callable) throws Exception {
        Voice[] voices = this.captureVoices();
        boolean failure = true;
        try {
            T result = callable.call();
            failure = false;
            T t = result;
            return t;
        }
        finally {
            this.releaseVoices(voices, failure);
        }
    }

    private Mute(Mutable[] mutables) {
        this.mutables = mutables;
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                Voice[] voices = Mute.this.captureVoices();
                boolean failure = true;
                try {
                    base.evaluate();
                    failure = false;
                }
                finally {
                    Mute.this.releaseVoices(voices, failure);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Voice[] captureVoices() {
        Voice[] voices = new Voice[this.mutables.length];
        boolean ok = false;
        try {
            for (int i = 0; i < voices.length; ++i) {
                voices[i] = this.mutables[i].mute();
            }
            ok = true;
        }
        finally {
            if (!ok) {
                this.releaseVoices(voices, false);
            }
        }
        return voices;
    }

    void releaseVoices(Voice[] voices, boolean failure) {
        ArrayList<Throwable> failures = null;
        try {
            failures = new ArrayList<Throwable>(voices.length);
        }
        catch (Throwable oom) {
            // empty catch block
        }
        for (Voice voice : voices) {
            if (voice == null) continue;
            try {
                voice.restore(failure);
            }
            catch (Throwable exception) {
                if (failures == null) continue;
                failures.add(exception);
            }
        }
        if (failures != null && !failures.isEmpty()) {
            for (Throwable exception : failures) {
                exception.printStackTrace();
            }
        }
    }

    private static abstract class Voice {
        private Voice() {
        }

        abstract void restore(boolean var1) throws IOException;
    }

    public static interface Mutable {
        public Voice mute();
    }

    public static enum System implements Mutable
    {
        out{

            @Override
            PrintStream replace(PrintStream replacement) {
                PrintStream old = java.lang.System.out;
                java.lang.System.setOut(replacement);
                return old;
            }
        }
        ,
        err{

            @Override
            PrintStream replace(PrintStream replacement) {
                PrintStream old = java.lang.System.err;
                java.lang.System.setErr(replacement);
                return old;
            }
        };


        @Override
        public Voice mute() {
            final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            final PrintStream old = this.replace(new PrintStream(buffer));
            return new Voice(){

                @Override
                void restore(boolean failure) throws IOException {
                    System.this.replace(old).flush();
                    if (failure) {
                        old.write(buffer.toByteArray());
                    }
                }
            };
        }

        abstract PrintStream replace(PrintStream var1);
    }
}

