/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;
import org.junit.rules.TestRule;
import org.junit.runners.model.Statement;
import org.neo4j.test.OtherThreadExecutor;

public class OtherThreadRule<STATE>
implements TestRule {
    private final long timeout;
    private final TimeUnit unit;
    private volatile OtherThreadExecutor<STATE> executor;

    public OtherThreadRule() {
        this(10L, TimeUnit.SECONDS);
    }

    public OtherThreadRule(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.unit = unit;
    }

    public <RESULT> Future<RESULT> execute(OtherThreadExecutor.WorkerCommand<STATE, RESULT> cmd) {
        Future<RESULT> future = this.executor.executeDontWait(cmd);
        try {
            this.executor.awaitStartExecuting();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted while awaiting start of execution.", e);
        }
        return future;
    }

    protected STATE initialState() {
        return null;
    }

    public static Matcher<OtherThreadRule> isWaiting() {
        return OtherThreadRule.isThreadState(Thread.State.WAITING, Thread.State.TIMED_WAITING);
    }

    public static Matcher<OtherThreadRule> isThreadState(final Thread.State ... eitherOfStates) {
        return new TypeSafeMatcher<OtherThreadRule>(){

            protected boolean matchesSafely(OtherThreadRule rule) {
                try {
                    rule.executor.waitUntilThreadState(eitherOfStates);
                    return true;
                }
                catch (TimeoutException e) {
                    rule.executor.printStackTrace(System.err);
                    return false;
                }
            }

            public void describeTo(Description description) {
                description.appendText("Thread blocked in state WAITING");
            }
        };
    }

    public void interrupt() {
        this.executor.interrupt();
    }

    public String toString() {
        OtherThreadExecutor<STATE> otherThread = this.executor;
        if (otherThread == null) {
            return "OtherThreadRule[state=dead]";
        }
        return otherThread.toString();
    }

    public Statement apply(final Statement base, final org.junit.runner.Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                OtherThreadRule.this.executor = new OtherThreadExecutor(description.getDisplayName(), OtherThreadRule.this.timeout, OtherThreadRule.this.unit, OtherThreadRule.this.initialState());
                try {
                    base.evaluate();
                }
                finally {
                    try {
                        OtherThreadRule.this.executor.close();
                    }
                    finally {
                        OtherThreadRule.this.executor = null;
                    }
                }
            }
        };
    }
}

