/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class RepeatRule
implements TestRule {
    public Statement apply(Statement base, Description description) {
        Repeat repeat = (Repeat)description.getAnnotation(Repeat.class);
        if (repeat != null) {
            return new RepeatStatement(repeat.times(), base);
        }
        return base;
    }

    private static class RepeatStatement
    extends Statement {
        private final int times;
        private final Statement statement;

        private RepeatStatement(int times, Statement statement) {
            this.times = times;
            this.statement = statement;
        }

        public void evaluate() throws Throwable {
            for (int i = 0; i < this.times; ++i) {
                this.statement.evaluate();
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface Repeat {
        public int times();
    }
}

