/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.codec.digest.DigestUtils;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.util.FileUtils;

public class TargetDirectory {
    private final FileSystemAbstraction fileSystem;
    private final File base;

    public static TargetDirectory forTest(Class<?> owningTest) {
        return TargetDirectory.forTest((FileSystemAbstraction)new DefaultFileSystemAbstraction(), owningTest);
    }

    public static TargetDirectory forTest(FileSystemAbstraction fileSystem, Class<?> owningTest) {
        return new TargetDirectory(fileSystem, new File(new File(TargetDirectory.locateTarget(owningTest), "test-data"), owningTest.getName()));
    }

    public static TestDirectory testDirForTest(Class<?> owningTest) {
        return TargetDirectory.forTest((FileSystemAbstraction)new DefaultFileSystemAbstraction(), owningTest).testDirectory();
    }

    private TargetDirectory(FileSystemAbstraction fileSystem, File base) {
        this.fileSystem = fileSystem;
        this.base = base.getAbsoluteFile();
    }

    public File cacheDirectory(String name) {
        File dir = new File(this.ensureBase(), name);
        if (!this.fileSystem.fileExists(dir)) {
            this.fileSystem.mkdir(dir);
        }
        return dir;
    }

    public File existingDirectory(String name) {
        return new File(this.base, name);
    }

    public File cleanDirectory(String name) {
        File dir = new File(this.ensureBase(), name);
        if (this.fileSystem.fileExists(dir)) {
            this.recursiveDelete(dir);
        }
        this.fileSystem.mkdir(dir);
        return dir;
    }

    public File directoryForDescription(Description description) {
        String test = description.getMethodName();
        String dir = DigestUtils.md5Hex((String)test);
        this.register(test, dir);
        return this.cleanDirectory(dir);
    }

    public File file(String name) {
        return new File(this.ensureBase(), name);
    }

    public TestDirectory testDirectory() {
        return new TestDirectory();
    }

    public File makeGraphDbDir() {
        return this.cleanDirectory("graph-db");
    }

    public void cleanup() throws IOException {
        this.fileSystem.deleteRecursively(this.base);
        this.fileSystem.mkdirs(this.base);
    }

    private void recursiveDelete(File file) {
        try {
            this.fileSystem.deleteRecursively(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void register(String test, String dir) {
        try {
            FileUtils.writeToFile((File)new File(this.ensureBase(), ".register"), (String)String.format("%s=%s\n", dir, test), (boolean)true);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private File ensureBase() {
        if (this.fileSystem.fileExists(this.base) && !this.fileSystem.isDirectory(this.base)) {
            throw new IllegalStateException(this.base + " exists and is not a directory!");
        }
        try {
            this.fileSystem.mkdirs(this.base);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.base;
    }

    private static File locateTarget(Class<?> owningTest) {
        try {
            File codeSource = new File(owningTest.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (codeSource.isDirectory()) {
                return codeSource.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return new File("target");
    }

    public class TestDirectory
    implements TestRule {
        private File subdir = null;

        private TestDirectory() {
        }

        public String absolutePath() {
            return this.directory().getAbsolutePath();
        }

        public File directory() {
            if (this.subdir == null) {
                throw new IllegalStateException("Not initialized");
            }
            return this.subdir;
        }

        public Statement apply(final Statement base, Description description) {
            this.subdir = TargetDirectory.this.directoryForDescription(description);
            return new Statement(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void evaluate() throws Throwable {
                    boolean success = false;
                    try {
                        base.evaluate();
                        success = true;
                    }
                    finally {
                        TestDirectory.this.complete(success);
                    }
                }
            };
        }

        public String toString() {
            String subdirName = this.subdir == null ? "<uninitialized>" : this.subdir.toString();
            return String.format("%s[%s]", this.getClass().getSimpleName(), subdirName);
        }

        private void complete(boolean success) {
            if (success && this.subdir != null) {
                try {
                    TargetDirectory.this.recursiveDelete(this.subdir);
                }
                catch (RuntimeException e) {
                    if (e.getCause() != null && e.getCause() instanceof FileUtils.MaybeWindowsMemoryMappedFileReleaseProblem) {
                        System.err.println("Failed to delete test directory, maybe due to Windows memory-mapped file problem");
                    }
                    throw e;
                }
            }
            this.subdir = null;
        }
    }
}

