/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.rules.ExternalResource;
import org.neo4j.helpers.Cancelable;
import org.neo4j.helpers.CancellationRequest;
import org.neo4j.helpers.Function;

public class ThreadingRule
extends ExternalResource {
    private ExecutorService executor;

    protected void before() throws Throwable {
        this.executor = Executors.newCachedThreadPool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void after() {
        try {
            this.executor.shutdownNow();
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.executor = null;
        }
    }

    public <FROM, TO> Future<TO> execute(Function<FROM, TO> function, FROM parameter) {
        return this.executor.submit(ThreadingRule.task(function, parameter));
    }

    public Cancelable threadBlockMonitor(Thread thread, Runnable action) {
        CancellationHandle cancellation = new CancellationHandle();
        this.executor.submit(new ThreadBlockMonitor(cancellation, Objects.requireNonNull(thread, "thread"), Objects.requireNonNull(action, "action")));
        return cancellation;
    }

    private static <FROM, TO> Callable<TO> task(final Function<FROM, TO> function, final FROM parameter) {
        return new Callable<TO>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public TO call() throws Exception {
                Thread thread = Thread.currentThread();
                String name = thread.getName();
                thread.setName(function.toString());
                try {
                    Object object = function.apply(parameter);
                    return object;
                }
                finally {
                    thread.setName(name);
                }
            }
        };
    }

    private static class ThreadBlockMonitor
    implements Runnable {
        private final CancellationRequest cancellation;
        private final Thread thread;
        private final Runnable action;

        public ThreadBlockMonitor(CancellationRequest cancellation, Thread thread, Runnable action) {
            this.cancellation = cancellation;
            this.thread = thread;
            this.action = action;
        }

        @Override
        public void run() {
            Object[] lastTrace = null;
            Thread.State lastState = null;
            do {
                Thread.State state = this.thread.getState();
                switch (state) {
                    case BLOCKED: 
                    case WAITING: 
                    case TIMED_WAITING: {
                        Object[] trace = this.thread.getStackTrace();
                        if (lastState == state && Arrays.equals(trace, lastTrace)) {
                            this.action.run();
                            return;
                        }
                        lastTrace = trace;
                        break;
                    }
                    default: {
                        lastTrace = null;
                    }
                }
                lastState = state;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    return;
                }
            } while (!this.cancellation.cancellationRequested());
        }
    }

    private static class CancellationHandle
    implements Cancelable,
    CancellationRequest {
        private volatile boolean cancelled = false;

        private CancellationHandle() {
        }

        public boolean cancellationRequested() {
            return this.cancelled;
        }

        public void cancel() {
            this.cancelled = true;
        }
    }
}

