/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;

public class ChannelInputStream
extends InputStream {
    private final StoreChannel channel;
    private final ByteBuffer buffer = ByteBuffer.allocateDirect(8096);
    private int position;

    public ChannelInputStream(StoreChannel channel) {
        this.channel = channel;
    }

    @Override
    public int read() throws IOException {
        if (!IoPrimitiveUtils.readAndFlip((ReadableByteChannel)this.channel, (ByteBuffer)this.buffer, (int)1)) {
            return -1;
        }
        ++this.position;
        return this.buffer.get();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return super.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        return (int)((long)this.position - this.channel.size());
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

