/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.PrefetchingIterator;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.StoreFileChannel;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.test.impl.ChannelInputStream;
import org.neo4j.test.impl.ChannelOutputStream;
import org.neo4j.test.impl.MultipleExceptionsStrategy;

public class EphemeralFileSystemAbstraction
extends LifecycleAdapter
implements FileSystemAbstraction {
    private final Set<File> directories = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<File, EphemeralFileData> files;
    private final Map<Class<? extends FileSystemAbstraction.ThirdPartyFileSystem>, FileSystemAbstraction.ThirdPartyFileSystem> thirdPartyFileSystems = new HashMap<Class<? extends FileSystemAbstraction.ThirdPartyFileSystem>, FileSystemAbstraction.ThirdPartyFileSystem>();

    public EphemeralFileSystemAbstraction() {
        this.files = new ConcurrentHashMap<File, EphemeralFileData>();
    }

    private EphemeralFileSystemAbstraction(Set<File> directories, Map<File, EphemeralFileData> files) {
        this.files = new ConcurrentHashMap<File, EphemeralFileData>(files);
        this.directories.addAll(directories);
        this.files.putAll(files);
    }

    public synchronized void shutdown() {
        for (EphemeralFileData file : this.files.values()) {
            this.free(file);
        }
        this.files.clear();
        for (FileSystemAbstraction.ThirdPartyFileSystem thirdPartyFileSystem : this.thirdPartyFileSystems.values()) {
            thirdPartyFileSystem.close();
        }
        this.thirdPartyFileSystems.clear();
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    public void assertNoOpenFiles() throws Exception {
        ArrayList<FileStillOpenException> open = new ArrayList<FileStillOpenException>();
        for (EphemeralFileData file : this.files.values()) {
            for (EphemeralFileChannel channel : IteratorUtil.loop(file.getOpenChannels())) {
                open.add(channel.openedAt);
            }
        }
        MultipleExceptionsStrategy.assertEmptyExceptions(open);
    }

    public void dumpZip(OutputStream output) throws IOException {
        try (ZipOutputStream zip = new ZipOutputStream(output);){
            File directory;
            String prefix = null;
            for (Map.Entry<File, EphemeralFileData> entry : this.files.entrySet()) {
                File file = entry.getKey();
                String parent = file.getParentFile().getAbsolutePath();
                if (prefix == null || prefix.startsWith(parent)) {
                    prefix = parent;
                }
                zip.putNextEntry(new ZipEntry(file.getAbsolutePath()));
                entry.getValue().dumpTo(zip);
                zip.closeEntry();
            }
            for (FileSystemAbstraction.ThirdPartyFileSystem fs : this.thirdPartyFileSystems.values()) {
                fs.dumpToZip(zip, (byte[])EphemeralFileData.SCRATCH_PAD.get());
            }
            if (prefix != null && (directory = new File(prefix)).exists()) {
                this.addRecursively(zip, directory);
            }
        }
    }

    private void addRecursively(ZipOutputStream output, File input) throws IOException {
        if (input.isFile()) {
            output.putNextEntry(new ZipEntry(input.getAbsolutePath()));
            byte[] scratchPad = (byte[])EphemeralFileData.SCRATCH_PAD.get();
            try (FileInputStream source = new FileInputStream(input);){
                int read;
                while (0 <= (read = source.read(scratchPad))) {
                    output.write(scratchPad, 0, read);
                }
            }
            output.closeEntry();
        } else {
            File[] children = input.listFiles();
            if (children != null) {
                for (File child : children) {
                    this.addRecursively(output, child);
                }
            }
        }
    }

    private void free(EphemeralFileData file) {
        if (file != null) {
            file.fileAsBuffer.free();
        }
    }

    public synchronized StoreChannel open(File fileName, String mode) throws IOException {
        EphemeralFileData data = this.files.get(fileName);
        if (data != null) {
            return new StoreFileChannel((FileChannel)new EphemeralFileChannel(data, new FileStillOpenException(fileName.getPath())));
        }
        return this.create(fileName);
    }

    public OutputStream openAsOutputStream(File fileName, boolean append) throws IOException {
        return new ChannelOutputStream(this.open(fileName, "rw"), append);
    }

    public InputStream openAsInputStream(File fileName) throws IOException {
        return new ChannelInputStream(this.open(fileName, "r"));
    }

    public Reader openAsReader(File fileName, String encoding) throws IOException {
        return new InputStreamReader(this.openAsInputStream(fileName), encoding);
    }

    public Writer openAsWriter(File fileName, String encoding, boolean append) throws IOException {
        return new OutputStreamWriter(this.openAsOutputStream(fileName, append), encoding);
    }

    public org.neo4j.kernel.impl.nioneo.store.FileLock tryLock(File fileName, StoreChannel channel) throws IOException {
        final FileLock lock = channel.tryLock();
        return new org.neo4j.kernel.impl.nioneo.store.FileLock(){

            public void release() throws IOException {
                lock.release();
            }
        };
    }

    public synchronized StoreChannel create(File fileName) throws IOException {
        File parentFile = fileName.getParentFile();
        if (parentFile != null && !this.fileExists(parentFile)) {
            throw new FileNotFoundException("'" + fileName + "' (The system cannot find the path specified)");
        }
        EphemeralFileData data = new EphemeralFileData();
        this.free(this.files.put(fileName, data));
        return new StoreFileChannel((FileChannel)new EphemeralFileChannel(data, new FileStillOpenException(fileName.getPath())));
    }

    public long getFileSize(File fileName) {
        EphemeralFileData file = this.files.get(fileName);
        return file == null ? 0L : file.size();
    }

    public boolean fileExists(File file) {
        return this.directories.contains(file.getAbsoluteFile()) || this.files.containsKey(file);
    }

    public boolean isDirectory(File file) {
        return this.directories.contains(file.getAbsoluteFile());
    }

    public boolean mkdir(File directory) {
        if (this.fileExists(directory)) {
            return false;
        }
        this.directories.add(directory.getAbsoluteFile());
        return true;
    }

    public void mkdirs(File directory) {
        for (File currentDirectory = directory.getAbsoluteFile(); currentDirectory != null; currentDirectory = currentDirectory.getParentFile()) {
            this.mkdir(currentDirectory);
        }
    }

    public boolean deleteFile(File fileName) {
        EphemeralFileData removed = this.files.remove(fileName);
        this.free(removed);
        return removed != null;
    }

    public void deleteRecursively(File directory) throws IOException {
        List<String> directoryPathItems = this.splitPath(directory);
        for (Map.Entry<File, EphemeralFileData> file : this.files.entrySet()) {
            File fileName = file.getKey();
            List<String> fileNamePathItems = this.splitPath(fileName);
            if (!this.directoryMatches(directoryPathItems, fileNamePathItems)) continue;
            this.deleteFile(fileName);
        }
    }

    public boolean renameFile(File from, File to) throws IOException {
        if (!this.files.containsKey(from)) {
            throw new IOException("'" + from + "' doesn't exist");
        }
        if (this.files.containsKey(to)) {
            throw new IOException("'" + to + "' already exists");
        }
        this.files.put(to, this.files.remove(from));
        return true;
    }

    public File[] listFiles(File directory) {
        if (this.files.containsKey(directory)) {
            return null;
        }
        List<String> directoryPathItems = this.splitPath(directory);
        ArrayList<File> found = new ArrayList<File>();
        for (Map.Entry<File, EphemeralFileData> file : this.files.entrySet()) {
            File fileName = file.getKey();
            List<String> fileNamePathItems = this.splitPath(fileName);
            if (!this.directoryMatches(directoryPathItems, fileNamePathItems)) continue;
            found.add(this.constructPath(fileNamePathItems, directoryPathItems.size() + 1));
        }
        return found.toArray(new File[found.size()]);
    }

    public File[] listFiles(File directory, FilenameFilter filter) {
        if (this.files.containsKey(directory)) {
            return null;
        }
        List<String> directoryPathItems = this.splitPath(directory);
        ArrayList<File> found = new ArrayList<File>();
        for (Map.Entry<File, EphemeralFileData> file : this.files.entrySet()) {
            File path;
            File fileName = file.getKey();
            List<String> fileNamePathItems = this.splitPath(fileName);
            if (!this.directoryMatches(directoryPathItems, fileNamePathItems) || !filter.accept((path = this.constructPath(fileNamePathItems, directoryPathItems.size() + 1)).getParentFile(), path.getName())) continue;
            found.add(path);
        }
        return found.toArray(new File[found.size()]);
    }

    private File constructPath(List<String> pathItems, int count) {
        File file = null;
        for (String pathItem : pathItems.subList(0, count)) {
            file = file == null ? new File(pathItem) : new File(file, pathItem);
        }
        return file;
    }

    private boolean directoryMatches(List<String> directoryPathItems, List<String> fileNamePathItems) {
        return fileNamePathItems.size() > directoryPathItems.size() && fileNamePathItems.subList(0, directoryPathItems.size()).equals(directoryPathItems);
    }

    private List<String> splitPath(File path) {
        return Arrays.asList(path.getPath().replaceAll("\\\\", "/").split("/"));
    }

    public void moveToDirectory(File file, File toDirectory) throws IOException {
        EphemeralFileData fileToMove = this.files.remove(file);
        if (fileToMove == null) {
            throw new FileNotFoundException(file.getPath());
        }
        this.files.put(new File(toDirectory, file.getName()), fileToMove);
    }

    public void copyFile(File from, File to) throws IOException {
        EphemeralFileData data = this.files.get(from);
        if (data == null) {
            throw new FileNotFoundException("File " + from + " not found");
        }
        this.copyFile(from, this, to, this.newCopyBuffer());
    }

    public void copyRecursively(File fromDirectory, File toDirectory) throws IOException {
        this.copyRecursivelyFromOtherFs(fromDirectory, this, toDirectory, this.newCopyBuffer());
    }

    public EphemeralFileSystemAbstraction snapshot() {
        HashMap<File, EphemeralFileData> copiedFiles = new HashMap<File, EphemeralFileData>();
        for (Map.Entry<File, EphemeralFileData> file : this.files.entrySet()) {
            copiedFiles.put(file.getKey(), file.getValue().copy());
        }
        return new EphemeralFileSystemAbstraction(this.directories, copiedFiles);
    }

    public void copyRecursivelyFromOtherFs(File from, FileSystemAbstraction fromFs, File to) throws IOException {
        this.copyRecursivelyFromOtherFs(from, fromFs, to, this.newCopyBuffer());
    }

    private ByteBuffer newCopyBuffer() {
        return ByteBuffer.allocate(0x100000);
    }

    private void copyRecursivelyFromOtherFs(File from, FileSystemAbstraction fromFs, File to, ByteBuffer buffer) throws IOException {
        this.mkdirs(to);
        for (File fromFile : fromFs.listFiles(from)) {
            File toFile = new File(to, fromFile.getName());
            if (fromFs.isDirectory(fromFile)) {
                this.copyRecursivelyFromOtherFs(fromFile, fromFs, toFile);
                continue;
            }
            this.copyFile(fromFile, fromFs, toFile, buffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFile(File from, FileSystemAbstraction fromFs, File to, ByteBuffer buffer) throws IOException {
        StoreChannel source = fromFs.open(from, "r");
        StoreChannel sink = this.open(to, "rw");
        try {
            int available;
            while ((available = (int)(source.size() - source.position())) > 0) {
                buffer.clear();
                buffer.limit(Math.min(available, buffer.capacity()));
                source.read(buffer);
                buffer.flip();
                sink.write(buffer);
            }
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (sink != null) {
                sink.close();
            }
        }
    }

    public synchronized <K extends FileSystemAbstraction.ThirdPartyFileSystem> K getOrCreateThirdPartyFileSystem(Class<K> clazz, Function<Class<K>, K> creator) {
        FileSystemAbstraction.ThirdPartyFileSystem fileSystem = this.thirdPartyFileSystems.get(clazz);
        if (fileSystem == null) {
            fileSystem = (FileSystemAbstraction.ThirdPartyFileSystem)creator.apply(clazz);
            this.thirdPartyFileSystems.put(clazz, fileSystem);
        }
        return (K)((FileSystemAbstraction.ThirdPartyFileSystem)clazz.cast(fileSystem));
    }

    private static class DynamicByteBuffer {
        private static final int[] SIZES;
        private static volatile AtomicReferenceArray<Queue<Reference<ByteBuffer>>> POOLS;
        private static final byte[] zeroBuffer;
        private ByteBuffer buf;

        synchronized DynamicByteBuffer copy() {
            return new DynamicByteBuffer(this.buf);
        }

        public DynamicByteBuffer() {
            this.buf = this.allocate(0);
        }

        private DynamicByteBuffer(ByteBuffer toClone) {
            int sizeIndex = DynamicByteBuffer.sizeIndexFor(toClone.capacity());
            this.buf = this.allocate(sizeIndex);
            this.copyByteBufferContents(toClone, this.buf);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyByteBufferContents(ByteBuffer from, ByteBuffer to) {
            int positionBefore = from.position();
            try {
                from.position(0);
                to.put(from);
            }
            finally {
                from.position(positionBefore);
                to.position(0);
            }
        }

        private ByteBuffer allocate(int sizeIndex) {
            for (int enlargement = 0; enlargement < 2; ++enlargement) {
                Reference<ByteBuffer> ref;
                Queue<Reference<ByteBuffer>> queue;
                AtomicReferenceArray<Queue<Reference<ByteBuffer>>> pools = POOLS;
                if (sizeIndex + enlargement >= pools.length() || (queue = pools.get(sizeIndex + enlargement)) == null) continue;
                while ((ref = queue.poll()) != null) {
                    ByteBuffer buffer = ref.get();
                    if (buffer == null) continue;
                    return buffer;
                }
            }
            return ByteBuffer.allocateDirect(sizeIndex < SIZES.length ? SIZES[sizeIndex] : (sizeIndex - SIZES.length + 1) * SIZES[SIZES.length - 1]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void free() {
            try {
                int sizeIndex;
                this.clear();
                if (sizeIndex == 0) {
                    for (sizeIndex = this.buf.capacity() / SIZES[SIZES.length - 1]; sizeIndex < SIZES.length && this.buf.capacity() != SIZES[sizeIndex]; ++sizeIndex) {
                    }
                } else {
                    sizeIndex += SIZES.length - 1;
                }
                AtomicReferenceArray<Queue<Reference<ByteBuffer>>> pools = POOLS;
                SoftReference<ByteBuffer> ref = new SoftReference<ByteBuffer>(this.buf);
                (sizeIndex < pools.length() ? pools.get(sizeIndex) : DynamicByteBuffer.getOrCreatePoolForSize(sizeIndex)).add(ref);
            }
            finally {
                this.buf = null;
            }
        }

        private static synchronized Queue<Reference<ByteBuffer>> getOrCreatePoolForSize(int sizeIndex) {
            AtomicReferenceArray<Queue<Reference<ByteBuffer>>> pools = POOLS;
            if (sizeIndex >= pools.length()) {
                int i;
                int newSize;
                for (newSize = pools.length(); sizeIndex >= newSize; newSize <<= 1) {
                }
                AtomicReferenceArray<Queue<Reference<ByteBuffer>>> newPool = new AtomicReferenceArray<Queue<Reference<ByteBuffer>>>(newSize);
                for (i = 0; i < pools.length(); ++i) {
                    newPool.set(i, pools.get(i));
                }
                for (i = pools.length(); i < newPool.length(); ++i) {
                    newPool.set(i, new ConcurrentLinkedQueue());
                }
                POOLS = pools = newPool;
            }
            return pools.get(sizeIndex);
        }

        synchronized void put(int pos, byte[] bytes, int offset, int length) {
            this.verifySize(pos + length);
            try {
                this.buf.position(pos);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(this.buf + ", " + pos, e);
            }
            this.buf.put(bytes, offset, length);
        }

        synchronized void get(int pos, byte[] scratchPad, int i, int howMuchToReadThisTime) {
            this.buf.position(pos);
            this.buf.get(scratchPad, i, howMuchToReadThisTime);
        }

        synchronized void fillWithZeros(int pos, int bytes) {
            this.buf.position(pos);
            while (bytes > 0) {
                int howMuchToReadThisTime = Math.min(bytes, zeroBuffer.length);
                this.buf.put(zeroBuffer, 0, howMuchToReadThisTime);
                bytes -= howMuchToReadThisTime;
            }
            this.buf.position(pos);
        }

        private void verifySize(int totalAmount) {
            if (this.buf.capacity() >= totalAmount) {
                return;
            }
            int newSize = this.buf.capacity();
            int sizeIndex = DynamicByteBuffer.sizeIndexFor(newSize);
            while (newSize < totalAmount) {
                newSize += Math.min(newSize, 0x100000);
                ++sizeIndex;
            }
            int oldPosition = this.buf.position();
            ByteBuffer buf = this.allocate(sizeIndex);
            this.buf.position(0);
            buf.put(this.buf);
            this.buf = buf;
            this.buf.position(oldPosition);
        }

        private static int sizeIndexFor(int capacity) {
            int sizeIndex = capacity / SIZES[SIZES.length - 1];
            if (sizeIndex == 0) {
                while (sizeIndex < SIZES.length && capacity != SIZES[sizeIndex]) {
                    ++sizeIndex;
                }
            } else {
                sizeIndex += SIZES.length - 1;
            }
            return sizeIndex;
        }

        public void clear() {
            this.buf.clear();
        }

        void dump(OutputStream target, byte[] scratchPad, int size) throws IOException {
            this.buf.position(0);
            while (size > 0) {
                int read = Math.min(size, scratchPad.length);
                this.buf.get(scratchPad, 0, read);
                size -= read;
                target.write(scratchPad, 0, read);
            }
        }

        static {
            zeroBuffer = new byte[1024];
            int K = 1024;
            SIZES = new int[]{64 * K, 128 * K, 256 * K, 512 * K, 1024 * K};
            POOLS = new AtomicReferenceArray(SIZES.length);
            for (int sizeIndex = 0; sizeIndex < SIZES.length; ++sizeIndex) {
                POOLS.set(sizeIndex, new ConcurrentLinkedQueue());
            }
        }
    }

    private static class EphemeralFileLock
    extends FileLock {
        private EphemeralFileData file;

        EphemeralFileLock(EphemeralFileChannel channel, EphemeralFileData file) {
            super(channel, 0L, Long.MAX_VALUE, false);
            this.file = file;
            file.locked++;
        }

        @Override
        public boolean isValid() {
            return this.file != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void release() throws IOException {
            Collection collection = this.file.channels;
            synchronized (collection) {
                if (this.file == null || this.file.locked == 0) {
                    return;
                }
                this.file.locked--;
                this.file = null;
            }
        }
    }

    private static class EphemeralFileData {
        private static final ThreadLocal<byte[]> SCRATCH_PAD = new ThreadLocal<byte[]>(){

            @Override
            protected byte[] initialValue() {
                return new byte[1024];
            }
        };
        private final DynamicByteBuffer fileAsBuffer;
        private final Collection<WeakReference<EphemeralFileChannel>> channels = new LinkedList<WeakReference<EphemeralFileChannel>>();
        private int size;
        private int locked;

        public EphemeralFileData() {
            this(new DynamicByteBuffer());
        }

        private EphemeralFileData(DynamicByteBuffer data) {
            this.fileAsBuffer = data;
        }

        int read(Positionable fc, ByteBuffer dst) {
            int howMuchToReadThisTime;
            int wanted = dst.limit();
            int available = Math.min(wanted, (int)(this.size() - fc.pos()));
            if (available == 0) {
                return -1;
            }
            byte[] scratchPad = SCRATCH_PAD.get();
            for (int pending = available; pending > 0; pending -= howMuchToReadThisTime) {
                howMuchToReadThisTime = Math.min(pending, scratchPad.length);
                long pos = fc.pos();
                this.fileAsBuffer.get((int)pos, scratchPad, 0, howMuchToReadThisTime);
                fc.pos(pos + (long)howMuchToReadThisTime);
                dst.put(scratchPad, 0, howMuchToReadThisTime);
            }
            return available;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int write(Positionable fc, ByteBuffer src) {
            int wanted;
            int howMuchToWriteThisTime;
            byte[] scratchPad = SCRATCH_PAD.get();
            for (int pending = wanted = src.limit(); pending > 0; pending -= howMuchToWriteThisTime) {
                howMuchToWriteThisTime = Math.min(pending, scratchPad.length);
                src.get(scratchPad, 0, howMuchToWriteThisTime);
                long pos = fc.pos();
                this.fileAsBuffer.put((int)pos, scratchPad, 0, howMuchToWriteThisTime);
                fc.pos(pos += (long)howMuchToWriteThisTime);
            }
            DynamicByteBuffer dynamicByteBuffer = this.fileAsBuffer;
            synchronized (dynamicByteBuffer) {
                int newSize = Math.max(this.size, (int)fc.pos());
                int intermediaryBytes = newSize - wanted - this.size;
                if (intermediaryBytes > 0) {
                    this.fileAsBuffer.fillWithZeros(this.size, intermediaryBytes);
                }
                this.size = newSize;
            }
            return wanted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        EphemeralFileData copy() {
            DynamicByteBuffer dynamicByteBuffer = this.fileAsBuffer;
            synchronized (dynamicByteBuffer) {
                EphemeralFileData copy = new EphemeralFileData(this.fileAsBuffer.copy());
                copy.size = this.size;
                return copy;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void open(EphemeralFileChannel channel) {
            Collection<WeakReference<EphemeralFileChannel>> collection = this.channels;
            synchronized (collection) {
                this.channels.add(new WeakReference<EphemeralFileChannel>(channel));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void close(EphemeralFileChannel channel) {
            Collection<WeakReference<EphemeralFileChannel>> collection = this.channels;
            synchronized (collection) {
                this.locked = 0;
                Iterator<EphemeralFileChannel> iter = this.getOpenChannels();
                while (iter.hasNext()) {
                    if (iter.next() != channel) continue;
                    iter.remove();
                }
            }
        }

        Iterator<EphemeralFileChannel> getOpenChannels() {
            final Iterator<WeakReference<EphemeralFileChannel>> refs = this.channels.iterator();
            return new PrefetchingIterator<EphemeralFileChannel>(){

                protected EphemeralFileChannel fetchNextOrNull() {
                    while (refs.hasNext()) {
                        EphemeralFileChannel channel = (EphemeralFileChannel)((WeakReference)refs.next()).get();
                        if (channel != null) {
                            return channel;
                        }
                        refs.remove();
                    }
                    return null;
                }

                public void remove() {
                    refs.remove();
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        long size() {
            DynamicByteBuffer dynamicByteBuffer = this.fileAsBuffer;
            synchronized (dynamicByteBuffer) {
                return this.size;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void truncate(long newSize) {
            DynamicByteBuffer dynamicByteBuffer = this.fileAsBuffer;
            synchronized (dynamicByteBuffer) {
                this.size = (int)newSize;
            }
        }

        boolean lock() {
            return this.locked == 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dumpTo(OutputStream target) throws IOException {
            byte[] scratchPad = SCRATCH_PAD.get();
            DynamicByteBuffer dynamicByteBuffer = this.fileAsBuffer;
            synchronized (dynamicByteBuffer) {
                this.fileAsBuffer.dump(target, scratchPad, this.size);
            }
        }
    }

    private static class EphemeralFileChannel
    extends FileChannel
    implements Positionable {
        final FileStillOpenException openedAt;
        private final EphemeralFileData data;
        private long position = 0L;

        EphemeralFileChannel(EphemeralFileData data, FileStillOpenException opened) {
            this.data = data;
            this.openedAt = opened;
            data.open(this);
        }

        public String toString() {
            return String.format("%s[%s]", this.getClass().getSimpleName(), this.openedAt.filename);
        }

        @Override
        public int read(ByteBuffer dst) {
            return this.data.read(this, dst);
        }

        @Override
        public long read(ByteBuffer[] dsts, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return this.data.write(this, src);
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) {
            throw new UnsupportedOperationException();
        }

        @Override
        public long position() throws IOException {
            return this.position;
        }

        @Override
        public FileChannel position(long newPosition) throws IOException {
            this.position = newPosition;
            return this;
        }

        @Override
        public long size() throws IOException {
            return this.data.size();
        }

        @Override
        public FileChannel truncate(long size) throws IOException {
            this.data.truncate(size);
            return this;
        }

        @Override
        public void force(boolean metaData) {
        }

        @Override
        public long transferTo(long position, long count, WritableByteChannel target) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long transferFrom(ReadableByteChannel src, long position, long count) throws IOException {
            long previousPos = this.position();
            this.position(position);
            try {
                long transferred;
                int read;
                ByteBuffer intermediary = ByteBuffer.allocateDirect(8096);
                for (transferred = 0L; transferred < count; transferred += (long)read) {
                    intermediary.clear();
                    intermediary.limit((int)Math.min((long)intermediary.capacity(), count - transferred));
                    read = src.read(intermediary);
                    if (read == -1) break;
                    intermediary.flip();
                }
                long l = transferred;
                return l;
            }
            finally {
                this.position(previousPos);
            }
        }

        @Override
        public int read(ByteBuffer dst, long position) throws IOException {
            return this.data.read(new LocalPosition(position), dst);
        }

        @Override
        public int write(ByteBuffer src, long position) throws IOException {
            return this.data.write(new LocalPosition(position), src);
        }

        @Override
        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            throw new IOException("Not supported");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileLock lock(long position, long size, boolean shared) throws IOException {
            Collection collection = this.data.channels;
            synchronized (collection) {
                if (!this.data.lock()) {
                    return null;
                }
                return new EphemeralFileLock(this, this.data);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public FileLock tryLock(long position, long size, boolean shared) throws IOException {
            Collection collection = this.data.channels;
            synchronized (collection) {
                if (!this.data.lock()) {
                    throw new IOException("Locked");
                }
                return new EphemeralFileLock(this, this.data);
            }
        }

        @Override
        protected void implCloseChannel() throws IOException {
            this.data.close(this);
        }

        @Override
        public long pos() {
            return this.position;
        }

        @Override
        public void pos(long position) {
            this.position = position;
        }
    }

    static class LocalPosition
    implements Positionable {
        private long position;

        public LocalPosition(long position) {
            this.position = position;
        }

        @Override
        public long pos() {
            return this.position;
        }

        @Override
        public void pos(long position) {
            this.position = position;
        }
    }

    static interface Positionable {
        public long pos();

        public void pos(long var1);
    }

    private static class FileStillOpenException
    extends Exception {
        private final String filename;

        FileStillOpenException(String filename) {
            super("File still open: [" + filename + "]");
            this.filename = filename;
        }
    }
}

