/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.impl;

import java.io.File;
import java.util.EnumMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.IdGeneratorFactory;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.IdGenerator;
import org.neo4j.kernel.impl.nioneo.store.IdRange;

public class EphemeralIdGenerator
implements IdGenerator {
    private final AtomicLong nextId = new AtomicLong();
    private final IdType idType;
    private final Queue<Long> freeList;
    private final AtomicInteger freedButNotReturnableIdCount = new AtomicInteger();

    public EphemeralIdGenerator(IdType idType) {
        this.idType = idType;
        this.freeList = idType != null && idType.allowAggressiveReuse() ? new ConcurrentLinkedQueue() : null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.idType + "]";
    }

    public long nextId() {
        Long id;
        if (this.freeList != null && (id = this.freeList.poll()) != null) {
            return id;
        }
        return this.nextId.getAndIncrement();
    }

    public IdRange nextIdBatch(int size) {
        throw new UnsupportedOperationException();
    }

    public void setHighId(long id) {
        this.nextId.set(id);
    }

    public long getHighId() {
        return this.nextId.get();
    }

    public void freeId(long id) {
        if (this.freeList != null) {
            this.freeList.add(id);
        } else {
            this.freedButNotReturnableIdCount.getAndIncrement();
        }
    }

    public void close() {
    }

    public long getNumberOfIdsInUse() {
        long result = this.freeList == null ? this.nextId.get() : this.nextId.get() - (long)this.freeList.size();
        return result - (long)this.freedButNotReturnableIdCount.get();
    }

    public long getDefragCount() {
        return 0L;
    }

    public void delete() {
    }

    public static class Factory
    implements IdGeneratorFactory {
        private final Map<IdType, IdGenerator> generators = new EnumMap<IdType, IdGenerator>(IdType.class);

        public IdGenerator open(FileSystemAbstraction fs, File fileName, int grabSize, IdType idType, long highId) {
            IdGenerator generator = this.generators.get(idType);
            if (generator == null) {
                generator = new EphemeralIdGenerator(idType);
                this.generators.put(idType, generator);
            }
            return generator;
        }

        public void create(FileSystemAbstraction fs, File fileName, long highId) {
        }

        public IdGenerator get(IdType idType) {
            return this.generators.get(idType);
        }
    }
}

