/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.mocking;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.test.Property;

public class Properties
implements Answer<Object>,
Iterable<String> {
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public static Properties properties(Property ... properties) {
        return new Properties(properties);
    }

    public static Properties properties(Map<String, Object> properties) {
        return new Properties(properties);
    }

    private Properties(Property[] properties) {
        for (Property property : properties) {
            this.properties.put(property.key(), property.value());
        }
    }

    private Properties(Map<String, Object> properties) {
        this.properties.putAll(properties);
    }

    public Object answer(InvocationOnMock invocation) throws Throwable {
        Object[] arguments = invocation.getArguments();
        Object result = this.properties.get(arguments[0]);
        if (result == null) {
            if (arguments.length == 2) {
                return arguments[1];
            }
            throw new NotFoundException();
        }
        return result;
    }

    @Override
    public Iterator<String> iterator() {
        return this.properties.keySet().iterator();
    }
}

