/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test.subprocess;

import com.sun.jdi.Bootstrap;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.EventQueue;
import com.sun.jdi.event.EventSet;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.event.MonitorContendedEnterEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequestManager;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.neo4j.helpers.Predicate;
import org.neo4j.test.ProcessStreamHandler;
import org.neo4j.test.subprocess.BreakPoint;
import org.neo4j.test.subprocess.ConnectionDisruptedException;
import org.neo4j.test.subprocess.DebugInterface;
import org.neo4j.test.subprocess.DebuggedThread;
import org.neo4j.test.subprocess.DebuggerDeadlockCallback;
import org.neo4j.test.subprocess.KillSubProcess;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public abstract class SubProcess<T, P>
implements Serializable {
    private final Class<T> t;
    private final transient Predicate<String> classPathFilter;
    private volatile transient boolean alive;
    private static final Field PID;
    private int lastPid = 0;
    private static PipeThread piper;
    private static Set<Handler> live;

    public SubProcess(Predicate<String> classPathFilter) {
        Class<NoInterface> t;
        if (this.getClass().getSuperclass() != SubProcess.class) {
            throw new ClassCastException(SubProcess.class.getName() + " may only be extended one level ");
        }
        Class<?> me = this.getClass();
        while (me.getSuperclass() != SubProcess.class) {
            me = me.getSuperclass();
        }
        Type type = ((ParameterizedType)me.getGenericSuperclass()).getActualTypeArguments()[0];
        if (type instanceof Class) {
            t = (Class<NoInterface>)((Object)type);
        } else if (type instanceof ParameterizedType) {
            t = (Class)((ParameterizedType)type).getRawType();
        } else {
            throw new ClassCastException("Illegal type parameter " + type);
        }
        if (t == Object.class) {
            t = NoInterface.class;
        }
        if (!t.isInterface()) {
            throw new ClassCastException(t + " is not an interface");
        }
        if (!t.isAssignableFrom(this.getClass()) && t != NoInterface.class) {
            throw new ClassCastException(this.getClass().getName() + " must implement declared interface " + t);
        }
        this.t = t;
        this.classPathFilter = classPathFilter;
    }

    public SubProcess() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T start(P parameter, BreakPoint ... breakpoints) {
        Dispatcher dispatcher;
        String pid;
        Process process;
        DispatcherTrapImpl callback;
        DebuggerConnector debugger = null;
        if (breakpoints != null && breakpoints.length != 0) {
            debugger = new DebuggerConnector(breakpoints);
        }
        try {
            callback = new DispatcherTrapImpl(this, parameter);
        }
        catch (RemoteException e) {
            throw new RuntimeException("Failed to create local RMI endpoint.", e);
        }
        DebugDispatch debugDispatch = null;
        try {
            Object object = debugger != null ? DebuggerConnector.class : new Object();
            synchronized (object) {
                process = debugger != null ? SubProcess.start("java", "-Xmx1G", debugger.listen(), "-Djava.awt.headless=true", "-cp", this.classPath(System.getProperty("java.class.path")), SubProcess.class.getName(), SubProcess.serialize(callback)) : SubProcess.start("java", "-Xmx1G", "-Djava.awt.headless=true", "-cp", this.classPath(System.getProperty("java.class.path")), SubProcess.class.getName(), SubProcess.serialize(callback));
                pid = this.getPid(process);
                SubProcess.pipe("[" + this.toString() + ":" + pid + "] ", process.getErrorStream(), this.errorStreamTarget());
                SubProcess.pipe("[" + this.toString() + ":" + pid + "] ", process.getInputStream(), this.inputStreamTarget());
                if (debugger != null) {
                    debugDispatch = debugger.connect(this.toString() + ":" + pid);
                }
            }
            dispatcher = callback.get(process);
        }
        finally {
            try {
                UnicastRemoteObject.unexportObject(callback, true);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        if (dispatcher == null) {
            throw new IllegalStateException("failed to start sub process");
        }
        Handler handler = new Handler(this.t, dispatcher, process, "<" + this.toString() + ":" + pid + ">", debugDispatch);
        if (debugDispatch != null) {
            debugDispatch.handler = handler;
        }
        return this.t.cast(Proxy.newProxyInstance(this.t.getClassLoader(), new Class[]{this.t}, SubProcess.live(handler)));
    }

    protected PrintStream errorStreamTarget() {
        return System.err;
    }

    protected PrintStream inputStreamTarget() {
        return System.out;
    }

    private String classPath(String parentClasspath) {
        if (this.classPathFilter == null) {
            return parentClasspath;
        }
        StringBuilder result = new StringBuilder();
        for (String part : parentClasspath.split(File.pathSeparator)) {
            if (!this.classPathFilter.accept((Object)part)) continue;
            result.append(result.length() > 0 ? File.pathSeparator : "").append(part);
        }
        return result.toString();
    }

    private static Process start(String ... args) {
        ProcessBuilder builder = new ProcessBuilder(args);
        try {
            return builder.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to start sub process", e);
        }
    }

    protected abstract void startup(P var1) throws Throwable;

    public final void shutdown() {
        this.shutdown(true);
    }

    protected void shutdown(boolean normal) {
        System.exit(0);
    }

    public static void stop(Object subprocess) {
        ((Handler)Proxy.getInvocationHandler(subprocess)).stop(null, 0L);
    }

    public static void stop(Object subprocess, long timeout, TimeUnit unit) {
        ((Handler)Proxy.getInvocationHandler(subprocess)).stop(unit, timeout);
    }

    public static void kill(Object subprocess) {
        ((Handler)Proxy.getInvocationHandler(subprocess)).kill(true);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public static void main(String[] args) throws Throwable {
        if (args.length != 1) {
            throw new IllegalArgumentException("Needs to be started from " + SubProcess.class.getName());
        }
        DispatcherTrap trap = SubProcess.deserialize(args[0]);
        SubProcess<?, Object> subProcess = trap.getSubProcess();
        super.doStart(trap.trap(new DispatcherImpl(subProcess)));
    }

    private void doStart(P parameter) throws Throwable {
        this.alive = true;
        this.startup(parameter);
        this.liveLoop();
    }

    private void doStop(boolean normal) {
        this.alive = false;
        this.shutdown(normal);
    }

    private void liveLoop() throws Exception {
        while (this.alive) {
            for (int i = System.in.available(); i >= 0; --i) {
                if (System.in.read() == -1) {
                    this.doStop(false);
                }
                Thread.sleep(1L);
            }
        }
    }

    private String getPid(Process process) {
        if (PID != null) {
            try {
                return PID.get(process).toString();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Integer.toString(this.lastPid++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pipe(String prefix, InputStream source, PrintStream target) {
        Class<PipeThread> clazz = PipeThread.class;
        synchronized (PipeThread.class) {
            if (piper == null) {
                piper = new PipeThread();
                piper.start();
            }
            SubProcess.piper.tasks.add(new PipeTask(prefix, source, target));
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static String serialize(DispatcherTrapImpl obj) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(RemoteObject.toStub(obj));
            oos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Broken implementation!", e);
        }
        return new BASE64Encoder().encode(os.toByteArray());
    }

    private static DispatcherTrap deserialize(String data) {
        try {
            return (DispatcherTrap)new ObjectInputStream(new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(data))).readObject();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InvocationHandler live(Handler handler) {
        try {
            Class<Handler> clazz = Handler.class;
            synchronized (Handler.class) {
                if (live == null) {
                    live = new HashSet<Handler>();
                    final HashSet<Handler> handlers = live;
                    Runtime.getRuntime().addShutdownHook(new Thread(){

                        @Override
                        public void run() {
                            SubProcess.killAll(handlers);
                        }
                    });
                }
                live.add(handler);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        }
        catch (UnsupportedOperationException e) {
            handler.kill(false);
            throw new IllegalStateException("JVM is shutting down!");
        }
        {
            return handler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dead(Handler handler) {
        Class<Handler> clazz = Handler.class;
        synchronized (Handler.class) {
            try {
                if (live != null) {
                    live.remove(handler);
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void killAll(Set<Handler> handlers) {
        Class<Handler> clazz = Handler.class;
        synchronized (Handler.class) {
            if (!handlers.isEmpty()) {
                for (Handler handler : handlers) {
                    try {
                        handler.process.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        handler.kill(false);
                    }
                }
            }
            live = Collections.emptySet();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    static {
        Field pid;
        try {
            pid = Class.forName("java.lang.UNIXProcess").getDeclaredField("pid");
            pid.setAccessible(true);
        }
        catch (Throwable ex) {
            pid = null;
        }
        PID = pid;
    }

    private static class DispatcherImpl
    extends UnicastRemoteObject
    implements Dispatcher {
        private final transient SubProcess<?, ?> subprocess;

        protected DispatcherImpl(SubProcess<?, ?> subprocess) throws RemoteException {
            this.subprocess = subprocess;
        }

        @Override
        public Object dispatch(String name, String[] types, Object[] args) throws Throwable {
            Class[] params = new Class[types.length];
            for (int i = 0; i < params.length; ++i) {
                params[i] = Class.forName(types[i]);
            }
            try {
                return ((SubProcess)this.subprocess).t.getMethod(name, params).invoke(this.subprocess, args);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }

        @Override
        public void stop() throws RemoteException {
            ((SubProcess)this.subprocess).doStop(true);
        }
    }

    private static class Handler
    implements InvocationHandler {
        private final Dispatcher dispatcher;
        private final Process process;
        private final Class<?> type;
        private final String repr;
        private final DebugDispatch debugDispatch;

        Handler(Class<?> type, Dispatcher dispatcher, Process process, String repr, DebugDispatch debugDispatch) {
            this.type = type;
            this.dispatcher = dispatcher;
            this.process = process;
            this.repr = repr;
            this.debugDispatch = debugDispatch;
        }

        public String toString() {
            return this.repr;
        }

        void kill(boolean wait) {
            this.process.destroy();
            if (wait) {
                SubProcess.dead(this);
                Handler.await(this.process);
            }
        }

        int stop(TimeUnit unit, long timeout) {
            final CountDownLatch latch = new CountDownLatch(unit == null ? 0 : 1);
            Thread stopper = new Thread(){

                @Override
                public void run() {
                    latch.countDown();
                    try {
                        Handler.this.dispatcher.stop();
                    }
                    catch (RemoteException e) {
                        Handler.this.process.destroy();
                    }
                }
            };
            stopper.start();
            try {
                latch.await();
                timeout = System.currentTimeMillis() + (unit == null ? 0L : unit.toMillis(timeout));
                while (stopper.isAlive() && System.currentTimeMillis() < timeout) {
                    Thread.sleep(1L);
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (stopper.isAlive()) {
                stopper.interrupt();
            }
            SubProcess.dead(this);
            return Handler.await(this.process);
        }

        private static int await(Process process) {
            return new ProcessStreamHandler(process, true).waitForResult();
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                if (method.getDeclaringClass() == this.type) {
                    return this.dispatch(method, args);
                }
                if (method.getDeclaringClass() == Object.class) {
                    return method.invoke((Object)this, args);
                }
                throw new UnsupportedOperationException(method.toString());
            }
            catch (ServerError ex) {
                throw ex.detail;
            }
            catch (RemoteException ex) {
                throw new ConnectionDisruptedException(ex);
            }
        }

        private Object dispatch(Method method, Object[] args) throws Throwable {
            Class<?>[] params = method.getParameterTypes();
            String[] types = new String[params.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = params[i].getName();
            }
            return this.dispatcher.dispatch(method.getName(), types, args);
        }
    }

    private static interface Dispatcher
    extends Remote {
        public void stop() throws RemoteException;

        public Object dispatch(String var1, String[] var2, Object[] var3) throws RemoteException, Throwable;
    }

    private static class DispatcherTrapImpl
    extends UnicastRemoteObject
    implements DispatcherTrap {
        private final Object parameter;
        private volatile Dispatcher dispatcher;
        private final SubProcess<?, ?> process;

        DispatcherTrapImpl(SubProcess<?, ?> process, Object parameter) throws RemoteException {
            this.process = process;
            this.parameter = parameter;
        }

        Dispatcher get(Process process) {
            while (this.dispatcher == null) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                try {
                    process.exitValue();
                }
                catch (IllegalThreadStateException e) {
                    continue;
                }
                return null;
            }
            return this.dispatcher;
        }

        @Override
        public synchronized Object trap(Dispatcher dispatcher) {
            if (this.dispatcher != null) {
                throw new IllegalStateException("Dispatcher already trapped!");
            }
            this.dispatcher = dispatcher;
            return this.parameter;
        }

        @Override
        public SubProcess<?, Object> getSubProcess() {
            return this.process;
        }
    }

    private static interface DispatcherTrap
    extends Remote {
        public Object trap(Dispatcher var1) throws RemoteException;

        public SubProcess<?, Object> getSubProcess() throws RemoteException;
    }

    private static class PipeThread
    extends Thread {
        final CopyOnWriteArrayList<PipeTask> tasks;

        private PipeThread() {
            this.setName(this.getClass().getSimpleName());
            this.tasks = new CopyOnWriteArrayList();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            while (true) {
                ArrayList<PipeTask> done = new ArrayList<PipeTask>();
                for (PipeTask task : this.tasks) {
                    if (task.pipe()) continue;
                    done.add(task);
                }
                if (!done.isEmpty()) {
                    this.tasks.removeAll(done);
                }
                if (this.tasks.isEmpty()) {
                    Class<PipeThread> i$ = PipeThread.class;
                    // MONITORENTER : org.neo4j.test.subprocess.SubProcess$PipeThread.class
                    if (this.tasks.isEmpty()) {
                        piper = null;
                        // MONITOREXIT : i$
                        return;
                    }
                    // MONITOREXIT : i$
                }
                try {
                    Thread.sleep(10L);
                    continue;
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                    continue;
                }
                break;
            }
        }
    }

    private static class PipeTask {
        private final String prefix;
        private final InputStream source;
        private final PrintStream target;
        private StringBuilder line;

        PipeTask(String prefix, InputStream source, PrintStream target) {
            this.prefix = prefix;
            this.source = source;
            this.target = target;
            this.line = new StringBuilder();
        }

        boolean pipe() {
            try {
                byte[] data = new byte[Math.max(1, this.source.available())];
                int bytesRead = this.source.read(data);
                if (bytesRead == -1) {
                    this.printLastLine();
                    return false;
                }
                if (bytesRead < data.length) {
                    data = Arrays.copyOf(data, bytesRead);
                }
                ByteBuffer chars = ByteBuffer.wrap(data);
                while (chars.hasRemaining()) {
                    char c = (char)chars.get();
                    this.line.append(c);
                    if (c != '\n') continue;
                    this.print();
                }
            }
            catch (IOException e) {
                this.printLastLine();
                return false;
            }
            return true;
        }

        private void printLastLine() {
            if (this.line.length() > 0) {
                this.line.append('\n');
                this.print();
            }
        }

        private void print() {
            this.target.print(this.prefix + this.line.toString());
            this.line = new StringBuilder();
        }
    }

    static class DeadlockDetectedError
    extends Error {
        DeadlockDetectedError() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }

    static class DebugDispatch
    implements Runnable {
        volatile Handler handler;
        private final EventQueue queue;
        private final Map<String, List<BreakPoint>> breakpoints;
        private final Map<ThreadReference, DebuggerDeadlockCallback> suspended = new HashMap<ThreadReference, DebuggerDeadlockCallback>();
        static final DebuggerDeadlockCallback defaultCallback = new DebuggerDeadlockCallback(){

            @Override
            public void deadlock(DebuggedThread thread) {
                throw new DeadlockDetectedError();
            }
        };

        static DebugDispatch get(Object o) {
            InvocationHandler handler;
            if (Proxy.isProxyClass(o.getClass()) && (handler = Proxy.getInvocationHandler(o)) instanceof Handler) {
                return ((Handler)handler).debugDispatch;
            }
            throw new IllegalArgumentException("Not a sub process: " + o);
        }

        DebugDispatch(EventQueue queue, Map<String, List<BreakPoint>> breakpoints) {
            this.queue = queue;
            this.breakpoints = breakpoints;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block12: while (true) {
                EventSet events;
                try {
                    events = this.queue.remove();
                }
                catch (InterruptedException e) {
                    return;
                }
                Integer exitCode = null;
                try {
                    Iterator i$ = events.iterator();
                    while (true) {
                        if (!i$.hasNext()) continue block12;
                        Event event = (Event)i$.next();
                        if (event instanceof MonitorContendedEnterEvent) {
                            ThreadReference thread;
                            MonitorContendedEnterEvent monitor = (MonitorContendedEnterEvent)event;
                            try {
                                thread = monitor.monitor().owningThread();
                            }
                            catch (IncompatibleThreadStateException e) {
                                e.printStackTrace();
                                continue;
                            }
                            if (thread == null || !thread.isSuspended()) continue;
                            DebuggerDeadlockCallback callback = this.suspended.get(thread);
                            try {
                                if (callback == null) continue;
                                callback.deadlock(new DebuggedThread(this, thread));
                            }
                            catch (DeadlockDetectedError deadlock) {
                                Handler handler = this.handler;
                                if (handler == null) continue;
                                handler.kill(false);
                            }
                            continue;
                        }
                        if (event instanceof LocatableEvent) {
                            this.callback((LocatableEvent)event);
                            continue;
                        }
                        if (event instanceof ClassPrepareEvent) {
                            this.setup(((ClassPrepareEvent)event).referenceType());
                            continue;
                        }
                        if (!(event instanceof VMDisconnectEvent) && !(event instanceof VMDeathEvent)) continue;
                        return;
                    }
                }
                catch (KillSubProcess kill) {
                    exitCode = kill.exitCode;
                    continue;
                }
                finally {
                    if (exitCode != null) {
                        events.virtualMachine().exit(exitCode);
                        continue;
                    }
                    events.resume();
                    continue;
                }
                break;
            }
        }

        private void setup(ReferenceType type) {
            List<BreakPoint> list = this.breakpoints.get(type.name());
            if (list == null) {
                return;
            }
            for (BreakPoint breakpoint : list) {
                breakpoint.setup(type);
            }
        }

        private void callback(LocatableEvent event) throws KillSubProcess {
            List<BreakPoint> list = this.breakpoints.get(event.location().declaringType().name());
            if (list == null) {
                return;
            }
            com.sun.jdi.Method method = event.location().method();
            for (BreakPoint breakpoint : list) {
                if (!breakpoint.matches(method.name(), method.argumentTypeNames()) || !breakpoint.enabled) continue;
                breakpoint.invoke(new DebugInterface(this, event));
            }
        }

        void suspended(ThreadReference thread, DebuggerDeadlockCallback callback) {
            if (callback == null) {
                callback = defaultCallback;
            }
            this.suspended.put(thread, callback);
        }

        void resume(ThreadReference thread) {
            this.suspended.remove(thread);
        }

        DebuggedThread[] suspendedThreads() {
            if (this.suspended.isEmpty()) {
                return new DebuggedThread[0];
            }
            ArrayList<DebuggedThread> threads = new ArrayList<DebuggedThread>();
            for (ThreadReference thread : this.suspended.keySet()) {
                threads.add(new DebuggedThread(this, thread));
            }
            return threads.toArray(new DebuggedThread[threads.size()]);
        }
    }

    private static class DebuggerConnector {
        private static final ListeningConnector connector;
        private final Map<String, List<BreakPoint>> breakpoints = new HashMap<String, List<BreakPoint>>();
        private final Map<String, ? extends Connector.Argument> args = connector.defaultArguments();

        DebuggerConnector(BreakPoint[] breakpoints) {
            for (BreakPoint breakpoint : breakpoints) {
                List<BreakPoint> list = this.breakpoints.get(breakpoint.type);
                if (list == null) {
                    list = new ArrayList<BreakPoint>();
                    this.breakpoints.put(breakpoint.type, list);
                }
                list.add(breakpoint);
            }
        }

        String listen() {
            try {
                return String.format("-agentlib:jdwp=transport=%s,address=%s", connector.transport().name(), connector.startListening(this.args));
            }
            catch (Exception e) {
                throw new UnsupportedOperationException("Debugger not supported", e);
            }
        }

        DebugDispatch connect(String string) {
            VirtualMachine vm;
            try {
                vm = connector.accept(this.args);
                connector.stopListening(this.args);
            }
            catch (Exception e) {
                throw new RuntimeException("Debugger connection failure", e);
            }
            EventRequestManager erm = vm.eventRequestManager();
            block2: for (Map.Entry<String, List<BreakPoint>> entry : this.breakpoints.entrySet()) {
                for (ReferenceType type : vm.classesByName(entry.getKey())) {
                    if (!type.name().equals(entry.getKey())) continue;
                    for (BreakPoint breakpoint : entry.getValue()) {
                        breakpoint.setup(type);
                    }
                    continue block2;
                }
                ClassPrepareRequest prepare = erm.createClassPrepareRequest();
                prepare.addClassFilter(entry.getKey());
                prepare.enable();
            }
            if (vm.canRequestMonitorEvents()) {
                erm.createMonitorContendedEnterRequest().enable();
            }
            DebugDispatch dispatch = new DebugDispatch(vm.eventQueue(), this.breakpoints);
            new Thread((Runnable)dispatch, "Debugger: [" + string + "]").start();
            return dispatch;
        }

        static {
            ListeningConnector first = null;
            Iterator<ListeningConnector> i$ = Bootstrap.virtualMachineManager().listeningConnectors().iterator();
            if (i$.hasNext()) {
                ListeningConnector conn;
                first = conn = i$.next();
            }
            connector = first;
        }
    }

    private static interface NoInterface {
    }
}

