/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.neo4j.graphdb.factory.GraphDatabaseSettings;
import org.neo4j.helpers.Settings;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.DefaultFileSystemAbstraction;
import org.neo4j.kernel.StoreLockException;
import org.neo4j.kernel.StoreLocker;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.kernel.impl.nioneo.store.NeoStore;
import org.neo4j.test.ReflectionUtil;
import org.neo4j.test.TargetDirectory;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class BatchInserterImplTest {
    private void assumeNotWindows() {
        Assume.assumeTrue((!Settings.osIsWindows() ? 1 : 0) != 0);
    }

    @Test
    public void testHonorsPassedInParams() throws Exception {
        this.assumeNotWindows();
        Boolean memoryMappingConfig = this.createInserterAndGetMemoryMappingConfig(MapUtil.stringMap((String[])new String[]{GraphDatabaseSettings.use_memory_mapped_buffers.name(), "true"}));
        Assert.assertTrue((String)"memory mapped config is active", (boolean)memoryMappingConfig);
    }

    @Test
    public void testDefaultsToNoMemoryMapping() throws Exception {
        this.assumeNotWindows();
        Boolean memoryMappingConfig = this.createInserterAndGetMemoryMappingConfig(MapUtil.stringMap((String[])new String[0]));
        Assert.assertFalse((String)"memory mapped config is active", (boolean)memoryMappingConfig);
    }

    @Test
    public void testCreatesStoreLockFile() {
        File file = TargetDirectory.forTest(this.getClass()).makeGraphDbDir();
        BatchInserter inserter = BatchInserters.inserter((String)file.getAbsolutePath());
        Assert.assertThat((Object)new File(file, "store_lock").exists(), (Matcher)CoreMatchers.equalTo((Object)true));
        inserter.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testFailsOnExistingStoreLockFile() throws IOException {
        File parent = TargetDirectory.forTest(this.getClass()).makeGraphDbDir();
        StoreLocker lock = new StoreLocker((FileSystemAbstraction)new DefaultFileSystemAbstraction());
        lock.checkLock(parent);
        try {
            BatchInserters.inserter((String)parent.getAbsolutePath());
            Assert.fail();
        }
        catch (StoreLockException storeLockException) {
        }
        finally {
            lock.release();
        }
    }

    private Boolean createInserterAndGetMemoryMappingConfig(Map<String, String> initialConfig) throws Exception {
        BatchInserter inserter = BatchInserters.inserter((String)TargetDirectory.forTest(this.getClass()).makeGraphDbDir().getAbsolutePath(), initialConfig);
        NeoStore neoStore = ReflectionUtil.getPrivateField(inserter, "neoStore", NeoStore.class);
        Config config = ReflectionUtil.getPrivateField(neoStore, "conf", Config.class);
        inserter.shutdown();
        return (Boolean)config.get(GraphDatabaseSettings.use_memory_mapped_buffers);
    }
}

