/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestName;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.helpers.collection.MapUtil;
import org.neo4j.kernel.IdType;
import org.neo4j.kernel.impl.core.BigStoreIT;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.unsafe.batchinsert.BatchInserter;
import org.neo4j.unsafe.batchinsert.BatchInserterImpl;
import org.neo4j.unsafe.batchinsert.BatchInserters;
import org.neo4j.unsafe.batchinsert.BatchRelationship;

public class BigBatchStoreIT
implements RelationshipType {
    private static final String PATH = "target/var/bigb";
    @Rule
    public EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private BatchInserter db;
    @Rule
    public TestName testName = new TestName(){

        public String getMethodName() {
            return BigBatchStoreIT.this.getClass().getSimpleName() + "#" + super.getMethodName();
        }
    };

    @Before
    public void doBefore() {
        this.db = BatchInserters.inserter((String)PATH, (FileSystemAbstraction)this.fs.get());
    }

    @After
    public void doAfter() {
        this.db.shutdown();
    }

    public String name() {
        return "BIG_TYPE";
    }

    @Test
    public void create4BPlusStuff() throws Exception {
        this.testHighIds((long)Math.pow(2.0, 32.0), 2, 1000);
    }

    @Test
    public void create8BPlusStuff() throws Exception {
        this.testHighIds((long)Math.pow(2.0, 33.0), 1, 1600);
    }

    private void testHighIds(long highMark, int minus, int requiredHeapMb) {
        Assume.assumeTrue((boolean)BigStoreIT.machineIsOkToRunThisTest(this.testName.getMethodName(), requiredHeapMb));
        long idBelow = highMark - (long)minus;
        this.setHighId(IdType.NODE, idBelow);
        this.setHighId(IdType.RELATIONSHIP, idBelow);
        this.setHighId(IdType.PROPERTY, idBelow);
        this.setHighId(IdType.ARRAY_BLOCK, idBelow);
        this.setHighId(IdType.STRING_BLOCK, idBelow);
        String propertyKey = "name";
        int intPropertyValue = 123;
        String stringPropertyValue = "Long string, longer than would fit in shortstring";
        long[] arrayPropertyValue = new long[]{1021L, 321L, 343212L};
        long nodeBelowTheLine = this.db.createNode(MapUtil.map((Object[])new Object[]{propertyKey, intPropertyValue}), new Label[0]);
        Assert.assertEquals((long)idBelow, (long)nodeBelowTheLine);
        long nodeAboveTheLine = this.db.createNode(MapUtil.map((Object[])new Object[]{propertyKey, stringPropertyValue}), new Label[0]);
        long relBelowTheLine = this.db.createRelationship(nodeBelowTheLine, nodeAboveTheLine, (RelationshipType)this, MapUtil.map((Object[])new Object[]{propertyKey, arrayPropertyValue}));
        Assert.assertEquals((long)idBelow, (long)relBelowTheLine);
        long relAboveTheLine = this.db.createRelationship(nodeAboveTheLine, nodeBelowTheLine, (RelationshipType)this, null);
        Assert.assertEquals((long)highMark, (long)relAboveTheLine);
        Assert.assertEquals((long)highMark, (long)nodeAboveTheLine);
        Assert.assertEquals((Object)intPropertyValue, this.db.getNodeProperties(nodeBelowTheLine).get(propertyKey));
        Assert.assertEquals((Object)stringPropertyValue, this.db.getNodeProperties(nodeAboveTheLine).get(propertyKey));
        Assert.assertTrue((boolean)Arrays.equals(arrayPropertyValue, (long[])this.db.getRelationshipProperties(relBelowTheLine).get(propertyKey)));
        Assert.assertEquals(BigBatchStoreIT.asSet(Arrays.asList(relBelowTheLine, relAboveTheLine)), this.asIds(this.db.getRelationships(idBelow)));
        this.db.shutdown();
        this.db = BatchInserters.inserter((String)PATH, (FileSystemAbstraction)this.fs.get());
        Assert.assertEquals(BigBatchStoreIT.asSet(Arrays.asList(relBelowTheLine, relAboveTheLine)), this.asIds(this.db.getRelationships(idBelow)));
        this.db.shutdown();
        GraphDatabaseService edb = new TestGraphDatabaseFactory().setFileSystem(this.fs.get()).newImpermanentDatabase(PATH);
        Assert.assertEquals((long)nodeAboveTheLine, (long)edb.getNodeById(highMark).getId());
        Assert.assertEquals((long)relBelowTheLine, (long)edb.getNodeById(idBelow).getSingleRelationship((RelationshipType)this, Direction.OUTGOING).getId());
        Assert.assertEquals((long)relAboveTheLine, (long)edb.getNodeById(idBelow).getSingleRelationship((RelationshipType)this, Direction.INCOMING).getId());
        Assert.assertEquals(BigBatchStoreIT.asSet(Arrays.asList(edb.getRelationshipById(relBelowTheLine), edb.getRelationshipById(relAboveTheLine))), BigBatchStoreIT.asSet(IteratorUtil.asCollection((Iterable)edb.getNodeById(idBelow).getRelationships())));
        edb.shutdown();
        this.db = BatchInserters.inserter((String)PATH, (FileSystemAbstraction)this.fs.get());
    }

    @Test(expected=IllegalArgumentException.class)
    public void makeSureCantCreateNodeWithMagicNumber() {
        long id = (long)Math.pow(2.0, 32.0) - 1L;
        this.db.createNode(id, null, new Label[0]);
    }

    private Collection<Long> asIds(Iterable<BatchRelationship> relationships) {
        HashSet<Long> ids = new HashSet<Long>();
        for (BatchRelationship rel : relationships) {
            ids.add(rel.getId());
        }
        return ids;
    }

    private static <T> Collection<T> asSet(Collection<T> collection) {
        return new HashSet<T>(collection);
    }

    private void setHighId(IdType type, long highId) {
        ((BatchInserterImpl)this.db).getIdGeneratorFactory().get(type).setHighId(highId);
    }
}

