/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.batchinsert;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Neo4jMatchers;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Transaction;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.impl.nioneo.store.FileSystemAbstraction;
import org.neo4j.test.TestGraphDatabaseFactory;
import org.neo4j.test.impl.EphemeralFileSystemAbstraction;
import org.neo4j.unsafe.batchinsert.BatchInserters;

public class TestBatchDatabase {
    private final String storeDir = "/tmp/dblala";
    private EphemeralFileSystemAbstraction fs;

    @Test
    public void shouldCreateLabeledNodes() {
        GraphDatabaseService gdb = BatchInserters.batchDatabase((String)"/tmp/dblala", (FileSystemAbstraction)this.fs);
        Label luluLabel = DynamicLabel.label((String)"lulu");
        long nodeId = gdb.createNode(new Label[]{luluLabel}).getId();
        gdb = this.turnIntoRealGraphDatabase(gdb);
        Transaction transaction = gdb.beginTx();
        Assert.assertThat((Object)gdb.getNodeById(nodeId), Neo4jMatchers.hasLabels(luluLabel));
        transaction.finish();
        gdb.shutdown();
    }

    @Test
    public void shouldCreateAndSeeLabeledNodes() {
        GraphDatabaseService gdb = BatchInserters.batchDatabase((String)"/tmp/dblala", (FileSystemAbstraction)this.fs);
        Label luluLabel = DynamicLabel.label((String)"lulu");
        long nodeId = gdb.createNode(new Label[]{luluLabel}).getId();
        Assert.assertThat((Object)gdb.getNodeById(nodeId), Neo4jMatchers.hasLabels(luluLabel));
    }

    @Test
    public void shouldCreateAndTestLabeledNodes() {
        GraphDatabaseService gdb = BatchInserters.batchDatabase((String)"/tmp/dblala", (FileSystemAbstraction)this.fs);
        Label luluLabel = DynamicLabel.label((String)"lulu");
        long nodeId = gdb.createNode(new Label[]{luluLabel}).getId();
        Assert.assertThat((Object)gdb.getNodeById(nodeId), Neo4jMatchers.hasLabels(luluLabel));
    }

    @Test
    public void shouldAddLabelToNode() {
        GraphDatabaseService gdb = BatchInserters.batchDatabase((String)"/tmp/dblala", (FileSystemAbstraction)this.fs);
        Label luluLabel = DynamicLabel.label((String)"lulu");
        Node node = gdb.createNode();
        node.addLabel(luluLabel);
        Assert.assertThat((Object)node, Neo4jMatchers.hasLabels(luluLabel));
    }

    @Test
    public void shouldAddLabelTwiceToNode() {
        GraphDatabaseService gdb = BatchInserters.batchDatabase((String)"/tmp/dblala", (FileSystemAbstraction)this.fs);
        Label luluLabel = DynamicLabel.label((String)"lulu");
        Node node = gdb.createNode();
        node.addLabel(luluLabel);
        node.addLabel(luluLabel);
        Assert.assertThat((Object)node, Neo4jMatchers.hasLabels(luluLabel));
    }

    @Test
    public void removingNonExistantLabelFromNodeShouldBeNoOp() {
        GraphDatabaseService gdb = BatchInserters.batchDatabase((String)"/tmp/dblala", (FileSystemAbstraction)this.fs);
        Label luluLabel = DynamicLabel.label((String)"lulu");
        Node node = gdb.createNode();
        node.removeLabel(luluLabel);
        Assert.assertTrue((boolean)IteratorUtil.asSet((Iterable)gdb.getNodeById(node.getId()).getLabels()).isEmpty());
    }

    @Test
    public void shouldRemoveLabelFromNode() {
        GraphDatabaseService gdb = BatchInserters.batchDatabase((String)"/tmp/dblala", (FileSystemAbstraction)this.fs);
        Label luluLabel = DynamicLabel.label((String)"lulu");
        Label lalaLabel = DynamicLabel.label((String)"lala");
        Node node = gdb.createNode();
        node.addLabel(lalaLabel);
        node.addLabel(luluLabel);
        node.removeLabel(luluLabel);
        Assert.assertThat((Object)node, Neo4jMatchers.hasLabels(lalaLabel));
    }

    private GraphDatabaseService turnIntoRealGraphDatabase(GraphDatabaseService gdb) {
        gdb.shutdown();
        TestGraphDatabaseFactory factory = new TestGraphDatabaseFactory();
        factory.setFileSystem(this.fs);
        return factory.newImpermanentDatabase("/tmp/dblala");
    }

    @Before
    public void before() {
        this.fs = new EphemeralFileSystemAbstraction();
    }

    @After
    public void after() {
        this.fs.shutdown();
    }
}

