/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.junit.Assert;
import org.junit.Test;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArrayFactory;

public class DynamicLongArrayTest {
    @Test
    public void shouldWorkOnSingleChunk() throws Exception {
        LongArray array = LongArrayFactory.AUTO.newDynamicLongArray(10L);
        array.setAll(0L);
        array.set(4L, 5L);
        Assert.assertEquals((long)5L, (long)array.get(4L));
        Assert.assertEquals((long)0L, (long)array.get(12L));
        array.set(12L, 13L);
        Assert.assertEquals((long)13L, (long)array.get(12L));
    }

    @Test
    public void shouldAddManyChunks() throws Exception {
        LongArray array = LongArrayFactory.AUTO.newDynamicLongArray(10L);
        long index = 243L;
        long value = 5485748L;
        array.set(index, value);
        Assert.assertEquals((long)value, (long)array.get(index));
    }
}

