/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.cache;

import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.neo4j.unsafe.impl.batchimport.cache.AvailableMemoryCalculator;
import org.neo4j.unsafe.impl.batchimport.cache.DynamicLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.HeapLongArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArray;
import org.neo4j.unsafe.impl.batchimport.cache.LongArrayFactory;
import org.neo4j.unsafe.impl.batchimport.cache.OffHeapLongArray;

public class LongArrayFactoryTest {
    private static final int KILO = 1024;
    private static final long MEGA = 0x100000L;
    private static final long GIGA = 0x40000000L;

    @Test
    public void shouldAllocateOnHeapIfAvailable() throws Exception {
        AvailableMemoryCalculator memory = (AvailableMemoryCalculator)Mockito.mock(AvailableMemoryCalculator.class);
        Mockito.when((Object)memory.availableHeapMemory()).thenReturn((Object)0xA00000L);
        LongArrayFactory.AutoLongArrayFactory factory = new LongArrayFactory.AutoLongArrayFactory(memory, 10240L);
        LongArray array = factory.newLongArray(1024L);
        Assert.assertTrue((boolean)(array instanceof HeapLongArray));
    }

    @Test
    public void shouldAllocateOffHeapIfNotEnoughHeapAvailable() throws Exception {
        AvailableMemoryCalculator memory = (AvailableMemoryCalculator)Mockito.mock(AvailableMemoryCalculator.class);
        Mockito.when((Object)memory.availableHeapMemory()).thenReturn((Object)0x100000L);
        Mockito.when((Object)memory.availableOffHeapMemory()).thenReturn((Object)0xA00000L);
        LongArrayFactory.AutoLongArrayFactory factory = new LongArrayFactory.AutoLongArrayFactory(memory, 10240L);
        LongArray array = factory.newLongArray(0x100000L);
        Assert.assertTrue((boolean)(array instanceof OffHeapLongArray));
    }

    @Test
    public void shouldAllocateDynamicGrowingInBothHeapAndOffHeapIfEnoughCollectiveMemoryAvailable() throws Exception {
        AvailableMemoryCalculator memory = (AvailableMemoryCalculator)Mockito.mock(AvailableMemoryCalculator.class);
        Mockito.when((Object)memory.availableHeapMemory()).thenReturn((Object)0x500000L);
        Mockito.when((Object)memory.availableOffHeapMemory()).thenReturn((Object)0x500000L);
        LongArrayFactory.AutoLongArrayFactory factory = new LongArrayFactory.AutoLongArrayFactory(memory, 10240L);
        LongArray array = factory.newLongArray(0x100000L);
        Assert.assertTrue((boolean)(array instanceof DynamicLongArray));
    }
}

