/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Arrays;
import org.junit.After;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.configuration.Config;
import org.neo4j.kernel.impl.nioneo.store.Buffer;
import org.neo4j.kernel.impl.nioneo.store.OperationType;
import org.neo4j.kernel.impl.nioneo.store.PersistenceWindow;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.kernel.impl.nioneo.store.windowpool.WindowPool;
import org.neo4j.kernel.impl.util.StringLogger;
import org.neo4j.test.EphemeralFileSystemRule;
import org.neo4j.unsafe.impl.batchimport.store.BatchingWindowPoolFactory;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;

public class BatchingWindowPoolFactoryTest {
    @Rule
    public final EphemeralFileSystemRule fs = new EphemeralFileSystemRule();
    private final int recordSize = 20;
    private final int recordsPerWindow = 10;
    private final int windowSize = 200;
    private final File file = new File("store");
    private TrackingStoreChannel channel;

    @Test
    public void shouldOnlyReadFirstWindowInAppendOnlyMode() throws Exception {
        byte[] someBytes = new byte[]{1, 2, 3, 4, 5};
        this.prepopulateChannel(this.data(0, 0, someBytes));
        this.prepopulateChannel(this.data(1, 0, someBytes));
        Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
        WindowPool pool = this.pool(monitor, BatchingWindowPoolFactory.Mode.APPEND_ONLY);
        PersistenceWindow window = pool.acquire(this.recordId(0, 0), OperationType.READ);
        Buffer buffer = window.getOffsettedBuffer(0L);
        byte[] readData = new byte[someBytes.length];
        buffer.get(readData);
        Assert.assertArrayEquals((byte[])someBytes, (byte[])readData);
        try {
            pool.acquire(this.recordId(1, 0), OperationType.READ);
            Assert.fail((String)"Shouldn't be able to read from window other than 0");
        }
        catch (Throwable e) {
            // empty catch block
        }
    }

    @Test
    public void shouldReadAnyRecordInUpdateMode() throws Exception {
        byte[] someBytes = new byte[]{1, 2, 3, 4, 5};
        byte[] someOtherBytes = new byte[]{6, 7, 8, 9, 10};
        this.prepopulateChannel(this.data(0, 0, someBytes));
        this.prepopulateChannel(this.data(1, 0, someOtherBytes));
        Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
        WindowPool pool = this.pool(monitor, BatchingWindowPoolFactory.Mode.UPDATE);
        PersistenceWindow window = pool.acquire(this.recordId(0, 0), OperationType.READ);
        Buffer buffer = window.getOffsettedBuffer(0L);
        byte[] readData = new byte[someBytes.length];
        buffer.get(readData);
        Assert.assertArrayEquals((byte[])someBytes, (byte[])readData);
        window = pool.acquire(this.recordId(1, 0), OperationType.READ);
        buffer = window.getOffsettedBuffer(this.recordId(1, 0));
        readData = new byte[someBytes.length];
        buffer.get(readData);
        Assert.assertArrayEquals((byte[])someOtherBytes, (byte[])readData);
    }

    @Test
    public void shouldWriteWindowChangesToChannelBeforeWhenMovingIt() throws Exception {
        byte[] someBytes = new byte[]{1, 2, 3, 4, 5};
        byte[] someOtherBytes = new byte[]{6, 7, 8, 9, 10};
        Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
        WindowPool pool = this.pool(monitor, BatchingWindowPoolFactory.Mode.APPEND_ONLY);
        PersistenceWindow window = pool.acquire(this.recordId(0, 0), OperationType.WRITE);
        window.getOffsettedBuffer(this.recordId(0, 0)).put(someBytes);
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)0))).dataWritten(Matchers.anyInt());
        window = pool.acquire(this.recordId(0, 3), OperationType.WRITE);
        window.getOffsettedBuffer(this.recordId(0, 3)).put(someOtherBytes);
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)0))).dataWritten(Matchers.anyInt());
        window = pool.acquire(this.recordId(1, 0), OperationType.WRITE);
        ((Monitor)Mockito.verify((Object)monitor, (VerificationMode)Mockito.times((int)1))).dataWritten(Matchers.anyInt());
        this.verifyData(this.recordId(0, 0), someBytes);
        this.verifyData(this.recordId(0, 3), someOtherBytes);
    }

    @Test
    public void shouldZeroOutWindowBetweenUses() throws Exception {
        byte[] someBytes = new byte[]{1, 2, 3, 4, 5};
        Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
        WindowPool pool = this.pool(monitor, BatchingWindowPoolFactory.Mode.APPEND_ONLY);
        PersistenceWindow window = pool.acquire(this.recordId(1, 2), OperationType.WRITE);
        window.getOffsettedBuffer(this.recordId(1, 2)).put(someBytes);
        window = pool.acquire(this.recordId(2, 2), OperationType.WRITE);
        byte[] readBack = new byte[someBytes.length];
        window.getOffsettedBuffer(this.recordId(2, 2)).get(readBack);
        byte[] zeros = new byte[someBytes.length];
        Arrays.fill(zeros, (byte)0);
        Assert.assertArrayEquals((byte[])zeros, (byte[])readBack);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFlushWhenToldTo() throws Exception {
        Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
        WindowPool pool = this.pool(monitor, BatchingWindowPoolFactory.Mode.APPEND_ONLY);
        PersistenceWindow window = pool.acquire(0L, OperationType.WRITE);
        try {
            Buffer buffer = window.getOffsettedBuffer(0L);
            buffer.putInt(1234);
        }
        finally {
            pool.release(window);
        }
        pool.flushAll();
        ((Monitor)Mockito.verify((Object)monitor)).dataWritten(200);
    }

    private void verifyData(long recordId, byte[] expectedData) throws IOException {
        try (StoreChannel channel = this.openChannel();){
            channel.position(this.recordPosition(recordId));
            byte[] readData = new byte[expectedData.length];
            channel.read(ByteBuffer.wrap(readData));
            Assert.assertArrayEquals((byte[])expectedData, (byte[])readData);
        }
    }

    private long recordPosition(long recordId) {
        return recordId * 20L;
    }

    private long recordId(int windowIndex, int recordInWindowIndex) {
        return windowIndex * 10 + recordInWindowIndex;
    }

    private void prepopulateChannel(Data ... datas) throws IOException {
        try (StoreChannel channel = this.openChannel();){
            for (Data data : datas) {
                data.writeTo(channel);
            }
        }
    }

    private StoreChannel openChannel() throws IOException {
        return this.fs.get().open(this.file, "rw");
    }

    private Data data(int windowIndex, int recordInWindowIndex, byte[] someBytes) {
        return new Data(this.recordId(windowIndex, recordInWindowIndex) * 20L, someBytes);
    }

    private WindowPool pool(Monitor monitor, BatchingWindowPoolFactory.Mode mode) throws IOException {
        this.channel = new TrackingStoreChannel(this.openChannel());
        BatchingWindowPoolFactory factory = new BatchingWindowPoolFactory(200, monitor, mode, BatchingWindowPoolFactory.SYNCHRONOUS);
        return factory.create(this.file, 20, (StoreChannel)this.channel, new Config(), StringLogger.DEV_NULL, 0);
    }

    @After
    public void after() throws IOException {
        this.channel.close();
    }

    public class Data {
        private final long position;
        private final byte[] data;

        public Data(long position, byte[] data) {
            this.position = position;
            this.data = data;
        }

        public void writeTo(StoreChannel channel) throws IOException {
            channel.position(this.position);
            channel.write(ByteBuffer.wrap(this.data));
        }
    }

    private static class TrackingStoreChannel
    implements StoreChannel {
        private final StoreChannel delegate;

        public TrackingStoreChannel(StoreChannel delegate) {
            this.delegate = delegate;
        }

        public long read(ByteBuffer[] dsts, int offset, int length) throws IOException {
            return this.delegate.read(dsts, offset, length);
        }

        public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
            return this.delegate.write(srcs, offset, length);
        }

        public FileLock tryLock() throws IOException {
            return this.delegate.tryLock();
        }

        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        public void close() throws IOException {
            this.delegate.close();
        }

        public int read(ByteBuffer dst) throws IOException {
            return this.delegate.read(dst);
        }

        public int write(ByteBuffer src, long position) throws IOException {
            return this.delegate.write(src, position);
        }

        public MappedByteBuffer map(FileChannel.MapMode mode, long position, long size) throws IOException {
            return this.delegate.map(mode, position, size);
        }

        public int read(ByteBuffer dst, long position) throws IOException {
            return this.delegate.read(dst, position);
        }

        public void force(boolean metaData) throws IOException {
            this.delegate.force(metaData);
        }

        public StoreChannel position(long newPosition) throws IOException {
            return this.delegate.position(newPosition);
        }

        public int write(ByteBuffer src) throws IOException {
            return this.delegate.write(src);
        }

        public StoreChannel truncate(long size) throws IOException {
            return this.delegate.truncate(size);
        }

        public long position() throws IOException {
            return this.delegate.position();
        }

        public long read(ByteBuffer[] dsts) throws IOException {
            return this.delegate.read(dsts);
        }

        public long size() throws IOException {
            return this.delegate.size();
        }

        public long write(ByteBuffer[] srcs) throws IOException {
            return this.delegate.write(srcs);
        }

        public void writeAll(ByteBuffer src, long position) throws IOException {
            this.delegate.writeAll(src, position);
        }

        public void writeAll(ByteBuffer src) throws IOException {
            this.delegate.writeAll(src);
        }
    }
}

