/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store;

import java.util.concurrent.Future;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.neo4j.helpers.Factory;
import org.neo4j.test.OtherThreadExecutor;
import org.neo4j.test.OtherThreadRule;
import org.neo4j.unsafe.impl.batchimport.store.io.SimplePool;

public class SimplePoolTest {
    @Rule
    public final OtherThreadRule<Void> t2 = new OtherThreadRule();
    private final Factory<Item> ITEM_FACTORY = new Factory<Item>(){
        int itemIndex;

        public Item newInstance() {
            return new Item(this.itemIndex++);
        }
    };

    @Test
    public void shouldWaitForFreeItem() throws Exception {
        final SimplePool pool = new SimplePool(2, this.ITEM_FACTORY);
        Item first = (Item)pool.acquire();
        Assert.assertEquals((long)0L, (long)first.id);
        Item second = (Item)pool.acquire();
        Assert.assertEquals((long)1L, (long)second.id);
        Future<Item> thirdFuture = this.t2.execute(new OtherThreadExecutor.WorkerCommand<Void, Item>(){

            @Override
            public Item doWork(Void state) throws Exception {
                return (Item)pool.acquire();
            }
        });
        Assert.assertThat(this.t2, OtherThreadRule.isThreadState(Thread.State.TIMED_WAITING));
        pool.release((Object)first);
        Item third = thirdFuture.get();
        Assert.assertEquals((long)0L, (long)third.id);
    }

    @Test
    public void shouldNotRelyOnAcquireReleaseOrdering() {
        SimplePool pool = new SimplePool(2, this.ITEM_FACTORY);
        Item first = (Item)pool.acquire();
        Item second = (Item)pool.acquire();
        pool.release((Object)second);
        Assert.assertNotEquals((Object)first, (Object)pool.acquire());
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowWhenNonPooledObjectIsReleased() {
        SimplePool pool = new SimplePool(2, this.ITEM_FACTORY);
        pool.release((Object)new Item(42));
    }

    private static class Item {
        final int id;

        Item(int id) {
            this.id = id;
        }
    }
}

