/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store.io;

import java.nio.ByteBuffer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.kernel.impl.nioneo.store.StoreChannel;
import org.neo4j.test.CleanupRule;
import org.neo4j.unsafe.impl.batchimport.store.BatchingWindowPoolFactory;
import org.neo4j.unsafe.impl.batchimport.store.io.IoQueue;
import org.neo4j.unsafe.impl.batchimport.store.io.Monitor;
import org.neo4j.unsafe.impl.batchimport.store.io.SimplePool;

public class IoQueueTest {
    @Rule
    public final CleanupRule cleanupRule = new CleanupRule();
    private final ExecutorService executor = (ExecutorService)this.cleanupRule.add(Mockito.spy((Object)Executors.newFixedThreadPool(3)));
    private final IoQueue queue = new IoQueue(this.executor, BatchingWindowPoolFactory.SYNCHRONOUS);
    private final Monitor monitor = (Monitor)Mockito.mock(Monitor.class);
    private final ByteBuffer buffer = ByteBuffer.allocate(10);

    @Test
    public void shouldExecuteWriteJob() throws Exception {
        StoreChannel channel = (StoreChannel)Mockito.mock(StoreChannel.class);
        BatchingWindowPoolFactory.Writer writer = this.queue.create(channel, this.monitor);
        SimplePool pool = (SimplePool)Mockito.mock(SimplePool.class);
        int position = 100;
        writer.write(this.buffer, (long)position, pool);
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).submit((Callable)Matchers.any(Callable.class));
        ((StoreChannel)Mockito.verify((Object)channel, (VerificationMode)Mockito.times((int)1))).write(this.buffer, (long)position);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channel});
    }

    @Test
    public void shouldExecuteWriteJobsForMultipleFiles() throws Exception {
        StoreChannel channel1 = (StoreChannel)Mockito.mock(StoreChannel.class);
        StoreChannel channel2 = (StoreChannel)Mockito.mock(StoreChannel.class);
        BatchingWindowPoolFactory.Writer writer1 = this.queue.create(channel1, this.monitor);
        BatchingWindowPoolFactory.Writer writer2 = this.queue.create(channel2, this.monitor);
        SimplePool pool1 = (SimplePool)Mockito.mock(SimplePool.class);
        SimplePool pool2 = (SimplePool)Mockito.mock(SimplePool.class);
        int position1 = 100;
        int position2 = 100 + this.buffer.capacity();
        int position3 = 50;
        writer1.write(this.buffer, 100L, pool1);
        writer1.write(this.buffer, (long)position2, pool1);
        writer2.write(this.buffer, 50L, pool2);
        this.executor.shutdown();
        this.executor.awaitTermination(10L, TimeUnit.SECONDS);
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.atLeast((int)2))).submit((Callable)Matchers.any(Callable.class));
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.atMost((int)3))).submit((Callable)Matchers.any(Callable.class));
        ((StoreChannel)Mockito.verify((Object)channel1, (VerificationMode)Mockito.times((int)1))).write(this.buffer, 100L);
        ((StoreChannel)Mockito.verify((Object)channel1, (VerificationMode)Mockito.times((int)1))).write(this.buffer, (long)position2);
        ((StoreChannel)Mockito.verify((Object)channel2, (VerificationMode)Mockito.times((int)1))).write(this.buffer, 50L);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channel1});
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{channel2});
    }
}

