/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.unsafe.impl.batchimport.store.io;

import java.util.concurrent.ExecutorService;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.neo4j.unsafe.impl.batchimport.store.io.JobMonitor;
import org.neo4j.unsafe.impl.batchimport.store.io.WriteJob;
import org.neo4j.unsafe.impl.batchimport.store.io.WriteQueue;

public class WriteQueueTest {
    private final ExecutorService executor = (ExecutorService)Mockito.mock(ExecutorService.class);
    private final JobMonitor jobMonitor = new JobMonitor();
    private final WriteQueue queue = new WriteQueue(this.executor, this.jobMonitor);
    private final WriteJob JOB1 = (WriteJob)Mockito.mock(WriteJob.class);
    private final WriteJob JOB2 = (WriteJob)Mockito.mock(WriteJob.class);
    private final WriteJob JOB3 = (WriteJob)Mockito.mock(WriteJob.class);

    @Test
    public void shouldExecuteTheJobImmediately() throws Exception {
        Assert.assertFalse((boolean)this.jobMonitor.hasActiveJobs());
        this.queue.offer(this.JOB1);
        Assert.assertTrue((boolean)this.jobMonitor.hasActiveJobs());
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).submit(this.queue);
        this.queue.call();
        ((WriteJob)Mockito.verify((Object)this.JOB1, (VerificationMode)Mockito.times((int)1))).execute();
        Assert.assertFalse((boolean)this.jobMonitor.hasActiveJobs());
    }

    @Test
    public void shouldSubmitToExecutorOnlyIfTheQueueWasEmpty() throws Exception {
        Assert.assertFalse((boolean)this.jobMonitor.hasActiveJobs());
        this.queue.offer(this.JOB1);
        Mockito.reset((Object[])new ExecutorService[]{this.executor});
        this.queue.offer(this.JOB2);
        Assert.assertTrue((boolean)this.jobMonitor.hasActiveJobs());
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.never())).submit(this.queue);
    }

    @Test
    public void shouldDrainAllOfferedAtOnce() throws Exception {
        Assert.assertFalse((boolean)this.jobMonitor.hasActiveJobs());
        this.queue.offer(this.JOB1);
        this.queue.offer(this.JOB2);
        Assert.assertTrue((boolean)this.jobMonitor.hasActiveJobs());
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).submit(this.queue);
        this.queue.call();
        ((WriteJob)Mockito.verify((Object)this.JOB1, (VerificationMode)Mockito.times((int)1))).execute();
        ((WriteJob)Mockito.verify((Object)this.JOB2, (VerificationMode)Mockito.times((int)1))).execute();
        ((WriteJob)Mockito.verify((Object)this.JOB3, (VerificationMode)Mockito.never())).execute();
        Assert.assertFalse((boolean)this.jobMonitor.hasActiveJobs());
        Mockito.reset((Object[])new Object[]{this.executor, this.JOB1, this.JOB2, this.JOB3});
        this.queue.offer(this.JOB3);
        Assert.assertTrue((boolean)this.jobMonitor.hasActiveJobs());
        ((ExecutorService)Mockito.verify((Object)this.executor, (VerificationMode)Mockito.times((int)1))).submit(this.queue);
        this.queue.call();
        ((WriteJob)Mockito.verify((Object)this.JOB1, (VerificationMode)Mockito.never())).execute();
        ((WriteJob)Mockito.verify((Object)this.JOB2, (VerificationMode)Mockito.never())).execute();
        ((WriteJob)Mockito.verify((Object)this.JOB3, (VerificationMode)Mockito.times((int)1))).execute();
        Assert.assertFalse((boolean)this.jobMonitor.hasActiveJobs());
    }
}

