/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import org.neo4j.kernel.api.TokenNameLookup;
import org.neo4j.kernel.impl.api.index.IndexProxy;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJob;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobFactory;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingJob;
import org.neo4j.kernel.logging.Logging;

public class OnlineIndexSamplingJobFactory
implements IndexSamplingJobFactory {
    private final IndexStoreView storeView;
    private final Logging logging;
    private final TokenNameLookup nameLookup;

    public OnlineIndexSamplingJobFactory(IndexStoreView storeView, TokenNameLookup nameLookup, Logging logging) {
        this.storeView = storeView;
        this.logging = logging;
        this.nameLookup = nameLookup;
    }

    @Override
    public IndexSamplingJob create(IndexProxy indexProxy) {
        String indexUserDescription = indexProxy.getDescriptor().userDescription(this.nameLookup);
        return new OnlineIndexSamplingJob(indexProxy, this.storeView, indexUserDescription, this.logging);
    }
}

