/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.neo4j.collection.primitive.PrimitiveIntCollections;
import org.neo4j.collection.primitive.PrimitiveIntIterator;
import org.neo4j.collection.primitive.PrimitiveLongCollections;
import org.neo4j.collection.primitive.PrimitiveLongIterator;
import org.neo4j.cursor.Cursor;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.TransactionFailureException;
import org.neo4j.helpers.Function;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.Predicates;
import org.neo4j.helpers.Provider;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.helpers.collection.IteratorUtil;
import org.neo4j.kernel.api.EntityType;
import org.neo4j.kernel.api.constraints.UniquenessConstraint;
import org.neo4j.kernel.api.exceptions.EntityNotFoundException;
import org.neo4j.kernel.api.exceptions.LabelNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.PropertyKeyIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.RelationshipTypeIdNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.index.IndexNotFoundKernelException;
import org.neo4j.kernel.api.exceptions.schema.IndexBrokenKernelException;
import org.neo4j.kernel.api.exceptions.schema.SchemaRuleNotFoundException;
import org.neo4j.kernel.api.exceptions.schema.TooManyLabelsException;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.InternalIndexState;
import org.neo4j.kernel.api.properties.DefinedProperty;
import org.neo4j.kernel.api.properties.Property;
import org.neo4j.kernel.impl.api.CountsAccessor;
import org.neo4j.kernel.impl.api.DegreeVisitor;
import org.neo4j.kernel.impl.api.KernelStatement;
import org.neo4j.kernel.impl.api.RelationshipVisitor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.store.StoreReadLayer;
import org.neo4j.kernel.impl.core.LabelTokenHolder;
import org.neo4j.kernel.impl.core.PropertyKeyTokenHolder;
import org.neo4j.kernel.impl.core.RelationshipTypeTokenHolder;
import org.neo4j.kernel.impl.core.Token;
import org.neo4j.kernel.impl.core.TokenNotFoundException;
import org.neo4j.kernel.impl.store.InvalidRecordException;
import org.neo4j.kernel.impl.store.NeoStore;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.SchemaStorage;
import org.neo4j.kernel.impl.store.UnderlyingStorageException;
import org.neo4j.kernel.impl.store.UniquenessConstraintRule;
import org.neo4j.kernel.impl.store.record.IndexRule;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.SchemaRule;
import org.neo4j.kernel.impl.util.IoPrimitiveUtils;
import org.neo4j.kernel.impl.util.PrimitiveLongResourceIterator;
import org.neo4j.kernel.impl.util.register.NeoRegister;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;

public class DiskLayer
implements StoreReadLayer {
    private static final Function<UniquenessConstraintRule, UniquenessConstraint> UNIQUENESS_CONSTRAINT_TO_RULE = new Function<UniquenessConstraintRule, UniquenessConstraint>(){

        public UniquenessConstraint apply(UniquenessConstraintRule rule) {
            return new UniquenessConstraint(rule.getLabel(), rule.getPropertyKey());
        }
    };
    private final PropertyKeyTokenHolder propertyKeyTokenHolder;
    private final LabelTokenHolder labelTokenHolder;
    private final RelationshipTypeTokenHolder relationshipTokenHolder;
    private final NeoStore neoStore;
    private final IndexingService indexService;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final PropertyStore propertyStore;
    private final SchemaStorage schemaStorage;
    private final Provider<PropertyStore> propertyStoreProvider;
    private final CountsAccessor counts;
    private static final Predicate<SchemaRule> INDEX_RULES = new Predicate<SchemaRule>(){

        @Override
        public boolean accept(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.INDEX_RULE;
        }
    };
    private static final Predicate<SchemaRule> CONSTRAINT_INDEX_RULES = new Predicate<SchemaRule>(){

        @Override
        public boolean accept(SchemaRule rule) {
            return rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
        }
    };

    public DiskLayer(PropertyKeyTokenHolder propertyKeyTokenHolder, LabelTokenHolder labelTokenHolder, RelationshipTypeTokenHolder relationshipTokenHolder, SchemaStorage schemaStorage, Provider<NeoStore> neoStoreProvider, IndexingService indexService) {
        this.relationshipTokenHolder = relationshipTokenHolder;
        this.schemaStorage = schemaStorage;
        this.indexService = indexService;
        this.propertyKeyTokenHolder = propertyKeyTokenHolder;
        this.labelTokenHolder = labelTokenHolder;
        this.neoStore = neoStoreProvider.instance();
        this.nodeStore = this.neoStore.getNodeStore();
        this.relationshipStore = this.neoStore.getRelationshipStore();
        this.propertyStore = this.neoStore.getPropertyStore();
        this.propertyStoreProvider = new PropertyStoreProvider(neoStoreProvider);
        this.counts = this.neoStore.getCounts();
    }

    @Override
    public int labelGetOrCreateForName(String label) throws TooManyLabelsException {
        try {
            return this.labelTokenHolder.getOrCreateId(label);
        }
        catch (TransactionFailureException e) {
            if (e.getCause() instanceof UnderlyingStorageException && e.getCause().getMessage().equals("Id capacity exceeded")) {
                throw new TooManyLabelsException(e);
            }
            throw e;
        }
    }

    @Override
    public int labelGetForName(String label) {
        return this.labelTokenHolder.getIdByName(label);
    }

    @Override
    public boolean nodeHasLabel(long nodeId, int labelId) {
        try {
            return PrimitiveIntCollections.indexOf((PrimitiveIntIterator)this.nodeGetLabels(nodeId), (int)labelId) != -1;
        }
        catch (InvalidRecordException e) {
            return false;
        }
    }

    @Override
    public PrimitiveIntIterator nodeGetLabels(long nodeId) {
        try {
            final long[] labels = NodeLabelsField.parseLabelsField(this.nodeStore.getRecord(nodeId)).get(this.nodeStore);
            return new PrimitiveIntIterator(){
                private int cursor;

                public boolean hasNext() {
                    return this.cursor < labels.length;
                }

                public int next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return IoPrimitiveUtils.safeCastLongToInt(labels[this.cursor++]);
                }
            };
        }
        catch (InvalidRecordException e) {
            return PrimitiveIntCollections.emptyIterator();
        }
    }

    @Override
    public PrimitiveLongIterator nodeListRelationships(long nodeId, Direction direction) throws EntityNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrimitiveLongIterator nodeListRelationships(long nodeId, Direction direction, int[] relTypes) throws EntityNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction) throws EntityNotFoundException {
        throw new UnsupportedOperationException("expected to be answered by cache");
    }

    @Override
    public int nodeGetDegree(long nodeId, Direction direction, int relType) throws EntityNotFoundException {
        throw new UnsupportedOperationException("expected to be answered by cache");
    }

    @Override
    public boolean nodeVisitDegrees(long nodeId, DegreeVisitor visitor) {
        throw new UnsupportedOperationException("expected to be answered by cache");
    }

    @Override
    public PrimitiveIntIterator nodeGetRelationshipTypes(long nodeId) throws EntityNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public String labelGetName(int labelId) throws LabelNotFoundKernelException {
        try {
            return ((Token)this.labelTokenHolder.getTokenById(labelId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new LabelNotFoundKernelException("Label by id " + labelId, e);
        }
    }

    @Override
    public PrimitiveLongIterator nodesGetForLabel(KernelStatement state, int labelId) {
        return state.getLabelScanReader().nodesWithLabel(labelId);
    }

    @Override
    public PrimitiveLongResourceIterator nodesGetFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IndexDescriptor indexesGetForLabelAndPropertyKey(int labelId, int propertyKey) {
        return DiskLayer.descriptor(this.schemaStorage.indexRule(labelId, propertyKey));
    }

    private static IndexDescriptor descriptor(IndexRule ruleRecord) {
        return new IndexDescriptor(ruleRecord.getLabel(), ruleRecord.getPropertyKey());
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        return this.getIndexDescriptorsFor(DiskLayer.indexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> indexesGetAll() {
        return this.getIndexDescriptorsFor(INDEX_RULES);
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetForLabel(int labelId) {
        return this.getIndexDescriptorsFor(DiskLayer.constraintIndexRules(labelId));
    }

    @Override
    public Iterator<IndexDescriptor> uniqueIndexesGetAll() {
        return this.getIndexDescriptorsFor(CONSTRAINT_INDEX_RULES);
    }

    private static Predicate<SchemaRule> indexRules(final int labelId) {
        return new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.INDEX_RULE;
            }
        };
    }

    private static Predicate<SchemaRule> constraintIndexRules(final int labelId) {
        return new Predicate<SchemaRule>(){

            @Override
            public boolean accept(SchemaRule rule) {
                return rule.getLabel() == labelId && rule.getKind() == SchemaRule.Kind.CONSTRAINT_INDEX_RULE;
            }
        };
    }

    private Iterator<IndexDescriptor> getIndexDescriptorsFor(Predicate<SchemaRule> filter) {
        Iterator<SchemaRule> filtered = Iterables.filter(filter, this.neoStore.getSchemaStore().loadAllSchemaRules());
        return Iterables.map(new Function<SchemaRule, IndexDescriptor>(){

            public IndexDescriptor apply(SchemaRule from) {
                return DiskLayer.descriptor((IndexRule)from);
            }
        }, filtered);
    }

    @Override
    public boolean nodeExists(long nodeId) {
        return this.nodeStore.inUse(nodeId);
    }

    @Override
    public boolean relationshipExists(long relationshipId) {
        return this.relationshipStore.inUse(relationshipId);
    }

    @Override
    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getOwningConstraint();
    }

    @Override
    public IndexRule indexRule(IndexDescriptor index, SchemaStorage.IndexRuleKind kind) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long indexGetCommittedId(IndexDescriptor index, SchemaStorage.IndexRuleKind kind) throws SchemaRuleNotFoundException {
        return this.schemaStorage.indexRule(index.getLabelId(), index.getPropertyKeyId()).getId();
    }

    @Override
    public InternalIndexState indexGetState(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(this.indexId(descriptor)).getState();
    }

    @Override
    public double indexUniqueValuesPercentage(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.indexUniqueValuesPercentage(this.indexId(descriptor));
    }

    @Override
    public String indexGetFailure(IndexDescriptor descriptor) throws IndexNotFoundKernelException {
        return this.indexService.getIndexProxy(this.indexId(descriptor)).getPopulationFailure().asString();
    }

    private long indexId(IndexDescriptor descriptor) {
        return this.schemaStorage.indexRule(descriptor.getLabelId(), descriptor.getPropertyKeyId()).getId();
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabelAndPropertyKey(int labelId, final int propertyKeyId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, new Predicate<UniquenessConstraintRule>(){

            @Override
            public boolean accept(UniquenessConstraintRule rule) {
                return rule.containsPropertyKeyId(propertyKeyId);
            }
        });
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetForLabel(int labelId) {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, UniquenessConstraintRule.class, labelId, Predicates.TRUE());
    }

    @Override
    public Iterator<UniquenessConstraint> constraintsGetAll() {
        return this.schemaStorage.schemaRules(UNIQUENESS_CONSTRAINT_TO_RULE, SchemaRule.Kind.UNIQUENESS_CONSTRAINT, Predicates.TRUE());
    }

    @Override
    public PrimitiveLongResourceIterator nodeGetUniqueFromIndexLookup(KernelStatement state, IndexDescriptor index, Object value) throws IndexNotFoundKernelException, IndexBrokenKernelException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int propertyKeyGetOrCreateForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getOrCreateId(propertyKey);
    }

    @Override
    public int propertyKeyGetForName(String propertyKey) {
        return this.propertyKeyTokenHolder.getIdByName(propertyKey);
    }

    @Override
    public String propertyKeyGetName(int propertyKeyId) throws PropertyKeyIdNotFoundKernelException {
        try {
            return ((Token)this.propertyKeyTokenHolder.getTokenById(propertyKeyId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new PropertyKeyIdNotFoundKernelException(propertyKeyId, e);
        }
    }

    @Override
    public PrimitiveLongIterator relationshipGetPropertyKeys(long relationshipId) throws EntityNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Property relationshipGetProperty(long relationshipId, int propertyKeyId) throws EntityNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public PrimitiveLongIterator nodeGetPropertyKeys(long nodeId) throws EntityNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Property nodeGetProperty(long nodeId, int propertyKeyId) throws EntityNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<DefinedProperty> nodeGetAllProperties(long nodeId) throws EntityNotFoundException {
        try {
            return this.loadAllPropertiesOf(this.nodeStore.getRecord(nodeId));
        }
        catch (InvalidRecordException e) {
            throw new EntityNotFoundException(EntityType.NODE, nodeId, e);
        }
    }

    @Override
    public Iterator<DefinedProperty> relationshipGetAllProperties(long relationshipId) throws EntityNotFoundException {
        try {
            return this.loadAllPropertiesOf(this.relationshipStore.getRecord(relationshipId));
        }
        catch (InvalidRecordException e) {
            throw new EntityNotFoundException(EntityType.RELATIONSHIP, relationshipId, e);
        }
    }

    @Override
    public PrimitiveLongIterator graphGetPropertyKeys(KernelStatement state) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Property graphGetProperty(int propertyKeyId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<DefinedProperty> graphGetAllProperties() {
        return this.loadAllPropertiesOf(this.neoStore.asRecord());
    }

    public PrimitiveLongResourceIterator nodeGetUniqueFromIndexLookup(KernelStatement state, long indexId, Object value) throws IndexNotFoundKernelException {
        IndexReader reader = state.getFreshIndexReader(indexId);
        return IteratorUtil.resourceIterator(reader.lookup(value), (Resource)reader);
    }

    public PrimitiveLongResourceIterator nodesGetFromIndexLookup(KernelStatement state, long index, Object value) throws IndexNotFoundKernelException {
        IndexReader reader = state.getIndexReader(index);
        return IteratorUtil.resourceIterator(reader.lookup(value), (Resource)reader);
    }

    private Iterator<DefinedProperty> loadAllPropertiesOf(PrimitiveRecord primitiveRecord) {
        Collection<PropertyRecord> records = this.propertyStore.getPropertyRecordChain(primitiveRecord.getNextProp());
        if (null == records) {
            return IteratorUtil.emptyIterator();
        }
        ArrayList<DefinedProperty> properties = new ArrayList<DefinedProperty>();
        for (PropertyRecord record : records) {
            for (PropertyBlock block : record.getPropertyBlocks()) {
                properties.add(block.getType().readProperty(block.getKeyIndexId(), block, this.propertyStoreProvider));
            }
        }
        return properties.iterator();
    }

    @Override
    public Iterator<Token> propertyKeyGetAllTokens() {
        return this.propertyKeyTokenHolder.getAllTokens().iterator();
    }

    @Override
    public Iterator<Token> labelsGetAllTokens() {
        return this.labelTokenHolder.getAllTokens().iterator();
    }

    @Override
    public int relationshipTypeGetForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getIdByName(relationshipTypeName);
    }

    @Override
    public String relationshipTypeGetName(int relationshipTypeId) throws RelationshipTypeIdNotFoundKernelException {
        try {
            return ((Token)this.relationshipTokenHolder.getTokenById(relationshipTypeId)).name();
        }
        catch (TokenNotFoundException e) {
            throw new RelationshipTypeIdNotFoundKernelException(relationshipTypeId, e);
        }
    }

    @Override
    public int relationshipTypeGetOrCreateForName(String relationshipTypeName) {
        return this.relationshipTokenHolder.getOrCreateId(relationshipTypeName);
    }

    @Override
    public <EXCEPTION extends Exception> void relationshipVisit(long relationshipId, RelationshipVisitor<EXCEPTION> relationshipVisitor) throws EntityNotFoundException, EXCEPTION {
        throw new UnsupportedOperationException();
    }

    @Override
    public long highestNodeIdInUse() {
        return this.nodeStore.getHighestPossibleIdInUse();
    }

    @Override
    public PrimitiveLongIterator nodesGetAll() {
        return new PrimitiveLongCollections.PrimitiveLongBaseIterator(){
            private final NodeStore store;
            private long highId;
            private long currentId;
            private final NodeRecord reusableNodeRecord;
            {
                this.store = DiskLayer.this.neoStore.getNodeStore();
                this.highId = this.store.getHighestPossibleIdInUse();
                this.reusableNodeRecord = new NodeRecord(-1L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            protected boolean fetchNext() {
                while (true) {
                    if (this.currentId <= this.highId) {
                        block7: {
                            NodeRecord record = this.store.getRecord(this.currentId, this.reusableNodeRecord);
                            if (record == null || !record.inUse()) break block7;
                            boolean bl = this.next(record.getId());
                            ++this.currentId;
                            return bl;
                        }
                        try {
                            continue;
                            catch (InvalidRecordException e) {
                                // empty catch block
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ++this.currentId;
                            continue;
                        }
                    }
                    long newHighId = this.store.getHighestPossibleIdInUse();
                    if (newHighId <= this.highId) break;
                    this.highId = newHighId;
                }
                return false;
            }
        };
    }

    @Override
    public PrimitiveLongIterator relationshipsGetAll() {
        return new PrimitiveLongCollections.PrimitiveLongBaseIterator(){
            private final RelationshipStore store;
            private long highId;
            private long currentId;
            private final RelationshipRecord reusableRecord;
            {
                this.store = DiskLayer.this.neoStore.getRelationshipStore();
                this.highId = this.store.getHighestPossibleIdInUse();
                this.reusableRecord = new RelationshipRecord(-1L);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            protected boolean fetchNext() {
                while (true) {
                    if (this.currentId <= this.highId) {
                        block7: {
                            if (!this.store.fillRecord(this.currentId, this.reusableRecord, RecordLoad.CHECK) || !this.reusableRecord.inUse()) break block7;
                            boolean bl = this.next(this.reusableRecord.getId());
                            ++this.currentId;
                            return bl;
                        }
                        try {
                            continue;
                            catch (InvalidRecordException e) {
                                // empty catch block
                            }
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ++this.currentId;
                            continue;
                        }
                    }
                    long newHighId = this.store.getHighestPossibleIdInUse();
                    if (newHighId <= this.highId) break;
                    this.highId = newHighId;
                }
                return false;
            }
        };
    }

    @Override
    public long reserveNode() {
        return this.nodeStore.nextId();
    }

    @Override
    public long reserveRelationship() {
        return this.relationshipStore.nextId();
    }

    @Override
    public void releaseNode(long id) {
        this.nodeStore.freeId(id);
    }

    @Override
    public void releaseRelationship(long id) {
        this.relationshipStore.freeId(id);
    }

    @Override
    public Cursor expand(Cursor inputCursor, NeoRegister.Node.In nodeId, Register.Object.In<int[]> types, Register.Object.In<Direction> expandDirection, NeoRegister.Relationship.Out relId, NeoRegister.RelType.Out relType, Register.Object.Out<Direction> direction, NeoRegister.Node.Out startNodeId, NeoRegister.Node.Out neighborNodeId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long countsForNode(int labelId) {
        return this.counts.nodeCount(labelId, Registers.newDoubleLongRegister()).readSecond();
    }

    @Override
    public long countsForRelationship(int startLabelId, int typeId, int endLabelId) {
        if (startLabelId != -1 && endLabelId != -1) {
            throw new UnsupportedOperationException("not implemented");
        }
        return this.counts.relationshipCount(startLabelId, typeId, endLabelId, Registers.newDoubleLongRegister()).readSecond();
    }

    private static class PropertyStoreProvider
    implements Provider<PropertyStore> {
        private final Provider<NeoStore> neoStoreProvider;

        public PropertyStoreProvider(Provider<NeoStore> neoStoreProvider) {
            this.neoStoreProvider = neoStoreProvider;
        }

        @Override
        public PropertyStore instance() {
            return this.neoStoreProvider.instance().getPropertyStore();
        }
    }
}

