/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.core;

import org.neo4j.kernel.impl.core.RelationshipLoadingPosition;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.util.RelIdArray;

public class SingleChainPosition
implements RelationshipLoadingPosition {
    private long position;

    public SingleChainPosition(long firstPosition) {
        this.position = firstPosition;
    }

    @Override
    public long position(RelIdArray.DirectionWrapper direction, int[] types) {
        return this.position;
    }

    @Override
    public long nextPosition(long nextRel, RelIdArray.DirectionWrapper direction, int[] types) {
        this.position = nextRel;
        return nextRel;
    }

    @Override
    public boolean hasMore(RelIdArray.DirectionWrapper direction, int[] types) {
        return this.position != (long)Record.NO_NEXT_RELATIONSHIP.intValue();
    }

    @Override
    public boolean atPosition(RelIdArray.DirectionWrapper direction, int type, long position) {
        return this.position == position;
    }

    @Override
    public void compareAndAdvance(RelIdArray.DirectionWrapper direction, int type, long relIdDeleted, long nextRelId) {
        if (this.position == relIdDeleted) {
            this.position = nextRelId;
        }
    }

    @Override
    public RelationshipLoadingPosition clone() {
        return new SingleChainPosition(this.position);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.position + "]";
    }
}

